/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RangedItemList {
    private List<Cell> _cells = new ArrayList<Cell>();
    private Map<Object, Item> _itemTable = new HashMap<Object, Item>();

    public void debug_PrintList() {
        int cellIndex = 0;
        while (cellIndex < this._cells.size()) {
            Cell cell = this._cells.get(cellIndex);
            System.out.println("Cell: " + cellIndex + "[" + ((Cell)cell)._range.begin + "-" + ((Cell)cell)._range.end + "]");
            int columnIndex = 0;
            while (columnIndex < cell._columnList.size()) {
                System.out.println(" Column: " + columnIndex);
                List column = (List)cell._columnList.get(columnIndex);
                for (Item item : column) {
                    System.out.println("  Item: [" + item.range.begin + "-" + item.range.end + "]");
                }
                ++columnIndex;
            }
            ++cellIndex;
        }
    }

    public void clear() {
        this._cells.clear();
        this._itemTable.clear();
    }

    public int size() {
        int size = 0;
        for (Cell cell : this._cells) {
            for (List column : cell._columnList) {
                size += column.size();
            }
        }
        return size;
    }

    public ItemInformation[] getAllItemInformation() {
        ArrayList<ItemInformation> itemList = new ArrayList<ItemInformation>();
        for (Cell cell : this._cells) {
            int columnIndex = 0;
            while (columnIndex < cell._columnList.size()) {
                List column = (List)cell._columnList.get(columnIndex);
                for (Item item : column) {
                    itemList.add(new ItemInformation(item.key, columnIndex, cell._columnList.size()));
                }
                ++columnIndex;
            }
        }
        ItemInformation[] itemArray = new ItemInformation[itemList.size()];
        itemList.toArray(itemArray);
        return itemArray;
    }

    public ItemInformation getItemInformation(Object key) {
        for (Cell cell : this._cells) {
            int cellIndex = 0;
            while (cellIndex < cell._columnList.size()) {
                List column = (List)cell._columnList.get(cellIndex);
                for (Item item : column) {
                    if (item.key != key) continue;
                    return new ItemInformation(item.key, cellIndex, cell._columnList.size());
                }
                ++cellIndex;
            }
        }
        return null;
    }

    public ItemInformation getItemInformation(int index) {
        int count = 0;
        for (Cell cell : this._cells) {
            int columnIndex = 0;
            while (columnIndex < cell._columnList.size()) {
                List column = (List)cell._columnList.get(columnIndex);
                if (index >= count && index < count + column.size()) {
                    Item item = (Item)column.get(index - count);
                    return new ItemInformation(item.key, columnIndex, cell._columnList.size());
                }
                count += column.size();
                ++columnIndex;
            }
        }
        return null;
    }

    public void addItem(Object key, long begin, long end) {
        Item item = new Item(key, new Range(begin, end));
        this._itemTable.put(key, item);
        Cell prevCell = null;
        boolean itemAdded = false;
        ArrayList<Integer> removedItems = new ArrayList<Integer>();
        int cellIndex = 0;
        while (cellIndex < this._cells.size()) {
            Cell currentCell = this._cells.get(cellIndex);
            if (((Cell)currentCell)._range.begin <= begin && ((Cell)currentCell)._range.end > begin || ((Cell)currentCell)._range.end >= end && ((Cell)currentCell)._range.begin < end || ((Cell)currentCell)._range.begin >= begin && ((Cell)currentCell)._range.end <= end) {
                if (!itemAdded) {
                    currentCell.add(item);
                    itemAdded = true;
                    prevCell = currentCell;
                } else {
                    prevCell.append(currentCell);
                    removedItems.add(new Integer(cellIndex));
                }
            } else {
                if (!itemAdded && end <= ((Cell)currentCell)._range.begin) {
                    Cell newCell = new Cell();
                    newCell.add(item);
                    itemAdded = true;
                    this._cells.add(cellIndex, newCell);
                    break;
                }
                prevCell = currentCell;
            }
            ++cellIndex;
        }
        if (!itemAdded) {
            Cell newCell = new Cell();
            newCell.add(item);
            this._cells.add(newCell);
        }
        int i = removedItems.size() - 1;
        while (i >= 0) {
            int index = (Integer)removedItems.get(i);
            this._cells.remove(index);
            --i;
        }
    }

    public void moveItem(Object key, long begin, long end) {
        this.removeItem(key);
        this.addItem(key, begin, end);
    }

    public void removeItem(Object key) {
        this._itemTable.remove(key);
        for (Cell cell : this._cells) {
            for (List column : cell._columnList) {
                for (Item item : column) {
                    if (item.key != key) continue;
                    cell.remove(item);
                    return;
                }
            }
        }
    }

    private static class Cell {
        private Range _range;
        private List<List<Item>> _columnList = new ArrayList<List<Item>>();

        public Cell() {
            this._range = new Range(0L, 0L);
        }

        public Range getRange() {
            return this._range;
        }

        public int add(Item item) {
            if (this._columnList.size() == 0) {
                this._range.begin = item.range.begin;
                this._range.end = item.range.end;
            } else {
                this._range.begin = Math.min(this._range.begin, item.range.begin);
                this._range.end = Math.max(this._range.end, item.range.end);
            }
            int columnIndex = 0;
            while (columnIndex < this._columnList.size()) {
                List<Item> column = this._columnList.get(columnIndex);
                int insertionPoint = this.findInsertionPoint(column, item);
                if (insertionPoint >= 0) {
                    column.add(insertionPoint, item);
                    return columnIndex;
                }
                ++columnIndex;
            }
            ArrayList<Item> newColumn = new ArrayList<Item>();
            newColumn.add(item);
            this._columnList.add(newColumn);
            return this._columnList.size() - 1;
        }

        public void remove(Item item) {
            for (List<Item> column : this._columnList) {
                int columnIndex = 0;
                while (columnIndex < column.size()) {
                    Item currentItem = column.get(columnIndex);
                    if (currentItem == item) {
                        column.remove(columnIndex);
                        this.pack();
                        return;
                    }
                    ++columnIndex;
                }
            }
        }

        public void move(Item item, long begin, long end) {
            if (begin < this._range.begin || end > this._range.end) {
                throw new IllegalArgumentException("Cannot move item outside cell range");
            }
            int columnIndex = 0;
            while (columnIndex < this._columnList.size()) {
                List<Item> column = this._columnList.get(columnIndex);
                int itemIndex = 0;
                while (itemIndex < column.size()) {
                    Item currentItem = column.get(itemIndex);
                    if (currentItem == item) {
                        boolean fit = true;
                        if (columnIndex > 0 && column.get((int)(columnIndex - 1)).range.end > begin) {
                            fit = false;
                        }
                        if (fit && columnIndex < column.size() - 2 && column.get((int)(columnIndex + 1)).range.begin < end) {
                            fit = false;
                        }
                        if (!fit) {
                            column.remove(itemIndex);
                            this.add(item);
                            this.pack();
                        }
                        return;
                    }
                    ++itemIndex;
                }
                ++columnIndex;
            }
        }

        public void append(Cell cell) {
            for (List<Item> column : cell._columnList) {
                for (Item item : column) {
                    this.add(item);
                }
            }
        }

        private void pack() {
            int columnIndex = this._columnList.size() - 1;
            while (columnIndex >= 0) {
                List<Item> localColumn = this._columnList.get(columnIndex);
                if (localColumn.size() == 0) {
                    this._columnList.remove(columnIndex);
                }
                --columnIndex;
            }
        }

        private int findInsertionPoint(List<Item> column, Item item) {
            int columnSize = column.size();
            if (columnSize == 0) {
                return 0;
            }
            Item prevItem = null;
            Item currentItem = null;
            int itemIndex = 0;
            while (itemIndex < columnSize) {
                currentItem = column.get(itemIndex);
                if (currentItem.range.begin >= item.range.end) {
                    if (prevItem != null && prevItem.range.end > item.range.begin) {
                        return -1;
                    }
                    if (itemIndex < columnSize - 1) {
                        Item nextItem = column.get(itemIndex + 1);
                        if (item.range.end > nextItem.range.begin) {
                            return -1;
                        }
                    }
                    return itemIndex;
                }
                prevItem = currentItem;
                ++itemIndex;
            }
            if (currentItem != null && item.range.begin >= currentItem.range.end) {
                return columnSize;
            }
            return -1;
        }
    }

    private static class Item {
        public Range range;
        public Object key;

        public Item(Object key, Range range) {
            this.key = key;
            this.range = range;
        }
    }

    public static class ItemInformation {
        private Object _key;
        private int _column;
        private int _totalColumns;

        private ItemInformation(Object key, int column, int totalColumns) {
            this._key = key;
            this._column = column;
            this._totalColumns = totalColumns;
        }

        public Object getKey() {
            return this._key;
        }

        public int getColumn() {
            return this._column;
        }

        public int getTotalColumns() {
            return this._totalColumns;
        }
    }

    public static class Range {
        public long begin;
        public long end;

        public Range(long begin, long end) {
            this.begin = begin;
            this.end = end;
        }
    }
}

