/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.calendar.DateTime;
import edu.cmu.cs.radar.rhai.calendar.Time;
import edu.cmu.cs.radar.rhai.spacetime.CalendarGridEntry;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeTimeIntervals;
import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class AvailabilityPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final int DAY_HEADER_HEIGHT = 15;
    private final int HOUR_HEADER_WIDTH = 20;
    private final int HOUR_HEIGHT = 10;
    private final int DAY_WIDTH = 31;
    private final int EARLIEST_HOUR = 7;
    private final int HOURS_IN_DAY = 14;
    private final Time _earliestTime = new Time(7, 0, 0);
    private final Time _latestTime = new Time(21, 0, 0);
    private SpaceTimeNode _roomNode;
    private Date _firstDate;
    private Date _lastDate;
    private List<Date> _days;
    private SpaceTimeTimeIntervals _intervals;
    private static TexturePaint UNAVAILABLE_TEXTURE;

    static {
        ClassLoader classLoader = CalendarGridEntry.class.getClassLoader();
        ImageIcon unavailableIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/unavailable.png"));
        BufferedImage unavailableImage = new BufferedImage(unavailableIcon.getIconHeight(), unavailableIcon.getIconWidth(), 2);
        unavailableImage.createGraphics().drawImage(unavailableIcon.getImage(), 0, 0, null);
        UNAVAILABLE_TEXTURE = new TexturePaint(unavailableImage, new Rectangle2D.Double(0.0, 0.0, unavailableImage.getWidth(), unavailableImage.getHeight()));
    }

    public AvailabilityPanel() {
        this.setBackground(Color.white);
        this._roomNode = null;
        this._days = new ArrayList<Date>();
    }

    public void setRoom(SpaceTimeNode roomNode) {
        this._roomNode = roomNode;
        this.countDays();
        this._intervals = new SpaceTimeTimeIntervals(this._roomNode);
    }

    @Override
    public Dimension getMinimumSize() {
        int width = this.getCalendarGridX() + this.getCalendarGridWidth();
        int height = this.getCalendarGridY() + this.getCalendarGridHeight() + 5;
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void countDays() {
        this._days.clear();
        this._firstDate = new SpaceTimeDate(this._roomNode.getAdapter().getScenarioStart());
        this._lastDate = new SpaceTimeDate(this._roomNode.getAdapter().getScenarioStop());
        Calendar calCurrentDate = Calendar.getInstance();
        Calendar calLastDate = Calendar.getInstance();
        calCurrentDate.setTime(this._firstDate);
        calLastDate.setTime(this._lastDate);
        while (calCurrentDate.before(calLastDate) || calCurrentDate.equals(calLastDate)) {
            this._days.add(new DateTime(calCurrentDate.getTime()).getAsDate());
            calCurrentDate.add(5, 1);
        }
    }

    private int dateToColumn(Date date) {
        int i = 0;
        while (i < this._days.size()) {
            if (date.equals(this._days.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = SwingHelper.prepareGraphics(g);
        if (this._roomNode == null) {
            return;
        }
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setPaint(UNAVAILABLE_TEXTURE);
        g2.fillRect(this.getCalendarGridX(), this.getCalendarGridY(), this.getCalendarGridWidth(), this.getCalendarGridHeight());
        this.paintIntervals(g2);
        this.paintDays(g2);
        this.paintHours(g2);
        g2.setColor(Color.gray);
        g2.drawRect(this.getCalendarGridX(), this.getCalendarGridY(), this.getCalendarGridWidth() - 1, this.getCalendarGridHeight() - 1);
    }

    private void paintIntervals(Graphics2D g2) {
        g2.setColor(Color.white);
        for (SpaceTimeTimeIntervals.Interval interval : this._intervals) {
            int startColumn = this.dateToColumn(new DateTime(interval._start).getAsDate());
            double startY = this.timeToY(new DateTime(interval._start).getAsTime());
            int endColumn = this.dateToColumn(new DateTime(interval._stop).getAsDate());
            Time endTime = new DateTime(interval._stop).getAsTime();
            int column = startColumn;
            while (column <= endColumn) {
                double stopY = this.timeToY(column < endColumn ? Time.END_OF_DAY : endTime);
                int x = this.getCalendarGridX() + column * 32 + 1;
                int y = (int)startY;
                int width = 31;
                int height = (int)(stopY - startY);
                g2.fillRect(x, y, width, height);
                ++column;
                startY = this.timeToY(Time.START_OF_DAY);
            }
        }
    }

    private void paintDays(Graphics2D g2) {
        SimpleDateFormat formatter = new SimpleDateFormat("E");
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        int x = this.getCalendarGridX();
        int bottom = this.getHeight() - 5 - 1;
        for (Date day : this._days) {
            String dayString = formatter.format(day);
            Rectangle2D dayStringBounds = g2.getFontMetrics().getStringBounds(dayString, g2);
            float dayStringLeft = (float)(31.0 - dayStringBounds.getWidth()) / 2.0f;
            g2.setColor(Color.black);
            g2.drawString(dayString, x + 1 + Math.round(dayStringLeft), 14);
            g2.setColor(Color.gray);
            g2.drawLine(x, 14, x, bottom);
            x += 32;
        }
        g2.setColor(Color.gray);
        g2.drawLine(x, 14, x, bottom);
    }

    private void paintHours(Graphics2D g2) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int hourCenteringOffset = fm.getAscent() / 2 - 1;
        int hour = 7;
        while (hour <= 21) {
            int y = this.hourToY(hour);
            int xOffset = 0;
            g2.setColor(Color.black);
            int hour12 = hour > 12 ? hour - 12 : hour;
            String strHour = Integer.toString(hour12);
            int strWidth = fm.stringWidth(strHour);
            g2.drawString(Integer.toString(hour12), 20 - strWidth - 2, y + hourCenteringOffset);
            xOffset = 2;
            g2.setColor(Color.gray);
            g2.drawLine(this.getCalendarGridX() - xOffset, y, this.getWidth(), y);
            ++hour;
        }
    }

    private int getCalendarGridX() {
        return 21;
    }

    private int getCalendarGridY() {
        return 16;
    }

    private int getCalendarGridWidth() {
        return this._days.size() * 32 + 1;
    }

    private int getCalendarGridHeight() {
        return 155;
    }

    private int hourToY(int hour) {
        return this.getCalendarGridY() + 11 * (hour - 7);
    }

    private int timeToY(Time time) {
        return this.getCalendarGridY() + (int)Math.round(Time.interpolate(this._earliestTime, this._latestTime, time) * (double)this.getCalendarGridHeight());
    }
}

