/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.AbstractCalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.CalendarObject;

public class FilteredCalendarObjectCollection
extends AbstractCalendarObjectCollection {
    protected Filter mFilter;

    public FilteredCalendarObjectCollection(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("argument 'filter'");
        }
        this.mFilter = filter;
    }

    @Override
    protected synchronized void addCalendarObject(CalendarObject calObj) {
        if (this.mFilter.include(calObj)) {
            super.addCalendarObject(calObj);
        }
    }

    @Override
    protected synchronized void checkCalendarObject(CalendarObject calObj) {
        boolean contains = this.mCalendarObjects.contains(calObj);
        boolean shouldContain = this.mFilter.include(calObj);
        if (!contains && shouldContain) {
            this.addCalendarObject(calObj);
        } else if (contains && !shouldContain) {
            this.removeCalendarObject(calObj);
        } else {
            super.checkCalendarObject(calObj);
        }
    }

    public static interface Filter {
        public boolean include(CalendarObject var1);
    }
}

