/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sys.calendar;

import cmradar.manager.data.Meeting;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Console
extends JPanel {
    private static final String NONE = "NONE";
    private static final String UNIMP = "UNIMP";
    private Meeting m;
    private JLabel meetingIDLabel;
    private JLabel dateLabel;
    private JLabel initiatorLabel;
    private JLabel priorityLabel;
    private JLabel statusLabel;
    private JLabel purposeLabel;
    private static String meetingIDString = "Meeting ID: ";
    private static String dateString = "Date / Time: ";
    private static String initiatorString = "Initiator: ";
    private static String priorityString = "Priority: ";
    private static String statusString = "Status: ";
    private static String purposeString = "Purpose: ";
    private JTextField meetingIDField;
    private JTextField dateField;
    private JTextField initiatorField;
    private JTextField priorityField;
    private JTextField statusField;
    private JTextField purposeField;
    private JTabbedPane tabbedPane = new JTabbedPane();
    String consoleData = "";
    boolean waitingForInput = false;
    JTextField inputField;
    JTextArea console;
    JScrollPane scrollPane;
    JLabel inputFieldLabel;

    public Console() {
        super(new GridLayout(1, 1));
        JComponent jComponent = this.makeConsole();
        this.tabbedPane.addTab("Console", jComponent);
        this.tabbedPane.setMnemonicAt(0, 49);
        JComponent jComponent2 = this.makeMeetingInfo();
        this.tabbedPane.addTab("Meeting Info", jComponent2);
        this.tabbedPane.setMnemonicAt(1, 50);
        this.add(this.tabbedPane);
        this.setDataValues();
    }

    public JComponent makeConsole() {
        this.console = new JTextArea();
        this.console.setEditable(false);
        this.console.setLineWrap(true);
        this.scrollPane = new JScrollPane(this.console);
        this.scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.scrollPane.setPreferredSize(new Dimension(200, 200));
        this.inputField = new JTextField(40);
        this.inputField.setEditable(false);
        this.inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.waitingForInput = false;
            }
        });
        this.inputFieldLabel = new JLabel("  Enter >>> ");
        this.inputFieldLabel.setLabelFor(this.inputField);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.inputFieldLabel, "West");
        jPanel.add(this.inputField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(this.scrollPane);
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    public void setMeeting(Meeting meeting) {
        this.m = meeting;
        this.setDataValues();
    }

    public void changeTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    public void setDataValues() {
        if (this.m == null) {
            this.meetingIDField.setText(NONE);
            this.initiatorField.setText(NONE);
            this.priorityField.setText(NONE);
            this.statusField.setText(NONE);
        } else {
            this.meetingIDField.setText(this.m.getMeetingId());
            this.initiatorField.setText(this.m.getInitiator());
            this.priorityField.setText("1.0");
            this.statusField.setText(this.m.status);
        }
    }

    public JComponent makeMeetingInfo() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.meetingIDLabel = new JLabel(meetingIDString);
        this.initiatorLabel = new JLabel(initiatorString);
        this.priorityLabel = new JLabel(priorityString);
        this.statusLabel = new JLabel(statusString);
        this.meetingIDField = new JFormattedTextField();
        this.meetingIDField.setColumns(30);
        this.meetingIDField.setEditable(false);
        this.meetingIDField.setBackground(Color.white);
        this.initiatorField = new JFormattedTextField();
        this.initiatorField.setColumns(30);
        this.initiatorField.setEditable(false);
        this.initiatorField.setBackground(Color.white);
        this.priorityField = new JFormattedTextField();
        this.priorityField.setColumns(30);
        this.priorityField.setEditable(false);
        this.priorityField.setBackground(Color.white);
        this.statusField = new JFormattedTextField();
        this.statusField.setColumns(30);
        this.statusField.setEditable(false);
        this.statusField.setBackground(Color.white);
        this.meetingIDLabel.setLabelFor(this.meetingIDField);
        this.initiatorLabel.setLabelFor(this.initiatorField);
        this.priorityLabel.setLabelFor(this.priorityField);
        this.statusLabel.setLabelFor(this.statusField);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.add(this.meetingIDLabel);
        jPanel2.add(this.initiatorLabel);
        jPanel2.add(this.priorityLabel);
        jPanel2.add(this.statusLabel);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        jPanel3.add(this.meetingIDField);
        jPanel3.add(this.initiatorField);
        jPanel3.add(this.priorityField);
        jPanel3.add(this.statusField);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "After");
        return jPanel;
    }

    public String readLine() {
        String string = null;
        this.waitingForInput = true;
        this.inputField.setEditable(true);
        while (this.waitingForInput) {
        }
        this.inputField.setEditable(false);
        string = this.inputField.getText();
        this.inputField.setText("");
        this.consoleWriteLine(string);
        return string;
    }

    public void consoleWriteLine(String string) {
        this.console.append(string + "\n");
        this.consoleData = this.consoleData + string + "\n";
        this.console.setCaretPosition(this.console.getText().length());
    }

    public void consoleWrite(String string) {
        this.console.append(string);
        this.consoleData = this.consoleData + string;
        this.console.setCaretPosition(this.console.getText().length());
    }
}

