/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.sim.RequirementInfo;
import cmradar.manager.sim.SharedRoomCalendarGenerator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;

public class TestInfo {
    String startDate = "2005-01-01-0500";
    int testDays = 1;
    int startHour = 7;
    int endHour = 21;
    double pctFilled = 0.5;
    int sdFactor = 3;
    int numNewMeetings = 1;
    int newMeetingSize = -1;
    int defaultMeetingSize = -1;
    int numNewRequests = 1;
    int numRoomSolutions = 1;
    double genGoodProbThreshold = 0.0;
    LinkedList requestFields = new LinkedList();
    int requestFieldsCount = 1;
    String managerLogFilename = null;

    public TestInfo() {
    }

    public TestInfo(Properties properties) {
        this.startDate = properties.getProperty("cmradar.StartDate", "2006-3-20-0500");
        this.testDays = Integer.parseInt(properties.getProperty("cmradar.TestDays", "4"));
        this.startHour = Integer.parseInt(properties.getProperty("cmradar.StartHour", "7"));
        this.endHour = Integer.parseInt(properties.getProperty("cmradar.EndHour", "21"));
        this.pctFilled = Double.parseDouble(properties.getProperty("cmradar.PercentFilled", "0.9"));
        this.numNewRequests = Integer.parseInt(properties.getProperty("cmradar.NumNewRequests", "10"));
        this.numRoomSolutions = Integer.parseInt(properties.getProperty("cmradar.NumRoomSolutions", "0"));
        this.managerLogFilename = properties.getProperty("cmradar.ManagerLogFilename", "cmradar.log");
    }

    public TestInfo(HashMap hashMap) {
        String string = (String)hashMap.get("StartDate");
        if (string != null) {
            this.startDate = string;
        }
        if ((string = (String)hashMap.get("TestDays")) != null) {
            this.testDays = Integer.parseInt(string);
        }
        if ((string = (String)hashMap.get("StartHour")) != null) {
            this.startHour = Integer.parseInt(string);
        }
        if ((string = (String)hashMap.get("EndHour")) != null) {
            this.endHour = Integer.parseInt(string);
        }
        if ((string = (String)hashMap.get("PercentFilled")) != null) {
            this.pctFilled = Double.parseDouble(string);
        }
        if ((string = (String)hashMap.get("sdFactor")) != null) {
            this.sdFactor = Integer.parseInt(string);
        }
        if ((string = (String)hashMap.get("NumNewMeetings")) != null) {
            this.numNewMeetings = Integer.parseInt(string);
        }
        if ((string = (String)hashMap.get("NewMeetingSize")) != null) {
            this.newMeetingSize = Integer.parseInt(string);
        }
        if ((string = (String)hashMap.get("DefaultMeetingSize")) != null) {
            this.defaultMeetingSize = Integer.parseInt(string);
        }
        if ((string = (String)hashMap.get("NumNewRequests")) != null) {
            this.numNewRequests = Integer.parseInt(string);
        }
        if ((string = (String)hashMap.get("NumRoomSolutions")) != null) {
            this.numRoomSolutions = Integer.parseInt(string);
        }
        if ((string = (String)hashMap.get("GenGoodProbabilityThreshold")) != null) {
            this.genGoodProbThreshold = Double.parseDouble(string);
        }
        if ((string = (String)hashMap.get("ManagerLogFilename")) != null) {
            this.managerLogFilename = string;
        }
        if ((string = (String)hashMap.get("RequestFields")) != null) {
            String[] stringArray = string.split("[\t ,]+");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                this.requestFields.addLast(string2);
            }
        } else {
            RequirementInfo[] requirementInfoArray = SharedRoomCalendarGenerator.requirementList;
            for (int i = 0; i < requirementInfoArray.length; ++i) {
                this.requestFields.addLast(requirementInfoArray[i].name);
            }
        }
        if ((string = (String)hashMap.get("GenRequestFieldsCount")) != null) {
            this.requestFieldsCount = Integer.parseInt(string);
        }
        if (this.requestFields.size() < this.requestFieldsCount) {
            throw new IllegalArgumentException("Not enough request fields.");
        }
    }

    public double getGenGoodProbThreshold() {
        return this.genGoodProbThreshold;
    }

    public int getNewMeetingSize() {
        return this.newMeetingSize;
    }

    public int getDefaultMeetingSize() {
        return this.defaultMeetingSize;
    }

    public int getNumNewMeetings() {
        return this.numNewMeetings;
    }

    public int getNumNewRequests() {
        return this.numNewRequests;
    }

    public int getNumRoomSolutions() {
        return this.numRoomSolutions;
    }

    public int getsdFactor() {
        return this.sdFactor;
    }

    public int getStartHour() {
        return this.startHour;
    }

    public int getEndHour() {
        return this.endHour;
    }

    public int getTestDays() {
        return this.testDays;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getManagerLogFilename() {
        return this.managerLogFilename;
    }

    public double getPctFilled() {
        return this.pctFilled;
    }

    public LinkedList getRequestFields() {
        return this.requestFields;
    }

    public int getRequestFieldsRequired() {
        return this.requestFieldsCount;
    }
}

