/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Room;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sim.AgentInfo;
import cmradar.manager.sim.CalendarReader;
import cmradar.manager.sim.MeetingInfo;
import cmradar.manager.sim.RoomMeetingInfo;
import cmradar.manager.sim.TestInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SimParameters {
    public static String simFile;
    public static String ownersFile;
    public static String outCalendarFilePrefix;
    public static String outCalendarsFile;
    public static String outMeetingsFile;
    public static String trueStatusFile;
    private TestInfo testInfo;
    private Vector agents = new Vector();
    private Vector oldMeetings = new Vector();
    private Vector newMeetings = new Vector();
    private Vector requests = new Vector();
    private Vector roomList;
    private Vector extRooms;
    Vector _id2strV;
    HashMap roomMap;
    private SharedRoomCalendar rCal;
    static Logger logger;
    private Vector calendars = new Vector();
    public static final int SIM_MODE_NONE = 0;
    public static final int SIM_MODE_GEN = 1;
    public static final int SIM_MODE_SCHED = 2;
    private int mode = 0;
    public static final int UNIFORM = 0;
    public static final int NORM = 1;
    static /* synthetic */ Class class$cmradar$manager$sim$SimParameters;

    public SimParameters() {
        this.roomList = new Vector();
        this.extRooms = new Vector();
        this.roomMap = new HashMap();
        this._id2strV = new Vector();
    }

    public void resetSharedRoomCal() {
        this.oldMeetings = new Vector();
        this.newMeetings = new Vector();
        this.requests = new Vector();
    }

    private String[] parseKeyValueString(String string) {
        String[] stringArray = string.split("\\s+");
        String[] stringArray2 = new String[2];
        if (stringArray.length == 0) {
            return null;
        }
        if (stringArray.length > 0) {
            stringArray2[0] = stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 1; i < stringArray.length; ++i) {
            if (i > 1) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringArray2[1] = stringBuffer.toString();
        return stringArray2;
    }

    private String[] parseKeyValueStringMultipleLines(String string) {
        String[] stringArray = string.split("\\s+");
        String[] stringArray2 = new String[2];
        if (stringArray.length < 2) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringArray2[0] = stringArray[1];
        int n = 2;
        while (!stringArray[n].equals("End")) {
            stringBuffer.append(" " + stringArray[n++]);
        }
        stringArray2[1] = stringBuffer.toString();
        return stringArray2;
    }

    private void processAgents(BufferedReader bufferedReader) throws IOException {
        String[] stringArray;
        int n = 0;
        String string = bufferedReader.readLine();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        while (string.equals("") || string.charAt(0) == '#') {
            string = bufferedReader.readLine();
        }
        if (string.equals("--config--")) {
            while (!string.equals("--agents--")) {
                string = bufferedReader.readLine();
            }
            string = bufferedReader.readLine();
        }
        while (!string.equals("---")) {
            if (!string.equals("") && string.charAt(0) != '#') {
                stringArray = this.parseKeyValueString(string);
                try {
                    hashMap.put(stringArray[0], stringArray[1]);
                }
                catch (Exception exception) {
                    System.out.println("Parse error in line: " + string);
                    System.exit(0);
                }
            }
            string = bufferedReader.readLine();
        }
        while (string != null) {
            string = bufferedReader.readLine();
            while (string != null && !string.equals("---")) {
                if (!string.equals("") && string.charAt(0) != '#') {
                    stringArray = this.parseKeyValueString(string);
                    try {
                        hashMap2.put(stringArray[0], stringArray[1]);
                    }
                    catch (Exception exception) {
                        System.out.println("Parse error in line: " + string);
                        System.exit(0);
                    }
                }
                string = bufferedReader.readLine();
            }
            this.agents.add(new AgentInfo(hashMap, hashMap2, n));
            ++n;
        }
    }

    private void processMeetings(BufferedReader bufferedReader, Vector vector) throws IOException {
        String string = "dummy";
        while (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            string = bufferedReader.readLine();
            while (string != null && !string.equals("---")) {
                if (!string.equals("") && string.charAt(0) != '#') {
                    String[] stringArray;
                    if (string.startsWith("Start")) {
                        StringBuffer stringBuffer = new StringBuffer();
                        while (!string.startsWith("End")) {
                            stringBuffer.append(string + "\n");
                            string = bufferedReader.readLine();
                        }
                        stringBuffer.append(string + "\n");
                        stringArray = this.parseKeyValueStringMultipleLines(stringBuffer.toString());
                    } else {
                        stringArray = this.parseKeyValueString(string);
                    }
                    try {
                        hashMap.put(stringArray[0], stringArray[1]);
                    }
                    catch (Exception exception) {
                        logger.log((Priority)Level.ERROR, (Object)("Parse error in line: " + string + " currentKeys=" + hashMap + " fields=" + stringArray));
                        System.exit(0);
                    }
                }
                string = bufferedReader.readLine();
            }
            if (hashMap.get("Id") == null) continue;
            vector.add(new MeetingInfo(hashMap));
        }
    }

    public Vector parseExternalBuildings(String string) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i].trim());
        }
        return vector;
    }

    public void parseConfigFile(String string) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        this.testInfo = new TestInfo(properties);
    }

    public void parseAgentsFile(String string) throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.processAgents(bufferedReader);
        }
        catch (IOException iOException) {
            System.err.println("Error reading agents file: " + string);
            throw new IOException("Error reading agents");
        }
    }

    public void parseOldMeetingsFile(String string) throws IOException {
        this.parseMeetingsFile(string, this.oldMeetings);
        outMeetingsFile = outMeetingsFile == null ? string : outMeetingsFile;
    }

    public void parseNewMeetingsFile(String string) throws IOException {
        simFile = string;
        this.parseMeetingsFile(string, this.newMeetings);
    }

    public void parseMeetingsFile(String string, Vector vector) throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.processMeetings(bufferedReader, vector);
        }
        catch (IOException iOException) {
            System.err.println("Error reading meetings file: " + string);
            iOException.printStackTrace();
            throw new IOException("Error reading new meetings");
        }
    }

    public HashMap parseTrueStatusFile(String string) throws IOException {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String[] stringArray = string2.split("\\s+");
                if (stringArray.length < 2) {
                    logger.log((Priority)Level.ERROR, (Object)("syntax error in .rsim file:" + string2));
                    System.exit(0);
                }
                hashMap.put(stringArray[0], stringArray[1]);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            return hashMap;
        }
        catch (IOException iOException) {
            logger.log((Priority)Level.ERROR, (Object)("reading meetings file: " + string));
            iOException.printStackTrace();
            throw new IOException("Error reading new meetings");
        }
    }

    public void parseCalendarFile(String string) {
        CalendarReader calendarReader = new CalendarReader();
        this.calendars = CalendarReader.parseCalendarFile(string, this);
    }

    public void parseRequestFile(String string) {
        String string2 = Template.FiletoString(string);
        this.requests = RoomTemplate.getTemplatesFromString(string2);
        simFile = string;
    }

    public void addRequestFile(String string) {
        String string2 = Template.FiletoString(string);
        this.requests.add(RoomTemplate.getTemplateFromString(string2));
    }

    public void clearRequestFiles() {
        this.requests.clear();
    }

    public void parseRoomFile(String string) throws IOException {
        this.parseRoomFile(string, new Vector());
    }

    public void parseRoomFile(String string, Vector vector) throws IOException {
        Room.parseRoomList(string, this.roomList, this.extRooms, vector, this.roomMap, this._id2strV);
    }

    public Vector getExternalRooms() {
        return this.extRooms;
    }

    public void parseDensityFile(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String[] stringArray = string2.split("[\t ]");
                Room room = this.findRoom(stringArray[0]);
                double d = Double.parseDouble(stringArray[1]);
                if (room == null) {
                    System.out.println("Room[" + stringArray[0] + "] not found");
                }
                room.setDensity(d);
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void parseOwnersFile(String string) throws IOException {
        logger.log((Priority)Level.DEBUG, (Object)("ownerFile=[" + string + "]"));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            String[] stringArray = string2.split("[\t ]");
            AgentInfo agentInfo = this.findAgent(stringArray[0]);
            agentInfo.parseProbString2(string2);
            string2 = bufferedReader.readLine();
        }
    }

    public void setOwnersFileName(String string) {
        ownersFile = string;
    }

    private AgentInfo findAgent(String string) {
        for (int i = 0; i < this.agents.size(); ++i) {
            AgentInfo agentInfo = (AgentInfo)this.agents.get(i);
            if (!agentInfo.getUserId().equals(string)) continue;
            return agentInfo;
        }
        return null;
    }

    private Room findRoom(String string) {
        return (Room)this.roomMap.get(string);
    }

    public static double normalize(double d, double d2, double d3, double d4, double d5) {
        return d4 + (d - d2) * (d5 - d4) / (d3 - d2);
    }

    public void generateDensityFile(String string, int n) {
        Random random = new Random();
        try {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.roomList.iterator();
            while (iterator.hasNext()) {
                object = (Room)iterator.next();
                double d = 0.5;
                switch (n) {
                    case 0: {
                        d = random.nextDouble();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        d = random.nextDouble();
                    }
                }
                d = SimParameters.normalize(d, 0.0, 1.0, 0.05, 0.9);
                stringBuffer.append(((Room)object).getRoomId() + "\t" + String.valueOf(d) + "\t" + ((Room)object).getFeature("cost") + "\n");
            }
            object = new BufferedWriter(new FileWriter(string));
            ((Writer)object).write(stringBuffer.toString());
            ((BufferedWriter)object).close();
        }
        catch (Exception exception) {
            System.out.println("Error in writing density file: " + exception.toString());
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public void parseSharedRoomCalendarFile(String string, String string2) throws IOException {
        trueStatusFile = string2;
        this.parseSharedRoomCalendarFile(string);
        if (string2 != null) {
            HashMap hashMap = this.parseTrueStatusFile(string2);
            this.rCal.setTrueStatusMap(hashMap);
        } else {
            logger.log((Priority)Level.ERROR, (Object)"true status file is null");
        }
        logger.log((Priority)Level.INFO, (Object)("rcal=" + this.rCal));
    }

    public void parseSharedRoomCalendarFile(String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        logger.log((Priority)Level.INFO, (Object)("sharedCalFile=[" + string + "]"));
        LinkedList linkedList = SharedRoomCalendar.parseMeetingList(new BufferedReader(new FileReader(string)));
        Iterator iterator = this.roomMap.values().iterator();
        Iterator iterator2 = this.oldMeetings.iterator();
        Iterator iterator3 = linkedList.iterator();
        HashMap<String, Meeting> hashMap = new HashMap<String, Meeting>();
        this.rCal = new SharedRoomCalendar();
        this.rCal.setRoomIDMap(this._id2strV);
        String string2 = outCalendarsFile = outCalendarsFile == null ? string : outCalendarsFile;
        while (iterator.hasNext()) {
            object4 = (Room)iterator.next();
            this.rCal.addRoom((Room)object4);
        }
        while (iterator2.hasNext()) {
            object4 = (MeetingInfo)iterator2.next();
            object3 = new Vector(((MeetingInfo)object4).getAttendants().keySet());
            object2 = ((MeetingInfo)object4).getRequirements();
            object = "null";
            Meeting meeting = new Meeting((String)object, ((MeetingInfo)object4).getMeetingId(), ((MeetingInfo)object4).getInitiator(), Meeting.typeStringToInt(((MeetingInfo)object4).getType()), new Vector(object3), (ArrayList)object2, ((MeetingInfo)object4).getStatus());
            meeting.setDuration(((MeetingInfo)object4).getDuration());
            hashMap.put(((MeetingInfo)object4).getMeetingId(), meeting);
        }
        while (iterator3.hasNext()) {
            object4 = (RoomMeetingInfo)iterator3.next();
            object3 = (Meeting)hashMap.get(((RoomMeetingInfo)object4).getMeetingId());
            object2 = ((RoomMeetingInfo)object4).getTimeSlot();
            if (object3 == null) {
                logger.log((Priority)Level.ERROR, (Object)("INPUT ERROR: Unknown Meeting " + ((RoomMeetingInfo)object4).getMeetingId() + " used in shared room calendar file."));
                System.exit(0);
            }
            ((TimeSlot)object2).setLocation(((RoomMeetingInfo)object4).getRoomId());
            ((Meeting)object3).setTimeSlot((TimeSlot)object2);
            object = (Room)this.roomMap.get(((RoomMeetingInfo)object4).getRoomId());
            if (object == null) {
                logger.log((Priority)Level.ERROR, (Object)("Room [" + ((RoomMeetingInfo)object4).getRoomId() + "] not defined in .rooms file rmap sz=" + this.roomMap.size()));
                System.exit(0);
            }
            this.rCal.addMeeting((Room)object, (Meeting)object3, (TimeSlot)object2, false);
        }
    }

    public void parseSimFiles(String string, String string2, String string3) throws IOException {
        this.parseAgentsFile(string);
        this.parseMeetingsFile(string2, this.newMeetings);
        simFile = string2;
        outMeetingsFile = string2;
        outCalendarsFile = string3;
        outCalendarFilePrefix = SimParameters.toPrefix(outCalendarsFile);
        this.mode = 1;
    }

    public void parseSimFiles(String string, String string2, String string3, String string4, String string5) throws IOException {
        this.parseAgentsFile(string);
        this.parseMeetingsFile(string2, this.oldMeetings);
        this.parseCalendarFile(string3);
        if (string4 != null) {
            this.parseMeetingsFile(string4, this.newMeetings);
        }
        outCalendarsFile = outCalendarsFile == null ? string5 : outCalendarsFile;
        outMeetingsFile = outMeetingsFile == null ? string2 : outMeetingsFile;
        this.mode = 2;
        simFile = string4;
        outCalendarFilePrefix = SimParameters.toPrefix(outCalendarsFile);
    }

    public int getMode() {
        return this.mode;
    }

    public TestInfo getTestInfo() {
        return this.testInfo;
    }

    public void setTestInfo(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public Vector getAgents() {
        return this.agents;
    }

    public Vector getOldMeetings() {
        return this.oldMeetings;
    }

    public Vector getNewMeetings() {
        return this.newMeetings;
    }

    public Vector getRooms() {
        return this.roomList;
    }

    public SharedRoomCalendar getSharedRoomCalendar() {
        return this.rCal;
    }

    public Vector getCalendars() {
        return this.calendars;
    }

    public Vector getRequests() {
        return this.requests;
    }

    public String getOutCalendarsFile() {
        return outCalendarsFile;
    }

    public static String toPrefix(String string) {
        try {
            int n = string.lastIndexOf(46);
            String[] stringArray = string.split("\\.");
            return string.substring(0, n);
        }
        catch (Exception exception) {
            System.out.println("fname=" + string);
            exception.printStackTrace();
            System.exit(0);
            return "";
        }
    }

    public static void main(String[] stringArray) {
        SimParameters simParameters = new SimParameters();
        try {
            simParameters.parseRoomFile("cmradar.rooms");
            simParameters.parseOldMeetingsFile("v1.1.s.meetings");
            simParameters.parseSharedRoomCalendarFile("v1.1.s.sharedroomcalendar");
            SharedRoomCalendar sharedRoomCalendar = simParameters.getSharedRoomCalendar();
            sharedRoomCalendar.saveAsICalendarAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = Logger.getLogger((String)(class$cmradar$manager$sim$SimParameters == null ? (class$cmradar$manager$sim$SimParameters = SimParameters.class$("cmradar.manager.sim.SimParameters")) : class$cmradar$manager$sim$SimParameters).getName());
    }
}

