/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;

public class MeetingInfo {
    private String id;
    private int duration;
    private String initiator;
    private String preferredSlot;
    private String type;
    private int weight;
    private ArrayList requirements = new ArrayList();
    HashMap attendants = new HashMap();
    String status = "possible";

    public MeetingInfo(HashMap hashMap) {
        Object object;
        this.id = (String)hashMap.get("Id");
        try {
            this.duration = Integer.parseInt((String)hashMap.get("Duration"));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Bad duration field for meeting id: " + this.id + " " + hashMap.get("Duration"));
            throw new RuntimeException(numberFormatException);
        }
        try {
            this.weight = Integer.parseInt((String)hashMap.get("Weight"));
        }
        catch (NumberFormatException numberFormatException) {
            this.weight = 1;
        }
        this.initiator = (String)hashMap.get("Initiator");
        this.preferredSlot = (String)hashMap.get("PreferredSlot");
        String string = (String)hashMap.get("Attendants");
        this.status = (String)hashMap.get("Status");
        if (this.status == null) {
            this.status = this.id.startsWith("__UNKNOWN__") ? "unknown" : (this.id.startsWith("__UNAVAILABLE__") ? "impossible" : "confirmed");
        }
        this.type = (String)hashMap.get("Type");
        if (this.type == null) {
            this.type = "nil";
        }
        if (!string.equals("")) {
            object = string.split(",");
            for (int i = 0; i < ((String[])object).length; i += 2) {
                this.attendants.put(object[i], object[i + 1]);
            }
        }
        if ((object = (String)hashMap.get("Requirements")) != null) {
            this.requirements = RoomTemplate.getRequirementsFromString((String)object);
        }
    }

    public ArrayList getRequirements() {
        return this.requirements;
    }

    public String getMeetingId() {
        return this.id;
    }

    public String getStatus() {
        return this.status;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getDuration() {
        return this.duration;
    }

    public HashMap getAttendants() {
        return this.attendants;
    }

    public Vector getAttendantsVector() {
        return new Vector(this.attendants.keySet());
    }

    public String getType() {
        return this.type;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public String getPreferredSlot() {
        return this.preferredSlot;
    }

    public Template toTemplate() {
        Object object;
        Template template = new Template();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]");
        simpleDateFormat.setTimeZone(TimeSlot.sdf.getTimeZone());
        String string = simpleDateFormat.format(calendar.getTime());
        template.meetingId = this.id;
        template.timeStamp = string;
        template.initiator = this.getInitiator();
        template.duration = this.duration;
        template.setPredefinedKind(this.type);
        if (this.preferredSlot != null) {
            object = new TimeSlot(this.preferredSlot);
            template.addTimeSlot((TimeSlot)object, this.status);
        }
        object = this.attendants.keySet().iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            template.addAttendant(string2, 1.0);
        }
        return template;
    }
}

