/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Room;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.ext.DataSimulator;
import cmradar.manager.ext.Learner;
import cmradar.manager.ext.Matrix2;
import cmradar.manager.ext.MemoryBasedLearner;
import cmradar.manager.sim.AgentInfo;
import cmradar.manager.sim.SharedRoomCalendarGenerator;
import cmradar.manager.sim.SimParameters;
import cmradar.manager.sim.TestInfo;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class HotelCalendarGenerator
extends SharedRoomCalendarGenerator {
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$sim$HotelCalendarGenerator == null ? (class$cmradar$manager$sim$HotelCalendarGenerator = HotelCalendarGenerator.class$("cmradar.manager.sim.HotelCalendarGenerator")) : class$cmradar$manager$sim$HotelCalendarGenerator).getName());
    static int _unknownMtgCnt = -1;
    static String _unknown = "__UNKNOWN__";
    static String _taken = "__TAKEN__";
    static /* synthetic */ Class class$cmradar$manager$sim$HotelCalendarGenerator;

    public HotelCalendarGenerator(Vector vector, Vector vector2) {
        this.calendar = new SharedRoomCalendar(vector, vector2);
        this.meetings = new HashMap();
    }

    public Meeting createUnknownMeeting(Room room, String string, TimeSlot timeSlot, String string2, String string3) {
        String string4 = (string2.equals("unknown") ? _unknown : _taken) + ++_unknownMtgCnt;
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        Meeting meeting = new Meeting(string, string4, string, -1, vector, string2);
        timeSlot.setLocation(room.getRoomId());
        timeSlot.setStatus(string2);
        meeting.setDuration(timeSlot.getDurationSecond());
        this.calendar.addMeeting(room, meeting, timeSlot, true, string3);
        this.meetings.put(meeting.getMeetingId(), meeting);
        return meeting;
    }

    public static String getStringStatus(Double d) {
        if (d == null) {
            return "unknown";
        }
        if (d.equals(Learner.FREE)) {
            return "possible";
        }
        if (d.equals(Learner.TAKEN)) {
            return "confirmed";
        }
        if (d.equals(Learner.UNKNOWN)) {
            return "unknown";
        }
        return null;
    }

    public static void main(String[] stringArray) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        PropertyConfigurator.configure((String)"radar.properties");
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream("cmradar.properties");
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            logger.log((Priority)Level.ERROR, (Object)"cmradar.properties: file not found.");
            System.exit(0);
        }
        int n = 10;
        int n2 = -1;
        double d = 0.9;
        boolean bl = false;
        double d2 = 0.05;
        String string2 = "cmradar.ext";
        String string3 = "cmradar.rooms";
        String string4 = "cmradar.agents";
        String string5 = "test";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        string3 = properties.getProperty("cmradar.rooms").trim();
        string2 = properties.getProperty("cmradar.pref").trim() + ".ext";
        string4 = properties.getProperty("cmradar.agents").trim() + ".agents";
        d2 = Double.parseDouble(properties.getProperty("cmradar.visibility").trim());
        TimeSlot.setTimezone(properties.getProperty("cmradar.timezone", "EST-0500").trim());
        String string6 = properties.getProperty("cmradar.hotels").trim();
        String string7 = "cmradar.properties";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-room")) {
                if (stringArray.length <= ++i) continue;
                string3 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-config")) {
                if (stringArray.length <= ++i) continue;
                string7 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-agent")) {
                if (stringArray.length <= ++i) continue;
                string4 = stringArray[i] + ".agents";
                continue;
            }
            if (stringArray[i].equals("-o")) {
                if (stringArray.length <= ++i) continue;
                string5 = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-g")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-c")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-l")) {
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-f")) {
                if (stringArray.length <= ++i) continue;
                string2 = stringArray[i] + ".ext";
                continue;
            }
            if (stringArray[i].equals("-v")) {
                if (stringArray.length <= ++i) continue;
                d2 = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-t")) {
                bl5 = true;
                continue;
            }
            if (stringArray[i].equals("-d")) {
                if (stringArray.length <= ++i || !((d = Double.parseDouble(stringArray[i])) < 0.0)) continue;
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-n")) {
                if (stringArray.length <= ++i) continue;
                try {
                    n = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    logger.log((Priority)Level.ERROR, (Object)"arg: -n number");
                    System.exit(0);
                }
                continue;
            }
            if (stringArray[i].equals("-tsz")) {
                if (stringArray.length <= ++i) continue;
                try {
                    n2 = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    logger.log((Priority)Level.ERROR, (Object)"arg: -tsz number");
                    System.exit(0);
                }
                continue;
            }
            if (!stringArray[i].equals("-s")) continue;
            bl4 = true;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray2 = string6.split(",");
        for (int i = 0; i < stringArray2.length; ++i) {
            vector.add(stringArray2[i].trim());
        }
        SimParameters simParameters = new SimParameters();
        try {
            simParameters.parseConfigFile(string7);
            simParameters.parseAgentsFile(string4);
            simParameters.parseRoomFile(string3 + ".rooms", vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.log((Priority)Level.ERROR, (Object)"parsing .agents file");
            System.exit(0);
        }
        Vector vector2 = simParameters.getExternalRooms();
        Vector vector3 = simParameters.getRooms();
        HotelCalendarGenerator hotelCalendarGenerator = new HotelCalendarGenerator(vector3, vector2);
        DataSimulator dataSimulator = null;
        if (bl2) {
            dataSimulator = new DataSimulator(vector2, n);
            dataSimulator.saveUsers(string2);
            logger.log((Priority)Level.INFO, (Object)("users saved into " + string2));
        } else {
            dataSimulator = new DataSimulator(vector2, string2);
        }
        if (n2 > 0) {
            Vector vector4 = dataSimulator.generateTrainData(n2, string3 + ".traindata", d2);
            MemoryBasedLearner memoryBasedLearner = new MemoryBasedLearner(new Matrix2(vector4));
            memoryBasedLearner.save(string3 + "-learned.rank");
            logger.log((Priority)Level.INFO, (Object)("Output saved: " + string3 + ".traindata" + ", " + string3 + "-learned.rank"));
            return;
        }
        TestInfo testInfo = simParameters.getTestInfo();
        int n3 = testInfo.getStartHour();
        int n4 = testInfo.getEndHour();
        int n5 = n4 - n3;
        logger.log((Priority)Level.INFO, (Object)("start=" + n3 + " dur=" + n5 + "!!!"));
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        try {
            calendar.setTime(new SimpleDateFormat("yyyy-MM-ddZ").parse(testInfo.getStartDate()));
            calendar.set(11, n3);
            calendar.set(12, 0);
            calendar2.setTime(new SimpleDateFormat("yyyy-MM-ddZ").parse(testInfo.getStartDate()));
            calendar2.set(11, n3);
            calendar2.set(12, 0);
        }
        catch (ParseException parseException) {
            System.err.println("Calendar Parsing failed");
            parseException.printStackTrace();
            System.exit(1);
        }
        Object object7 = null;
        Vector vector5 = simParameters.getAgents();
        for (int i = 0; i < vector5.size(); ++i) {
            object6 = (AgentInfo)vector5.get(i);
            object5 = ((AgentInfo)object6).getAgentType();
            if (((String)object5).indexOf("Hotel") < 0) continue;
            object7 = object6;
            break;
        }
        String string8 = ((AgentInfo)object7).getUserName();
        object6 = new HashMap();
        object5 = new Random();
        for (int i = 0; i < testInfo.getTestDays(); ++i) {
            if (bl) {
                d = ((Random)object5).nextDouble();
            }
            object4 = dataSimulator.generateCalendar(d);
            object3 = DataSimulator.addUncertainty((Random)object5, (Vector)object4, d2, bl5);
            for (int j = 0; j < vector2.size(); ++j) {
                Meeting meeting;
                TimeSlot timeSlot;
                object2 = (Room)vector2.elementAt(j);
                if (((Room)object2).getId() != j) {
                    System.out.println("Oops. ID doesn't match.");
                }
                string = HotelCalendarGenerator.getStringStatus((Double)((Vector)object4).elementAt(j));
                object = HotelCalendarGenerator.getStringStatus((Double)((Vector)object3).elementAt(j));
                if (!((String)object).equals("unknown")) {
                    logger.log((Priority)Level.DEBUG, (Object)("revealed : " + ((Room)object2).getRoomId() + " " + (String)object + " " + string));
                }
                int n6 = n3;
                while (n6 + n5 <= n4) {
                    calendar.set(11, n6);
                    calendar2.set(11, n6 + n5);
                    timeSlot = new TimeSlot(calendar.getTime().getTime() / 1000L, calendar2.getTime().getTime() / 1000L);
                    if (((String)object).equals("unknown") || !string.equals("possible")) {
                        meeting = hotelCalendarGenerator.createUnknownMeeting((Room)object2, string8, timeSlot, (String)object, string);
                        ((HashMap)object6).put(meeting.getMeetingId(), string);
                    }
                    n6 += n5;
                }
                if (n6 == n4) continue;
                calendar.set(11, n6);
                calendar2.set(11, n4);
                timeSlot = new TimeSlot(calendar.getTime().getTime() / 1000L, calendar2.getTime().getTime() / 1000L);
                if (!((String)object).equals("unknown") && string.equals("possible")) continue;
                meeting = hotelCalendarGenerator.createUnknownMeeting((Room)object2, string8, timeSlot, (String)object, string);
                ((HashMap)object6).put(meeting.getMeetingId(), string);
            }
            calendar.add(6, 1);
            calendar2.add(6, 1);
        }
        logger.log((Priority)Level.INFO, (Object)"ext");
        if (bl3) {
            hotelCalendarGenerator.generateRandomCalendar(simParameters, null, false);
        }
        logger.log((Priority)Level.INFO, (Object)"local");
        hotelCalendarGenerator.generateRoomRequests(simParameters);
        logger.log((Priority)Level.INFO, (Object)"requests");
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string5 + ".sharedroomcalendar"));
            bufferedWriter.write(hotelCalendarGenerator.getCalendar().toParseString() + "\n");
            bufferedWriter.close();
            object4 = new BufferedWriter(new FileWriter(string5 + ".rsim"));
            object3 = ((HashMap)object6).keySet().iterator();
            while (object3.hasNext()) {
                String string9 = (String)object3.next();
                object2 = (String)((HashMap)object6).get(string9);
                ((Writer)object4).write(string9 + " " + (String)object2 + "\n");
            }
            ((BufferedWriter)object4).close();
            object3 = new BufferedWriter(new FileWriter(string5 + ".meetings"));
            for (int i = 0; i < hotelCalendarGenerator.getMeetings().size(); ++i) {
                object2 = (Meeting)hotelCalendarGenerator.getMeetings().get(i);
                string = ((Meeting)object2).toParseString(0L);
                if (string == null) continue;
                ((Writer)object3).write(((Meeting)object2).toParseString());
                if (i == hotelCalendarGenerator.getMeetings().size() - 1) continue;
                ((Writer)object3).write("---\n");
            }
            ((BufferedWriter)object3).close();
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(string5 + ".requests"));
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("(templates \n");
            for (int i = 0; i < hotelCalendarGenerator.getRequests().size(); ++i) {
                object = (RoomTemplate)hotelCalendarGenerator.getRequests().get(i);
                ((StringBuffer)object2).append(((RoomTemplate)object).toLispList() + "\n");
            }
            ((StringBuffer)object2).append(")");
            bufferedWriter2.write(((StringBuffer)object2).toString());
            bufferedWriter2.close();
            if (bl4) {
                logger.log((Priority)Level.INFO, (Object)"generation done. saving into html. may take a few seconds.");
                hotelCalendarGenerator.calendar.quickHtml(string5 + ".html", properties);
            }
            logger.log((Priority)Level.INFO, (Object)("Output saved:" + string5 + ".sharedroomcalendar" + ", " + string5 + ".meetings" + (bl4 ? ", " + string5 + ".html (for a quick view)" : "")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

