/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sim;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.OwnersViewer;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.Template;
import cmradar.manager.neg.AbstractNegotiator;
import cmradar.manager.neg.AbstractRoomNegotiator;
import cmradar.manager.neg.BumpingNegotiator;
import cmradar.manager.neg.HotelAgent;
import cmradar.manager.neg.InteractiveNegotiator;
import cmradar.manager.neg.PendingNegotiator;
import cmradar.manager.neg.RoomNegotiator;
import cmradar.manager.neg.RoomOwnerA;
import cmradar.manager.neg.RoomOwnerB;
import cmradar.manager.neg.RoomOwnerD;
import cmradar.manager.neg.RoomOwnerSimpMTypeProb;
import cmradar.manager.neg.RoomOwnerSimpleTwoProb;
import cmradar.manager.neg.SimpleNegotiator;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sched.SimpleRoomScheduler;
import cmradar.manager.sched.SimpleScheduler;
import cmradar.manager.sim.AgentInfo;
import cmradar.manager.sim.Message;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sim.RadarLogger;
import cmradar.manager.sim.SetCalendarThread;
import cmradar.manager.sim.Simulator;
import cmradar.manager.sys.RManagerIO;
import cmradar.manager.sys.RManagerIOFrame;
import cmradar.manager.sys.RManagerIOLogger;
import cmradar.manager.sys.SchedulerInvoker;
import java.io.BufferedWriter;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class AgentThread
extends Thread {
    AgentInfo myInfo;
    MessageCommunicator mComm;
    RManagerIO ioManager;
    AbstractNegotiator negotiator;
    int pollTime = 500;
    int port = 9998;
    Scheduler ctl = null;
    OwnersViewer ov;
    SetCalendarThread sct;

    public AgentThread(MessageCommunicator messageCommunicator, AgentInfo agentInfo, BufferedWriter bufferedWriter) {
        this.mComm = messageCommunicator;
        this.myInfo = agentInfo;
        this.port = agentInfo.getPortNumber();
        RManagerIOFrame rManagerIOFrame = new RManagerIOFrame(this.myInfo.getUserId(), this.myInfo.getUserId(), Simulator.x += 30, Simulator.y += 30, 500, 500);
        rManagerIOFrame.showCalendar = false;
        this.ioManager = rManagerIOFrame;
        this.initLogFile(bufferedWriter);
    }

    public Scheduler getScheduler() {
        return this.ctl;
    }

    public AbstractNegotiator getNegotiator() {
        return this.negotiator;
    }

    public String getAgentName() {
        return this.myInfo.getUserId();
    }

    public void setOwnersViewer(OwnersViewer ownersViewer) {
        this.ov = ownersViewer;
    }

    public void initLogFile(BufferedWriter bufferedWriter) {
        if (bufferedWriter != null) {
            this.ioManager = new RManagerIOLogger(this.myInfo.getUserId(), bufferedWriter, null);
            if (this.negotiator != null) {
                this.negotiator.setIOManager(this.ioManager);
            }
        }
    }

    public void closeLogFile() {
        if (this.ioManager != null) {
            this.ioManager.closeLogFile();
        }
    }

    public AgentThread(MessageCommunicator messageCommunicator, AgentInfo agentInfo, RManagerIO rManagerIO) {
        this.mComm = messageCommunicator;
        this.myInfo = agentInfo;
        this.port = agentInfo.getPortNumber();
        this.ioManager = rManagerIO;
        this.ioManager.writeLine("running...");
    }

    public void init(String string, String string2, String string3, String string4) {
        String string5 = this.myInfo.getAgentType();
        String[] stringArray = string5.split("\\?");
        string5 = stringArray[0];
        String string6 = stringArray.length > 1 ? stringArray[1] : "";
        if (string5.equals("BumpingNeg-java") || string5.equals("BumpingNeg")) {
            this.ctl = new SimpleScheduler();
            this.ctl.resetRoomSchedulerFiles(string, string2, string3);
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new BumpingNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string5.equals("PendingNeg-java")) {
            this.ctl = new SimpleScheduler();
            this.ctl.resetRoomSchedulerFiles(string, string2, string3);
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new PendingNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string5.equals("InteractiveNeg")) {
            this.ctl = new SimpleScheduler();
            this.ctl.resetRoomSchedulerFiles(string, string2, string3);
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new InteractiveNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string5.equals("RoomNegotiator-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.resetRoomSchedulerFiles(string, string2, string3);
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            if (this.ov != null) {
                this.negotiator.setOwnersViewer(this.ov);
            }
        } else if (string5.equals("RoomOwnerA-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.resetRoomSchedulerFiles(string, string2, string3);
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomOwnerA(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string5.equals("RoomOwnerB-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.resetRoomSchedulerFiles(string, string2, string3);
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomOwnerB(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string5.equals("RoomOwnerD-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.resetRoomSchedulerFiles(string, string2, string3);
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomOwnerD(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string5.equals("RoomOwnerM-java")) {
            this.ctl = null;
            if (this.myInfo.isRoomYesMType()) {
                this.negotiator = new RoomOwnerSimpMTypeProb(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm, this.myInfo.getRoomYesMTypeProb());
            } else if (this.myInfo.isRoomYesMTypeSize()) {
                this.negotiator = new RoomOwnerSimpMTypeProb(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm, this.myInfo.getRoomYesMTypeSizeProb());
            } else {
                System.out.println("myInfo=" + this.myInfo);
            }
        } else if (string5.equals("RoomOwnerMS-java")) {
            this.ctl = null;
            this.negotiator = new RoomOwnerSimpleTwoProb(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm, this.myInfo.getRoomYesMTypeSizeProb());
        } else if (string5.equals("HotelAgent-java")) {
            this.negotiator = new HotelAgent(this.ioManager, this.myInfo.getUserId(), this.ctl, this.mComm);
        } else {
            this.ctl = new SchedulerInvoker(this.myInfo.getUserId(), this.ioManager, this.port);
            this.ctl.resetRoomSchedulerFiles(string, string2, string3);
            ((SchedulerInvoker)this.ctl).setBumpingPenaltyFile(string4);
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            if (string5.equals("SimpleNeg")) {
                this.negotiator = new SimpleNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else if (string5.startsWith("BumpingNeg")) {
                this.negotiator = new BumpingNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else if (string5.startsWith("RoomNegotiator")) {
                this.negotiator = new RoomNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
                if (this.ov != null) {
                    this.negotiator.setOwnersViewer(this.ov);
                }
            } else if (string5.startsWith("RoomOwnerA")) {
                this.negotiator = new RoomOwnerA(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else if (string5.startsWith("RoomOwnerB")) {
                this.negotiator = new RoomOwnerB(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else if (string5.startsWith("RoomOwnerD")) {
                this.negotiator = new RoomOwnerD(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else {
                System.out.println("AgentThread: Unknown negotiation type -- " + string5);
                System.exit(0);
            }
        }
        if (this.negotiator == null) {
            System.out.println("AGENTTYPE=" + string5);
        }
        this.negotiator.setOptions(string6);
        this.negotiator.setResponseTime(5000);
    }

    public void init() {
        String string = this.myInfo.getAgentType();
        String[] stringArray = string.split("\\?");
        string = stringArray[0];
        String string2 = stringArray.length > 1 ? stringArray[1] : "";
        if (string.equals("BumpingNeg-java") || string.equals("BumpingNeg")) {
            this.ctl = new SimpleScheduler();
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new BumpingNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string.equals("PendingNeg-java")) {
            this.ctl = new SimpleScheduler();
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new PendingNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string.equals("InteractiveNeg")) {
            this.ctl = new SimpleScheduler();
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new InteractiveNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string.equals("RoomNegotiator-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            if (this.ov != null) {
                this.negotiator.setOwnersViewer(this.ov);
            }
        } else if (string.equals("RoomOwnerA-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomOwnerA(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string.equals("RoomOwnerB-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomOwnerB(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string.equals("RoomOwnerD-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomOwnerD(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
        } else if (string.equals("RoomOwnerM-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomOwnerSimpMTypeProb(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm, this.myInfo.getRoomYesMTypeProb());
        } else if (string.equals("RoomOwnerMS-java")) {
            this.ctl = new SimpleRoomScheduler();
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            this.negotiator = new RoomOwnerSimpleTwoProb(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm, this.myInfo.getRoomYesMTypeSizeProb());
        } else {
            this.ctl = new SchedulerInvoker(this.myInfo.getUserId(), this.ioManager, this.port);
            this.ctl.startScheduler(this.myInfo.getUserId(), this.myInfo.getUserPrefs());
            if (string.equals("SimpleNeg")) {
                this.negotiator = new SimpleNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else if (string.startsWith("BumpingNeg")) {
                this.negotiator = new BumpingNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else if (string.startsWith("RoomNegotiator")) {
                this.negotiator = new RoomNegotiator(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
                if (this.ov != null) {
                    this.negotiator.setOwnersViewer(this.ov);
                }
            } else if (string.startsWith("RoomOwnerA")) {
                this.negotiator = new RoomOwnerA(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else if (string.startsWith("RoomOwnerB")) {
                this.negotiator = new RoomOwnerB(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else if (string.startsWith("RoomOwnerD")) {
                this.negotiator = new RoomOwnerD(this.ioManager, this.myInfo.getUserId(), this.myInfo.getUserPrefs(), this.ctl, this.mComm);
            } else {
                System.out.println("AgentThread: Unknown negotiation type -- " + string);
                System.exit(0);
            }
        }
        this.negotiator.setOptions(string2);
    }

    public void set_logger(RadarLogger radarLogger) {
        this.negotiator.set_logger(radarLogger);
    }

    public void set_calendar(Calendar calendar) {
        this.negotiator.set_calendar(calendar);
    }

    public void set_sharedroomcalendar(SharedRoomCalendar sharedRoomCalendar) {
        ((AbstractRoomNegotiator)this.negotiator).setSharedRCal(sharedRoomCalendar);
    }

    public void set_calendar_and_return(Calendar calendar) {
        this.sct = new SetCalendarThread(this.negotiator, calendar);
        this.sct.start();
    }

    public String getUserId() {
        return this.myInfo.getUserId();
    }

    public void start() {
        super.start();
    }

    public void finish() {
        this.negotiator.finish();
    }

    public void runOneCycle() {
        Message message = null;
        message = this.mComm.getMessage(this.myInfo.getUserId());
        while (message != null) {
            this.processOneMessage(message);
            message = this.mComm.getMessage(this.myInfo.getUserId());
        }
    }

    public void processOneMessage(Message message) {
        Template template = RoomTemplate.getTemplateFromString(message.getMessage());
        if (template == null) {
            template = Template.getTemplateFromString(message.getMessage());
        }
        this.negotiator.receive_message(template, message.getSender());
    }

    public void xxxprocessLoop(LinkedList linkedList) {
        Message message = null;
        try {
            message = (Message)linkedList.removeFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            message = null;
        }
        while (message != null) {
            this.negotiator.receive_message(Template.getTemplateFromString(message.getMessage()), message.getSender());
            try {
                message = (Message)linkedList.removeFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                message = null;
            }
        }
    }

    public void runAsynch() {
        this.ioManager.writeLine("Waiting for incoming message...");
        while (true) {
            try {
                Thread.sleep(this.pollTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Message message = null;
            message = this.mComm.getMessage(this.myInfo.getUserId());
            if (message == null) continue;
            this.negotiator.receive_message(Template.getTemplateFromString(message.getMessage()), message.getSender());
        }
    }

    public void run() {
    }

    public boolean Qui() {
        int n = this.mComm.getNumMessages(this.myInfo.getUserId());
        return this.negotiator.inQuiescence() && n == 0;
    }

    public String openMeetings() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.negotiator.openMeetings.size(); ++i) {
            String string = (String)this.negotiator.openMeetings.get(i);
            stringBuffer.append(" " + string);
        }
        return stringBuffer.toString();
    }

    public boolean success(String string) {
        return this.negotiator.success(string);
    }

    public int rounds(String string) {
        return this.negotiator.rounds(string);
    }

    public double evaluateSchedule() {
        return this.negotiator.evaluateSchedule();
    }

    public void resetRoomScheduler(String string, String string2, String string3) {
        this.negotiator.resetRoomScheduler(string, string2, string3);
    }

    public double initialQuality() {
        return this.negotiator.initialQuality();
    }

    public String printCalendar() {
        return this.negotiator.calendar.toString();
    }

    public boolean isRequestActive() {
        if (this.negotiator instanceof RoomNegotiator) {
            return ((RoomNegotiator)this.negotiator).isRequestActive();
        }
        return false;
    }
}

