/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.neg.AbstractNegotiator;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sys.RManagerIO;
import java.util.HashMap;
import java.util.Vector;

public class SimpleNegotiator
extends AbstractNegotiator {
    HashMap responses = new HashMap();

    public SimpleNegotiator(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator) {
        super(rManagerIO, string, string2, scheduler, messageCommunicator);
    }

    public void receive_message(Template template, String string) {
        String string2 = template.getInitiator();
        if (string2.equals(this.myUserId) && !this.calendar.isCurrentMeeting(template.getMeetingId())) {
            Meeting meeting = new Meeting(this.myUserId, template);
            this.initiateMeeting(meeting, this.mComm);
        } else if (!this.calendar.isCurrentMeeting(template.getMeetingId())) {
            this.handleInitiateRequest(template, this.mComm);
        } else if (string2.equals(this.myUserId)) {
            this.handleAttendeeResponse(template, string, this.mComm);
        } else if (this.calendar.isPendingMeeting(template.getMeetingId())) {
            this.handleConfirmationRequest(template, this.mComm);
        }
    }

    public void initiateMeeting(Meeting meeting, MessageCommunicator messageCommunicator) {
        Object object;
        Template template = new Template(meeting.toTemplate());
        template.clearTimeSlots();
        SimpleNegotiator simpleNegotiator = this;
        template.addTimeSlot(simpleNegotiator.calendar.getFullRange(), "possible");
        Vector vector = this.ozone.processRequest(template);
        Template template2 = (Template)vector.elementAt(0);
        Meeting meeting2 = new Meeting(this.myUserId, template2);
        this.calendar.addMeeting(meeting2);
        Vector vector2 = template2.getPendingTimeSlots();
        if (vector2.size() == 0) {
            Vector vector3 = template2.getImpossibleTimeSlots();
            for (int i = 0; i < vector3.size(); ++i) {
                TimeSlot timeSlot = (TimeSlot)vector3.elementAt(i);
                meeting2.setTimeSlotStatus(this.myUserId, timeSlot, "impossible");
                this.logStatusChange(meeting2, timeSlot);
            }
            this.printStatus("Unable to find an open time for meeting " + meeting2.getMeetingId() + "!", 0);
            return;
        }
        meeting2.setStatus("pending");
        for (int i = 0; i < vector2.size(); ++i) {
            object = (TimeSlot)vector2.elementAt(i);
            meeting2.setTimeSlotStatus(this.myUserId, (TimeSlot)object, "pending");
            this.logStatusChange(meeting2, (TimeSlot)object);
        }
        Vector<String> vector4 = new Vector<String>();
        vector4.add(this.myUserId);
        this.responses.put(meeting2.getMeetingId(), vector4);
        object = meeting2.getAttendantIds();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            String string = (String)((Vector)object).get(i);
            if (string.equals(this.myUserId)) continue;
            this.printStatus("Initiating meeting " + meeting2.getMeetingId() + " with " + string, 0);
            messageCommunicator.sendMessage(meeting2.toLispList(), this.myUserId, string);
        }
    }

    public void handleInitiateRequest(Template template, MessageCommunicator messageCommunicator) {
        this.printStatus("Received request for meeting " + template.getMeetingId() + " from " + template.getInitiator(), 0);
        Meeting meeting = new Meeting(this.myUserId, template);
        Vector vector = template.getTimeSlots();
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)vector.get(i);
            String string = this.calendar.getMeetingIdFromTimeSlot(timeSlot);
            if (string == null) {
                meeting.setTimeSlotStatus(this.myUserId, timeSlot, "pending");
                this.logStatusChange(meeting, timeSlot);
                continue;
            }
            meeting.setTimeSlotStatus(this.myUserId, timeSlot, "impossible");
            this.logStatusChange(meeting, timeSlot);
        }
        this.calendar.addMeeting(meeting);
        String string = template.getInitiator();
        messageCommunicator.sendMessage(meeting.toLispList(), this.myUserId, string);
    }

    public void handleAttendeeResponse(Template template, String string, MessageCommunicator messageCommunicator) {
        int n;
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        ((Vector)this.responses.get(meeting.getMeetingId())).add(string);
        Vector vector = template.getTimeSlots();
        for (n = 0; n < vector.size(); ++n) {
            TimeSlot timeSlot = (TimeSlot)vector.elementAt(n);
            meeting.setTimeSlotStatus(string, timeSlot, template.getStatus(timeSlot));
        }
        n = this.checkForAllConfirmation(meeting, messageCommunicator) ? 1 : 0;
        if (n != 0 || this.allAttendantsResponded(meeting)) {
            if (n == 0 && this.allAttendantsResponded(meeting)) {
                this.printStatus("Unable to find an agreed upon time for " + meeting.getMeetingId() + "!", 0);
            }
            return;
        }
    }

    public void handleConfirmationRequest(Template template, MessageCommunicator messageCommunicator) {
        Meeting meeting = this.calendar.getMeeting(template.getMeetingId());
        TimeSlot timeSlot = template.getConfirmedTimeSlot();
        if (timeSlot == null) {
            System.out.println(" handleConfirmation(): No confirmed time!");
            return;
        }
        meeting.setTimeSlotStatus(this.myUserId, timeSlot, "confirmed");
        this.logStatusChange(meeting, timeSlot);
        meeting.setConfirmed();
        Template template2 = new Template(meeting.toTemplate());
        template2.clearTimeSlots();
        template2.addTimeSlot(timeSlot, "confirmed");
        Vector vector = this.ozone.processRequest(template2);
        Vector vector2 = meeting.getPendingTimeSlots();
        for (int i = 0; i < vector2.size(); ++i) {
            TimeSlot timeSlot2 = (TimeSlot)vector2.get(i);
            meeting.setTimeSlotStatus(this.myUserId, timeSlot2, "possible");
            this.logStatusChange(meeting, timeSlot2);
        }
        this.printStatus("Meeting " + meeting.getMeetingId() + " successfully scheduled.\n", 0);
        this.calendar.printCalendar(this.ioManager);
        this.calendar.checkConsistency(this.ioManager);
    }

    public boolean checkForAllConfirmation(Meeting meeting, MessageCommunicator messageCommunicator) {
        TimeSlot timeSlot = meeting.getPendingIntersection();
        if (timeSlot == null) {
            return false;
        }
        meeting.setTimeSlotStatus(this.myUserId, timeSlot, "confirmed");
        this.logStatusChange(meeting, timeSlot);
        meeting.setConfirmed();
        Template template = new Template(meeting.toTemplate());
        template.clearTimeSlots();
        template.addTimeSlot(timeSlot, "confirmed");
        Vector vector = this.ozone.processRequest(template);
        Vector vector2 = meeting.getPendingTimeSlots();
        for (int i = 0; i < vector2.size(); ++i) {
            TimeSlot timeSlot2 = (TimeSlot)vector2.get(i);
            meeting.setTimeSlotStatus(this.myUserId, timeSlot2, "possible");
            this.logStatusChange(meeting, timeSlot2);
        }
        Vector vector3 = meeting.getAttendantIds();
        for (int i = 0; i < vector3.size(); ++i) {
            String string = (String)vector3.elementAt(i);
            if (string.equals(this.myUserId)) continue;
            messageCommunicator.sendMessage(meeting.toLispList(), this.myUserId, string);
        }
        this.printStatus("Meeting " + meeting.getMeetingId() + " successfully scheduled.\n", 0);
        this.calendar.printCalendar(this.ioManager);
        this.calendar.checkConsistency(this.ioManager);
        return true;
    }

    public boolean allAttendantsResponded(Meeting meeting) {
        Vector vector = (Vector)this.responses.get(meeting.getMeetingId());
        Vector vector2 = meeting.getAttendantIds();
        for (int i = 0; i < vector2.size(); ++i) {
            String string = (String)vector2.elementAt(i);
            if (this.myUserId.equals(string) || vector.indexOf(string) >= 0) continue;
            return false;
        }
        return true;
    }

    public void setOptions(String string) {
        System.out.println("No options to set.");
    }
}

