/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.data.Meeting;
import cmradar.manager.neg.NegotiationLog;
import cmradar.manager.neg.RoomNegotiationLogEntry;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SimpleBayesMTypeLearner {
    HashMap agentRecords;
    ArrayList logEntries;
    NegotiationLog log;

    public SimpleBayesMTypeLearner(NegotiationLog negotiationLog) {
        this.log = negotiationLog;
        this.agentRecords = new HashMap();
        this.logEntries = new ArrayList();
        Iterator iterator = negotiationLog.getEntryList().values().iterator();
        while (iterator.hasNext()) {
            this.logEntries.add(iterator.next());
        }
    }

    public void clear() {
        this.agentRecords = new HashMap();
    }

    protected void learn(int n) {
        for (int i = 0; i < n; ++i) {
            int n2;
            RoomNegotiationLogEntry roomNegotiationLogEntry = (RoomNegotiationLogEntry)this.logEntries.get(i);
            if (!this.agentRecords.containsKey(roomNegotiationLogEntry.getOwnerId())) {
                this.agentRecords.put(roomNegotiationLogEntry.getOwnerId(), new AgentRecord(roomNegotiationLogEntry.getOwnerId()));
            }
            AgentRecord agentRecord = (AgentRecord)this.agentRecords.get(roomNegotiationLogEntry.getOwnerId());
            Integer n3 = new Integer(Meeting.typeStringToInt(roomNegotiationLogEntry.getCurrMeetingType()));
            if (!agentRecord.yesCountForType.containsKey(n3)) {
                agentRecord.yesCountForType.put(n3, new Integer(0));
                agentRecord.noCountForType.put(n3, new Integer(0));
            }
            if (roomNegotiationLogEntry.getResponse()) {
                ++agentRecord.yesCount;
                n2 = (Integer)agentRecord.yesCountForType.get(n3);
                agentRecord.yesCountForType.put(n3, new Integer(n2 + 1));
                continue;
            }
            ++agentRecord.noCount;
            n2 = (Integer)agentRecord.noCountForType.get(n3);
            agentRecord.noCountForType.put(n3, new Integer(n2 + 1));
        }
    }

    public void doLearning(int n) {
        this.learn(n);
        Iterator iterator = this.agentRecords.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AgentRecord agentRecord = (AgentRecord)this.agentRecords.get(string);
            agentRecord.yesProbability = (double)agentRecord.yesCount / ((double)agentRecord.yesCount + (double)agentRecord.noCount);
            Iterator iterator2 = agentRecord.yesCountForType.keySet().iterator();
            while (iterator2.hasNext()) {
                Integer n2 = (Integer)iterator2.next();
                int n3 = (Integer)agentRecord.yesCountForType.get(n2);
                int n4 = (Integer)agentRecord.noCountForType.get(n2);
                agentRecord.yesProbabilitiesForType.put(n2, new Double(((double)n3 + 0.5) / (double)(n3 + n4 + 1)));
            }
        }
    }

    public String run(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.doLearning(n);
        Iterator iterator = this.agentRecords.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AgentRecord agentRecord = (AgentRecord)this.agentRecords.get(string);
            stringBuffer.append(string + "\t" + agentRecord.yesProbability + "\t[");
            Iterator iterator2 = agentRecord.yesProbabilitiesForType.keySet().iterator();
            while (iterator2.hasNext()) {
                Integer n2 = (Integer)iterator2.next();
                stringBuffer.append(Meeting.getTypeString(n2) + ":" + (Double)agentRecord.yesProbabilitiesForType.get(n2));
                stringBuffer.append(",");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("]\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            System.out.println("Usage: in-filename out-filename <no-entries>");
        }
        try {
            NegotiationLog negotiationLog = new NegotiationLog(new BufferedReader(new FileReader(stringArray[0])));
            SimpleBayesMTypeLearner simpleBayesMTypeLearner = new SimpleBayesMTypeLearner(negotiationLog);
            int n = 0;
            n = stringArray.length == 2 ? negotiationLog.getEntryList().size() : Integer.parseInt(stringArray[2]);
            System.out.println("log entries=" + n);
            String string = simpleBayesMTypeLearner.run(n);
            PrintWriter printWriter = new PrintWriter(new FileWriter(stringArray[1]));
            printWriter.write(string);
            printWriter.close();
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class AgentRecord {
        String id;
        int yesCount;
        int noCount;
        HashMap yesCountForType;
        HashMap noCountForType;
        HashMap yesProbabilitiesForType;
        double yesProbability;

        AgentRecord(String string) {
            this.id = string;
            this.yesCount = 0;
            this.yesProbability = 0.0;
            this.noCount = 0;
            this.yesCountForType = new HashMap();
            this.noCountForType = new HashMap();
            this.yesProbabilitiesForType = new HashMap();
        }
    }
}

