/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.ext;

import cmradar.manager.ext.Matrix2;
import cmradar.manager.ext.ValuedObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class Learner {
    public static final Double FREE = new Double(0.0);
    public static final Double TAKEN = new Double(1.0);
    public static final Double UNSET = new Double(-1.0);
    public static final Double UNKNOWN = null;
    public static final double PENALTY = 0.05;
    Matrix2 _table;
    Vector _id2strV;

    public Learner() {
        this._table = new Matrix2();
    }

    public Learner(Matrix2 matrix2) {
        this._table = matrix2;
    }

    public int getLevel() {
        return this._table.getNumRows();
    }

    public void setId2StrV(Vector vector) {
        this._id2strV = vector;
    }

    public abstract HashMap inference(Vector var1, Object var2);

    protected int getIndex(String string) {
        if (this._id2strV != null) {
            return this._id2strV.indexOf(string);
        }
        return Integer.parseInt(string);
    }

    protected String id2str(int n) {
        if (this._id2strV != null) {
            return (String)this._id2strV.elementAt(n);
        }
        return String.valueOf(n);
    }

    public Vector toSortedVector(HashMap hashMap) {
        int n = this._table.getNumColumns();
        Vector<ValuedObject> vector = new Vector<ValuedObject>(n);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = this.getIndex(string);
            vector.add(new ValuedObject(n2, (Double)hashMap.get(string)));
        }
        Collections.sort(vector, Collections.reverseOrder());
        return vector;
    }
}

