/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.email;

import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sim.AgentInfo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;

public class EmailProcessor {
    AgentInfo myInfo;

    public EmailProcessor(AgentInfo agentInfo) {
        this.myInfo = agentInfo;
    }

    public String makeParseErrorMessage(String string) {
        String string2 = "  I am sorry. I was unable to understand the following message that you sent me.\nPlease reformat and resend.  If you need help with the format, see http://www.cs.cmu.edu/~cmradar/parsefaq/.\n\n" + this.myInfo.getAgentName() + " \n\n" + "<misparsed-message>\n" + string + "\n" + "</misparsed-message>\n";
        return string2;
    }

    public String makeUserConfirmMessage(Template template) {
        String string = this.myInfo.getUserName();
        String string2 = template.getDescription();
        String string3 = this.makeReadableTimeSlotString(template.getConfirmedTimeSlot());
        String string4 = "Dear " + string + ",\n\n" + "The meeting you requested has " + "been confirmed by all attendees.\n" + "The confirmed time is: \n\n\"" + string3 + "\" \n\n" + "For your reference, the description of this meeting was: \n\n" + "\"" + string2 + "\"" + "\n\n" + "---------------------------------\n";
        return string4;
    }

    public String makeUserFailedAgreementMessage(Template template) {
        String string = this.myInfo.getUserName();
        String string2 = template.getDescription();
        String string3 = "Dear " + string + ",\n\n" + "I am sorry, but each meeting time you requested was " + "rejected by some attendee.\n" + "You may re-initiate the meeting with new proposed times if you wish.\n" + "For your reference, " + "your description of this meeting was: \n\n" + "\"" + string2 + "\"" + "\n\n" + "---------------------------------\n";
        return string3;
    }

    public String makeConfirmMessage(Template template, String string) {
        if (template == null || string == null) {
            return "";
        }
        String string2 = this.makeReadableTimeSlotString(template.getConfirmedTimeSlot());
        String string3 = this.myInfo.getUserName();
        String string4 = template.getDescription();
        String string5 = "Dear " + string + ",\n\n" + "I am " + string3 + "'s CMRadar assistant.\n" + string3 + " has previously requested a meeting with you, and\n" + "a time for that meeting has been confirmed by all attendees.\n" + "The confirmed time is: \n\n\"" + string2 + "\" \n\n" + "Please add this meeting to your calendar. \n" + "For your reference, " + string3 + "'s description of this meeting was: \n\n" + "\"" + string4 + "\"" + "\n\n" + "---------------------------------\n";
        return string5;
    }

    public String makeProposeMessage(Template template, String string) {
        String string2;
        String string3 = template.getMeetingId();
        String string4 = this.myInfo.getUserName();
        String string5 = template.getDescription();
        Vector vector = template.getPendingTimeSlots();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            TimeSlot timeSlot = (TimeSlot)vector.elementAt(i);
            string2 = this.makeReadableTimeSlotString(timeSlot);
            vector2.add(string2);
        }
        String string6 = "";
        for (int i = 0; i < vector2.size(); ++i) {
            string2 = (String)vector2.elementAt(i);
            string6 = string6 + string2 + "";
            if (i + 1 >= vector2.size()) continue;
            string6 = string6 + " or ";
        }
        String string7 = "";
        for (int i = 0; i < vector2.size(); ++i) {
            String string8 = (String)vector2.elementAt(i);
            string7 = string7 + "time: " + string8 + " OK\n";
        }
        String string9 = "Dear " + string + ", \n" + "  I am " + string4 + "'s CMRadar assistant. " + string4 + " has requested a meeting with you. \n" + string4 + " says: \n\n \"" + string5 + "\"\n\n" + "The time(s) requested are: \n\n" + "\"" + string6 + "\"\n\n" + "Please respond by emailing back the following section, modifing the default 'OK' to 'NOTOK' as appropriate:\n" + "<template>\n" + "command initiate-meeting-reply\n" + "meetingid: " + string3 + "\n" + string7 + "</template>\n";
        return string9;
    }

    public String makeReadableTimeSlotString(TimeSlot timeSlot) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy");
        calendar.set(2, timeSlot.month());
        calendar.set(5, timeSlot.day());
        calendar.set(1, timeSlot.year());
        String string = simpleDateFormat.format(calendar.getTime());
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("H:mm");
        calendar.set(12, 0);
        calendar.set(10, timeSlot.st());
        String string2 = simpleDateFormat2.format(calendar.getTime());
        calendar.set(10, timeSlot.ft());
        String string3 = simpleDateFormat2.format(calendar.getTime());
        String string4 = string + " " + string2 + " to " + string3;
        return string4;
    }

    public static void main(String[] stringArray) {
        Template template = new Template();
        template.fillInTestData2();
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.fillInTestData1();
        EmailProcessor emailProcessor = new EmailProcessor(agentInfo);
        Vector vector = template.getAttendantIds();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            String string2 = emailProcessor.makeUserFailedAgreementMessage(template);
            System.out.println(string2);
        }
    }
}

