/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.demo;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;

public class DemoController {
    private JFrame controlFrame;
    private JButton pauseButton;
    private JButton playButton;
    private JButton stepButton;
    private boolean shouldWait = true;
    private boolean shouldStep = false;

    public DemoController(boolean bl) {
        if (!bl) {
            return;
        }
        this.controlFrame = new JFrame();
        Container container = this.controlFrame.getContentPane();
        container.setLayout(new GridLayout(1, 3));
        this.pauseButton = new JButton("Pause");
        this.playButton = new JButton("Play");
        this.stepButton = new JButton("Step");
        container.add(this.pauseButton);
        container.add(this.playButton);
        container.add(this.stepButton);
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DemoController.this.shouldWait = true;
                DemoController.this.pauseButton.setEnabled(false);
                DemoController.this.stepButton.setEnabled(true);
                DemoController.this.playButton.setEnabled(true);
            }
        });
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DemoController.this.shouldWait = false;
                DemoController.this.pauseButton.setEnabled(true);
                DemoController.this.stepButton.setEnabled(false);
                DemoController.this.playButton.setEnabled(false);
            }
        });
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DemoController.this.shouldStep = true;
            }
        });
        this.pauseButton.setEnabled(false);
        this.controlFrame.setDefaultCloseOperation(3);
        this.controlFrame.setBounds(10, 100, 210, 55);
        this.controlFrame.setVisible(true);
        this.controlFrame.setResizable(false);
        this.controlFrame.setTitle("Demo Controller");
    }

    public void tryWait() {
        while (this.shouldWait && !this.shouldStep) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Thread sleep interrupted. This should never happen");
                interruptedException.printStackTrace();
                System.exit(1);
            }
        }
        if (this.shouldStep) {
            this.shouldStep = false;
        }
    }

    public static void main(String[] stringArray) {
        DemoController demoController = new DemoController(true);
        int n = 0;
        System.out.println("foo");
        demoController.tryWait();
        System.out.println("bar");
        while (true) {
            System.out.println("i = " + n);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Thread sleep interrupted. This should never happen");
                interruptedException.printStackTrace();
                System.exit(1);
            }
            demoController.tryWait();
            ++n;
        }
    }
}

