/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.data;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Room;
import cmradar.manager.data.RoomCalendar;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.email.parse.EOFMatcher;
import cmradar.manager.email.parse.EOLMatcher;
import cmradar.manager.email.parse.Lexer;
import cmradar.manager.email.parse.OrMatcher;
import cmradar.manager.email.parse.Parser;
import cmradar.manager.email.parse.RegexMatcher;
import cmradar.manager.email.parse.SetMatcher;
import cmradar.manager.email.parse.StringMatcher;
import cmradar.manager.email.parse.Token;
import cmradar.manager.ext.Learner;
import cmradar.manager.ext.MemoryBasedLearner;
import cmradar.manager.ext.ValuedObject;
import cmradar.manager.sim.RoomMeetingInfo;
import cmradar.manager.sim.TestInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SharedRoomCalendar {
    public static final String SC_EXT = ".sharedroomcalendar";
    public static final String MTG_EXT = ".meetings";
    public static final String RSIM_EXT = ".rsim";
    private static final String roomIdLabel = "room-id:";
    private static final String meetingIdLabel = "meeting-id:";
    private static final String timeslotLabel = "time:";
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$data$SharedRoomCalendar == null ? (class$cmradar$manager$data$SharedRoomCalendar = SharedRoomCalendar.class$("cmradar.manager.data.SharedRoomCalendar")) : class$cmradar$manager$data$SharedRoomCalendar).getName());
    Learner _learner;
    Vector _id2strV;
    HashMap _calV;
    HashMap _est;
    TestInfo _info;
    HashMap roomCalendars;
    HashMap roomIdRoom;
    HashMap trueMeetingStatus;
    public static final int DAY = 0;
    public static final int WEEK = 1;
    public static final int MONTH = 2;
    static /* synthetic */ Class class$cmradar$manager$data$SharedRoomCalendar;

    public int getNumRooms() {
        return this._id2strV.size();
    }

    public String getRoomId(int n) {
        if (n >= this._id2strV.size()) {
            logger.log((Priority)Level.ERROR, (Object)" ID exceeds max");
            System.exit(0);
        }
        return (String)this._id2strV.elementAt(n);
    }

    public SharedRoomCalendar() {
        this.roomCalendars = new HashMap();
        this.roomIdRoom = new HashMap();
        this.trueMeetingStatus = new HashMap();
    }

    public SharedRoomCalendar(Vector vector, Vector vector2) {
        this();
        int n;
        for (n = 0; n < vector.size(); ++n) {
            this.addRoom((Room)vector.get(n));
        }
        for (n = 0; n < vector2.size(); ++n) {
            this.addRoom((Room)vector2.get(n));
        }
    }

    public SharedRoomCalendar(SharedRoomCalendar sharedRoomCalendar) {
        this.roomCalendars = (HashMap)sharedRoomCalendar.roomCalendars.clone();
        this.roomIdRoom = (HashMap)sharedRoomCalendar.roomIdRoom.clone();
        this.trueMeetingStatus = (HashMap)sharedRoomCalendar.trueMeetingStatus.clone();
    }

    public void setRoomIDMap(Vector vector) {
        this._id2strV = vector;
    }

    public void setLearner(Learner learner, TestInfo testInfo) {
        this._info = testInfo;
        this._learner = learner;
        this._learner.setId2StrV(this._id2strV);
        this._calV = new HashMap();
        this._est = new HashMap();
        Calendar calendar = Calendar.getInstance();
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-ddZ");
            calendar.setTime(simpleDateFormat.parse(testInfo.getStartDate()));
        }
        catch (Exception exception) {
            System.err.println("Calendar Parsing failed");
            exception.printStackTrace();
            System.exit(1);
        }
        int n = 24;
        for (int i = 0; i < testInfo.getTestDays(); ++i) {
            TimeSlot timeSlot = new TimeSlot(TimeSlot.sdf.format(calendar.getTime()), n);
            String string = timeSlot.getDay();
            Vector vector = this.cal2v(timeSlot);
            HashMap hashMap = this._learner.inference(vector, Learner.FREE);
            this.printUpdate(hashMap, timeSlot);
            this._est.put(string, hashMap);
            calendar.add(5, 1);
        }
    }

    public void updateTrueStatus(String string, int n, String string2, Double d) {
        logger.log((Priority)Level.INFO, (Object)("UPDATE " + string + " R" + n + " " + string2 + " " + d + "******"));
        this.trueMeetingStatus.put(string, d);
        Vector vector = (Vector)this._calV.get(string2);
        vector.setElementAt(d, n);
        this._calV.put(string2, vector);
    }

    public HashMap updateEvidence(String string, String string2, Object object) {
        Vector vector = (Vector)this._calV.get(string);
        try {
            vector.setElementAt(object, ((Room)this.roomIdRoom.get(string2)).getId());
            HashMap hashMap = this._learner.inference(vector, Learner.FREE);
            this._est.put(string, hashMap);
            Calendar calendar = Calendar.getInstance();
            try {
                calendar.setTime(new SimpleDateFormat("yyyy-MM-ddZ").parse(string));
            }
            catch (Exception exception) {
                System.err.println("Calendar Parsing failed");
                exception.printStackTrace();
                System.exit(0);
            }
            int n = 86400;
            TimeSlot timeSlot = new TimeSlot(TimeSlot.sdf.format(calendar.getTime()), n);
            return hashMap;
        }
        catch (Exception exception) {
            logger.log((Priority)Level.DEBUG, (Object)("r=" + string2 + " o=" + this.roomIdRoom.get(string2)));
            logger.log((Priority)Level.DEBUG, (Object)("rid=" + ((Room)this.roomIdRoom.get(string2)).getId()));
            logger.log((Priority)Level.DEBUG, (Object)(" >=?" + vector.size()));
            exception.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    private void printUpdate(HashMap hashMap, TimeSlot timeSlot) {
        Vector vector = ((MemoryBasedLearner)this._learner).toSortedVector(hashMap);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ValuedObject valuedObject = (ValuedObject)enumeration.nextElement();
            String string = (String)this._id2strV.elementAt(valuedObject.getId());
            LinkedList linkedList = this.getMeetings((Room)this.roomIdRoom.get(string), timeSlot);
            String string2 = "";
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Meeting meeting = (Meeting)iterator.next();
                String string3 = this.getTrueMeetingStatus(meeting.getMeetingId());
                if (string3 == null) {
                    string2 = string2 + "meetings=null " + string + " " + meeting.getMeetingId();
                    continue;
                }
                string2 = string2 + (string3.equals("possible") ? "[ ]" : "[X]");
                string2 = string2 + " " + (meeting.getStatus().equals("unknown") ? "?" : "v");
            }
            logger.log((Priority)Level.DEBUG, (Object)(string + ":" + valuedObject + " t=" + string2));
        }
    }

    public HashMap getCalVectors() {
        return this._calV;
    }

    private Vector cal2v(TimeSlot timeSlot) {
        String string = timeSlot.getDay();
        int n = this._id2strV.size();
        Vector<Double> vector = new Vector<Double>(n);
        block0: for (int i = 0; i < n; ++i) {
            Room room = (Room)this.roomIdRoom.get(this._id2strV.elementAt(i));
            LinkedList linkedList = this.getMeetings(room, timeSlot);
            if (linkedList == null || linkedList.size() == 0) {
                vector.add(Learner.FREE);
                continue;
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Meeting meeting = (Meeting)iterator.next();
                if (meeting.getMeetingId().startsWith("__UNKNOWN__")) {
                    vector.add(null);
                    continue;
                }
                vector.add(Learner.TAKEN);
                continue block0;
            }
        }
        this._calV.put(string, vector);
        return vector;
    }

    public HashMap getEstimation() {
        return this._est;
    }

    public String getTrueMeetingStatus(String string) {
        return (String)this.trueMeetingStatus.get(string);
    }

    public void setTrueStatusMap(HashMap hashMap) {
        this.trueMeetingStatus = hashMap;
    }

    public void syncAll() {
        Iterator iterator = this.roomCalendars.values().iterator();
        while (iterator.hasNext()) {
            RoomCalendar roomCalendar = (RoomCalendar)iterator.next();
            roomCalendar.sync();
        }
    }

    public Meeting getMeetingFromId(String string) {
        Iterator iterator = this.roomCalendars.values().iterator();
        while (iterator.hasNext()) {
            RoomCalendar roomCalendar = (RoomCalendar)iterator.next();
            LinkedList linkedList = roomCalendar.getMeetings(string);
            if (linkedList.isEmpty()) continue;
            return ((RoomCalendar.RoomSchedInfo)linkedList.getFirst()).getMeeting();
        }
        return null;
    }

    public Room getRoomFromId(String string) {
        return (Room)this.roomIdRoom.get(string);
    }

    public ArrayList xxxtoTemplates() {
        ArrayList<RoomTemplate> arrayList = new ArrayList<RoomTemplate>();
        Iterator iterator = this.roomCalendars.values().iterator();
        while (iterator.hasNext()) {
            RoomCalendar roomCalendar = (RoomCalendar)iterator.next();
            LinkedList linkedList = roomCalendar.getMeetings();
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                RoomCalendar.RoomSchedInfo roomSchedInfo = (RoomCalendar.RoomSchedInfo)iterator2.next();
                Meeting meeting = roomSchedInfo.getMeeting();
                RoomTemplate roomTemplate = new RoomTemplate();
                roomTemplate.meetingId = meeting.meetingId;
                roomTemplate.initiator = meeting.initiator;
                for (int i = 0; i < meeting.attendants.size(); ++i) {
                    String string = (String)meeting.attendants.get(i);
                    roomTemplate.addAttendant(string, 10.0);
                    TimeSlot timeSlot = roomSchedInfo.getTimeSlot();
                    timeSlot.location = roomSchedInfo.getRoom().getRoomId();
                    roomTemplate.addTimeSlot(timeSlot, "confirmed");
                    roomTemplate.setPredefinedKind(meeting.getTypeString());
                    arrayList.add(roomTemplate);
                }
            }
        }
        return arrayList;
    }

    public ArrayList toTemplates() {
        ArrayList<RoomTemplate> arrayList = new ArrayList<RoomTemplate>();
        Iterator iterator = this.roomCalendars.values().iterator();
        while (iterator.hasNext()) {
            RoomCalendar roomCalendar = (RoomCalendar)iterator.next();
            logger.log((Priority)Level.DEBUG, (Object)("room[" + roomCalendar.getRoom().getRoomId() + "] mtgs=" + roomCalendar.getMeetings().size()));
            Iterator iterator2 = roomCalendar.getMeetings().iterator();
            while (iterator2.hasNext()) {
                RoomCalendar.RoomSchedInfo roomSchedInfo = (RoomCalendar.RoomSchedInfo)iterator2.next();
                Meeting meeting = roomSchedInfo.getMeeting();
                RoomTemplate roomTemplate = meeting.toRoomTemplate();
                arrayList.add(roomTemplate);
                logger.log((Priority)Level.DEBUG, (Object)("m" + meeting.getMeetingId() + ":" + meeting.getStatus() + "," + roomTemplate.getStatus() + " md=" + meeting.getDuration() + " td=" + roomTemplate.getDuration() + " +"));
            }
        }
        return arrayList;
    }

    public RoomTemplate toTemplate(String string, String string2, String string3) {
        Iterator iterator;
        RoomCalendar roomCalendar = (RoomCalendar)this.roomCalendars.get(string);
        LinkedList linkedList = roomCalendar.getMeetings(string2);
        if (linkedList.size() > 1) {
            logger.log((Priority)Level.ERROR, (Object)("WARNING:toTemplate more than one meeting with the same ID " + string2));
            System.exit(0);
        }
        if ((iterator = linkedList.iterator()).hasNext()) {
            RoomCalendar.RoomSchedInfo roomSchedInfo = (RoomCalendar.RoomSchedInfo)iterator.next();
            Meeting meeting = roomSchedInfo.getMeeting();
            RoomTemplate roomTemplate = new RoomTemplate();
            roomTemplate.meetingId = meeting.meetingId;
            roomTemplate.initiator = meeting.initiator;
            for (int i = 0; i < meeting.attendants.size(); ++i) {
                String string4 = (String)meeting.attendants.get(i);
                roomTemplate.addAttendant(string4, 10.0);
                TimeSlot timeSlot = roomSchedInfo.getTimeSlot();
                timeSlot.location = roomSchedInfo.getRoom().getRoomId();
                if (!string3.equals("bumped")) {
                    roomTemplate.addTimeSlot(timeSlot, string3);
                }
                roomTemplate.setPredefinedKind(meeting.getTypeString());
            }
            return roomTemplate;
        }
        return null;
    }

    public String toLispList() throws MultiRoomError {
        ArrayList arrayList = this.toTemplates();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < arrayList.size(); ++i) {
            RoomTemplate roomTemplate = (RoomTemplate)arrayList.get(i);
            stringBuffer.append(roomTemplate.toLispList());
        }
        return stringBuffer.toString();
    }

    public void addRoom(Room room) {
        String string = room.getRoomId();
        if (this.roomCalendars.get(string) != null) {
            throw new IllegalArgumentException("Attempting to add room already in calendar." + room.getRoomId());
        }
        RoomCalendar roomCalendar = new RoomCalendar(room);
        this.roomCalendars.put(string, roomCalendar);
        this.roomIdRoom.put(string, room);
    }

    public boolean removeMeeting(Room room, Meeting meeting) {
        RoomCalendar roomCalendar = (RoomCalendar)this.roomCalendars.get(room.getRoomId());
        if (roomCalendar.removeMeeting(meeting)) {
            roomCalendar.sync();
            return false;
        }
        return true;
    }

    public boolean removeMeeting(String string) {
        Iterator iterator = this.roomCalendars.values().iterator();
        while (iterator.hasNext()) {
            RoomCalendar roomCalendar = (RoomCalendar)iterator.next();
            if (!roomCalendar.removeMeeting(string)) continue;
            roomCalendar.sync();
            return false;
        }
        return true;
    }

    public boolean confirmMeeting(Room room, Meeting meeting, TimeSlot timeSlot, boolean bl) {
        RoomCalendar roomCalendar = (RoomCalendar)this.roomCalendars.get(room.getRoomId());
        if (roomCalendar == null) {
            throw new IllegalArgumentException("Trying to add a meeting to room not in calendar: roomid=" + room.getRoomId());
        }
        meeting.clearTimeSlots();
        meeting.setTimeSlotStatus(timeSlot, "confirmed");
        meeting.setStatus("confirmed");
        if (!roomCalendar.addMeeting(meeting, timeSlot, bl)) {
            roomCalendar.sync();
            return false;
        }
        return true;
    }

    public boolean addMeeting(Room room, Meeting meeting, TimeSlot timeSlot, boolean bl) {
        RoomCalendar roomCalendar = (RoomCalendar)this.roomCalendars.get(room.getRoomId());
        if (roomCalendar == null) {
            throw new IllegalArgumentException("Trying to add a meeting to room not in calendar: roomid=" + room.getRoomId());
        }
        if (!roomCalendar.addMeeting(meeting, timeSlot, bl)) {
            roomCalendar.sync();
            logger.log((Priority)Level.INFO, (Object)("adding meeting failed " + meeting));
            return false;
        }
        return true;
    }

    public boolean addMeeting(Room room, Meeting meeting, TimeSlot timeSlot, boolean bl, String string) {
        this.trueMeetingStatus.put(meeting.getMeetingId(), string);
        return this.addMeeting(room, meeting, timeSlot, bl);
    }

    public boolean isFree(Room room, TimeSlot timeSlot) {
        RoomCalendar roomCalendar = (RoomCalendar)this.roomCalendars.get(room.getRoomId());
        if (roomCalendar == null) {
            throw new IllegalArgumentException("Trying to get meetings for room not in calendar.");
        }
        return roomCalendar.isFree(timeSlot);
    }

    public LinkedList getRooms() {
        Set set = this.roomCalendars.keySet();
        Iterator iterator = set.iterator();
        LinkedList<Room> linkedList = new LinkedList<Room>();
        while (iterator.hasNext()) {
            Room room = (Room)this.roomIdRoom.get(iterator.next());
            linkedList.add(room);
        }
        return linkedList;
    }

    public LinkedList getFreeRooms(TimeSlot timeSlot) {
        Set set = this.roomCalendars.keySet();
        Iterator iterator = set.iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RoomCalendar roomCalendar = (RoomCalendar)this.roomCalendars.get(string);
            if (!roomCalendar.isFree(timeSlot)) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    public LinkedList getMeetings(Room room, TimeSlot timeSlot) {
        RoomCalendar roomCalendar = (RoomCalendar)this.roomCalendars.get(room.getRoomId());
        if (roomCalendar == null) {
            throw new IllegalArgumentException("Trying to get meetings for room not in calendar:");
        }
        return roomCalendar.getMeetings(timeSlot);
    }

    public LinkedList getMeetings(TimeSlot timeSlot, String string) {
        RoomCalendar roomCalendar = (RoomCalendar)this.roomCalendars.get(timeSlot.location);
        if (roomCalendar == null) {
            throw new IllegalArgumentException("Trying to get meetings for room not in calendar:" + timeSlot.location);
        }
        return roomCalendar.getMeetings(timeSlot, string);
    }

    public static TimeSlot parseTimeSlot(Parser parser) throws ParseException {
        RegexMatcher regexMatcher = new RegexMatcher("\\d\\d.\\d\\d.\\d\\d\\d\\d", "MM.DD.YYYY");
        RegexMatcher regexMatcher2 = new RegexMatcher("\\d?\\d:\\d\\d", "HH:MM");
        String string = parser.nextToken(regexMatcher).toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy");
        simpleDateFormat.setTimeZone(TimeSlot.sdf.getTimeZone());
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat2.setTimeZone(TimeSlot.sdf.getTimeZone());
        String string2 = simpleDateFormat2.format(simpleDateFormat.parse(string));
        String string3 = parser.nextToken(regexMatcher2).toString();
        parser.nextToken(new StringMatcher("to"));
        String string4 = parser.nextToken(regexMatcher2).toString();
        String string5 = string2 + " [" + string3 + " " + TimeSlot._timezoneName + "]";
        String string6 = string2 + " [" + string4 + " " + TimeSlot._timezoneName + "]";
        return new TimeSlot(string5, string6);
    }

    public static RoomMeetingInfo parseRoomMeeting(Parser parser) throws ParseException {
        String string = null;
        String string2 = null;
        TimeSlot timeSlot = null;
        StringMatcher stringMatcher = new StringMatcher("</room>");
        OrMatcher orMatcher = new OrMatcher(new EOLMatcher(), new RegexMatcher(">*", "should never be seen"));
        SetMatcher setMatcher = new SetMatcher();
        StringMatcher stringMatcher2 = new StringMatcher(roomIdLabel);
        StringMatcher stringMatcher3 = new StringMatcher(meetingIdLabel);
        StringMatcher stringMatcher4 = new StringMatcher(timeslotLabel);
        setMatcher.addMatcher(stringMatcher2);
        setMatcher.addMatcher(stringMatcher3);
        setMatcher.addMatcher(stringMatcher4);
        parser.filterWhile(orMatcher);
        parser.nextToken(new StringMatcher("<room-meeting>"));
        parser.filterWhile(orMatcher);
        while (!setMatcher.isEmpty()) {
            Token token = parser.nextToken(setMatcher);
            String string3 = token.toString();
            if (string3.equals(roomIdLabel)) {
                string = parser.nextToken(new RegexMatcher("[^\\n]+", "<room id>")).toString();
                setMatcher.removeMatcher(stringMatcher2);
            } else if (string3.equals(meetingIdLabel)) {
                string2 = parser.nextToken(new RegexMatcher("[^\\n]+", "<meeting id>")).toString();
                setMatcher.removeMatcher(stringMatcher3);
            } else if (string3.equals(timeslotLabel)) {
                timeSlot = SharedRoomCalendar.parseTimeSlot(parser);
                setMatcher.removeMatcher(stringMatcher4);
            }
            parser.filterWhile(orMatcher);
        }
        parser.nextToken(new StringMatcher("</room-meeting>"));
        return new RoomMeetingInfo(string, string2, timeSlot);
    }

    public void writeToFile(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(this.toParseString() + "\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.err.println("SharedRoomCalendar.writeToFile(): Error writing to file: " + string);
        }
    }

    public String toParseString() {
        return this.toParseString(false);
    }

    public String toParseString(boolean bl) {
        Iterator iterator = this.roomCalendars.values().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            RoomCalendar roomCalendar = (RoomCalendar)iterator.next();
            stringBuffer.append(roomCalendar.toParseString(bl));
        }
        return stringBuffer.toString();
    }

    public void disableRoom(String string, String string2, String string3) {
        RoomCalendar roomCalendar = (RoomCalendar)this.roomCalendars.get(string);
        if (roomCalendar == null) {
            System.out.println("CMRadar can't disable unknown room[" + string + "]");
            return;
        }
    }

    public static LinkedList parseMeetingList(BufferedReader bufferedReader) throws IOException {
        Lexer lexer = new Lexer('#', " \r\t\n\f", ",\\");
        LinkedList linkedList = null;
        EOFMatcher eOFMatcher = new EOFMatcher();
        LinkedList<RoomMeetingInfo> linkedList2 = new LinkedList<RoomMeetingInfo>();
        OrMatcher orMatcher = new OrMatcher(new EOLMatcher(), new RegexMatcher(">*", "should never be seen"));
        linkedList = lexer.lex(bufferedReader);
        Parser parser = new Parser(linkedList);
        while (parser.hasTokens() && !parser.headMatches(eOFMatcher)) {
            try {
                linkedList2.addLast(SharedRoomCalendar.parseRoomMeeting(parser));
            }
            catch (cmradar.manager.email.parse.ParseException parseException) {
                parseException.printStackTrace();
                System.out.println("Error parsing room list. Expected " + parseException.getExpectedString() + ", but found " + parseException.getFoundString() + " at line " + parseException.getLineIndex() + " character " + parseException.getCharIndex() + ".");
                System.exit(1);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                System.out.println("Invalid date at line " + parser.getLineIndex() + " character " + parser.getCharIndex());
                System.exit(1);
            }
            parser.filterWhile(orMatcher);
        }
        return linkedList2;
    }

    public void addCrisis(Vector vector, Vector vector2, String string, String string2) {
        int n = 0;
        Vector<String> vector3 = new Vector<String>();
        vector3.add("Randal");
        Iterator iterator = this.roomCalendars.values().iterator();
        while (iterator.hasNext()) {
            RoomCalendar roomCalendar = (RoomCalendar)iterator.next();
            if (!vector2.contains(roomCalendar.getRoom().getBuilding())) continue;
            for (int i = 0; i < vector.size(); ++i) {
                TimeSlot timeSlot;
                Meeting meeting;
                TimeSlot timeSlot2 = (TimeSlot)vector.elementAt(i);
                double d = timeSlot2.getStartTime();
                double d2 = timeSlot2.getFinishTime();
                LinkedList linkedList = roomCalendar.getMeetings(timeSlot2);
                Object object = linkedList.iterator();
                while (object.hasNext()) {
                    meeting = (Meeting)object.next();
                    timeSlot = meeting.getConfirmedTimeSlot();
                    if (timeSlot == null) {
                        logger.log((Priority)Level.INFO, (Object)("T=" + timeSlot2 + ",M=" + timeSlot + " " + meeting.getMeetingId()));
                        System.exit(0);
                    }
                    double d3 = timeSlot.getStartTime();
                    double d4 = timeSlot.getFinishTime();
                    if (d <= d3 && d4 <= d2) {
                        logger.log((Priority)Level.INFO, (Object)("cancel " + meeting.getMeetingId()));
                        roomCalendar.removeMeeting(meeting);
                        continue;
                    }
                    if (d3 < d) {
                        timeSlot.setFinishTime(d);
                        logger.log((Priority)Level.INFO, (Object)("finish early " + meeting.getMeetingId()));
                        continue;
                    }
                    if (!(d2 < d4)) continue;
                    timeSlot.setStartTime(d2);
                    logger.log((Priority)Level.INFO, (Object)("delay " + meeting.getMeetingId()));
                }
                object = string2 + n++;
                meeting = new Meeting(string, (String)object, string, -2, vector3);
                timeSlot = new TimeSlot(timeSlot2);
                meeting.setDuration(timeSlot.getDurationSecond());
                meeting.setTimeSlotStatus(string, timeSlot, "confirmed");
                this.addMeeting(roomCalendar.getRoom(), meeting, timeSlot, true);
            }
        }
    }

    public void saveFile(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.writeToFile(string + SC_EXT);
        Iterator iterator = this.roomCalendars.values().iterator();
        while (iterator.hasNext()) {
            object4 = (RoomCalendar)iterator.next();
            object3 = ((RoomCalendar)object4).getMeetings();
            object2 = ((AbstractSequentialList)object3).iterator();
            while (object2.hasNext()) {
                object = (RoomCalendar.RoomSchedInfo)object2.next();
                Meeting meeting = ((RoomCalendar.RoomSchedInfo)object).getMeeting();
                meeting.writeToFile(string + MTG_EXT, true);
            }
        }
        try {
            object4 = new BufferedWriter(new FileWriter(string + RSIM_EXT));
            object3 = this.trueMeetingStatus.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (String)this.trueMeetingStatus.get(object2);
                ((Writer)object4).write((String)object2 + " " + (String)object + "\n");
            }
            ((BufferedWriter)object4).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        System.out.println("saved " + string + SC_EXT + "," + MTG_EXT + ", " + RSIM_EXT);
    }

    public void quickHtml(String string, Properties properties) {
        String string2 = properties.getProperty("cmradar.crisisdays").trim();
        String string3 = properties.getProperty("cmradar.timezone").trim().substring(3);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("<table border=1>\n");
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                this.quickHtmlSub(bufferedWriter, stringArray[i], 7, 21, string3);
            }
            bufferedWriter.write("</table>\n");
            bufferedWriter.close();
            logger.log((Priority)Level.DEBUG, (Object)("HTML file saved into " + string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void quickHtmlSub(BufferedWriter bufferedWriter, String string, int n, int n2, String string2) {
        try {
            Object object;
            Object object2;
            bufferedWriter.write("<tr><td>TIME</td>");
            for (int i = n; i < n2; ++i) {
                object2 = string + " [" + i + ":00 " + string2 + "]";
                String string3 = string + " [" + (i + 1) + ":00 " + string2 + "]";
                object = new TimeSlot((String)object2, string3);
                bufferedWriter.write("<td>" + ((TimeSlot)object).toParseString() + "</td>");
            }
            bufferedWriter.write("</tr>");
            Iterator iterator = this.roomCalendars.values().iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write("<tr>\n");
                object2 = (RoomCalendar)iterator.next();
                bufferedWriter.write("<td>" + ((RoomCalendar)object2).getRoom().getRoomId() + "@" + ((RoomCalendar)object2).getRoom().getBuilding() + "</td>");
                for (int i = n; i < n2; ++i) {
                    object = string + " [" + i + ":00 " + string2 + "]";
                    String string4 = string + " [" + (i + 1) + ":00 " + string2 + "]";
                    TimeSlot timeSlot = new TimeSlot((String)object, string4);
                    bufferedWriter.write("<td>");
                    LinkedList linkedList = ((RoomCalendar)object2).getMeetings(timeSlot);
                    if (linkedList.size() == 0) {
                        bufferedWriter.write("&nbsp;");
                    }
                    Iterator iterator2 = linkedList.iterator();
                    while (iterator2.hasNext()) {
                        Meeting meeting = (Meeting)iterator2.next();
                        if (meeting.getMeetingId().startsWith("__UNAVAILABLE__")) {
                            bufferedWriter.write("U");
                            continue;
                        }
                        if (meeting.getMeetingId().startsWith("__TAKEN__")) {
                            bufferedWriter.write("T");
                            continue;
                        }
                        String string5 = meeting.getMeetingId();
                        String string6 = this.getTrueMeetingStatus(string5);
                        if (string6 != null) {
                            bufferedWriter.write("?" + (string6.equals("confirmed") ? "t" : "f"));
                            continue;
                        }
                        bufferedWriter.write(string5);
                    }
                    bufferedWriter.write("</td>");
                }
                bufferedWriter.write("</tr>\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RoomTimePair {
        private Room room;
        private TimeSlot time;

        public RoomTimePair(Room room, TimeSlot timeSlot) {
            this.room = room;
            this.time = timeSlot;
        }

        Room getRoom() {
            return this.room;
        }

        TimeSlot getTimeSlot() {
            return this.time;
        }
    }

    public class MultiRoomError
    extends Exception {
        public MultiRoomError(String string) {
            super(string);
        }
    }
}

