package SpaceTime.DataModel.VendorOrders;


/**
* SpaceTime/DataModel/VendorOrders/OrdersManagerOperations.java .
* Generated by the IDL-to-Java compiler (portable), version "3.2"
* from SpaceTime/DataModel/VendorOrders/OrdersManager.idl
* Monday, May 5, 2008 1:37:26 PM EDT
*/


/**
	The controller class for managing orders. Provides lookup and modification
	functionality.
	Passed by reference.
	*/
public interface OrdersManagerOperations 
{
  void ClearPreOrders () throws Ch.Elca.Iiop.GenericUserException;

  /// Preorders count
  int PreOrdersCount () throws Ch.Elca.Iiop.GenericUserException;

  /// Returns pre order at specified index
  SpaceTime.DataModel.VendorOrders.PreOrder PreOrderAt (int index) throws Ch.Elca.Iiop.GenericUserException;
  void AddPreOrder (SpaceTime.DataModel.VendorOrders.PreOrder po) throws Ch.Elca.Iiop.GenericUserException;

  /// new orders
  long AddConfirmedOrder (SpaceTime.DataModel.VendorOrders.Order o) throws Ch.Elca.Iiop.GenericUserException;
  void RemoveConfirmedOrderByExternalId (String id) throws Ch.Elca.Iiop.GenericUserException;
  long AddOrder (SpaceTime.DataModel.VendorOrders.Order o) throws Ch.Elca.Iiop.GenericUserException;
  void ClearOrders () throws Ch.Elca.Iiop.GenericUserException;
  long AddDerivedOrder (SpaceTime.DataModel.VendorOrders.Order o, long multiorderId) throws Ch.Elca.Iiop.GenericUserException;
  long[] GetAllOrderIds () throws Ch.Elca.Iiop.GenericUserException;
  SpaceTime.DataModel.VendorOrders.Order GetOrder (long id) throws Ch.Elca.Iiop.GenericUserException;
  long[] GetIdByExternalId (String id) throws Ch.Elca.Iiop.GenericUserException;
  long[] GetAllConfirmedOrderIds () throws Ch.Elca.Iiop.GenericUserException;
  SpaceTime.DataModel.VendorOrders.Order GetConfirmedOrder (long id) throws Ch.Elca.Iiop.GenericUserException;

  /// @ADD
  void ClearOrderChanges () throws Ch.Elca.Iiop.GenericUserException;

  /// Placements count
  int PlacementsCount () throws Ch.Elca.Iiop.GenericUserException;
  void AddPlacement (SpaceTime.DataModel.VendorOrders.OrderChange ob) throws Ch.Elca.Iiop.GenericUserException;

  /// Returns placement at specified index
  SpaceTime.DataModel.VendorOrders.OrderChange PlacementAt (int index) throws Ch.Elca.Iiop.GenericUserException;

  /// Cancellatuins count
  int CancellationsCount () throws Ch.Elca.Iiop.GenericUserException;
  void AddCancellation (SpaceTime.DataModel.VendorOrders.OrderChange ob) throws Ch.Elca.Iiop.GenericUserException;

  /// Returns cancellation at specified index
  SpaceTime.DataModel.VendorOrders.OrderChange CancellationAt (int index) throws Ch.Elca.Iiop.GenericUserException;

  /// Modification count
  int ModificationsCount () throws Ch.Elca.Iiop.GenericUserException;
  void AddModification (SpaceTime.DataModel.VendorOrders.OrderChange mod) throws Ch.Elca.Iiop.GenericUserException;

  /// Returns the old state of the order modification at the specified index
  SpaceTime.DataModel.VendorOrders.OrderChange ModificationAt (int index) throws Ch.Elca.Iiop.GenericUserException;
  long[] GetAllMultiorderIds () throws Ch.Elca.Iiop.GenericUserException;
  SpaceTime.DataModel.VendorOrders.Multiorder GetMultiorder (long id) throws Ch.Elca.Iiop.GenericUserException;
  void RemoveMultiorder (long id) throws Ch.Elca.Iiop.GenericUserException;

  //factory method
  SpaceTime.DataModel.VendorOrders.Multiorder CreateMultiorder (String eventId, String vendorId, int cost, String roomId, long startTime, int duration, String externalId, String URL) throws Ch.Elca.Iiop.GenericUserException;
  void AddMultiorder (SpaceTime.DataModel.VendorOrders.Multiorder multiorder) throws Ch.Elca.Iiop.GenericUserException;
  SpaceTime.DataModel.VendorOrders.OrderChange CreateOrderChange (double utility, SpaceTime.DataModel.VendorOrders.OrderBase oldOrder, SpaceTime.DataModel.VendorOrders.OrderBase newOrder) throws Ch.Elca.Iiop.GenericUserException;
} // interface OrdersManagerOperations
