package SpaceTime.DataModel;


/**
* SpaceTime/DataModel/SpaceTimeDataAdapterOperations.java .
* Generated by the IDL-to-Java compiler (portable), version "3.2"
* from SpaceTime/DataModel/SpaceTimeDataAdapter.idl
* Monday, May 5, 2008 1:37:16 PM EDT
*/


/**
	SpaceTimeDataAdapter provides a thin abstraction to query and allows
	to manipulate the space-time world state. Data loaded from XML is
	stored in a tree structure of SpaceTimeNodes according to Space Time
	objects hierarchy (like room hierarchy). Lookup and modification methods
	are provided
	*/
public interface SpaceTimeDataAdapterOperations 
{

  ///@ADD Update time slots
  void UpdateTimeSlots (SpaceTime.DataModel.TimeSlot[] slots) throws Ch.Elca.Iiop.GenericUserException;

  // Deliver a new vendor email
  void VendorEmailArrived (String subject, String body) throws Ch.Elca.Iiop.GenericUserException;

  ///@ADD Gets room requested (CMRadar integration)
  SpaceTime.DataModel.RoomRequestor GetRoomRequestor () throws Ch.Elca.Iiop.GenericUserException;

  ///@ADD Returns bumping penalty function
  SpaceTime.DataModel.CertainPlf GetBumpingPenaltyFunction () throws Ch.Elca.Iiop.GenericUserException;

  ///@ADD
  void SetBumpingPenaltyFunction (SpaceTime.DataModel.CertainPlf function) throws Ch.Elca.Iiop.GenericUserException;

  /// @ADD Bumping penalty function priority
  int GetBumpingPenaltyFunctionPriority () throws Ch.Elca.Iiop.GenericUserException;
  void SetBumpingPenaltyFunctionPriority (int priority) throws Ch.Elca.Iiop.GenericUserException;

  ///ADD
  int PdefCount () throws Ch.Elca.Iiop.GenericUserException;
  SpaceTime.DataModel.SpaceTimeNodePropertyDef PdefAt (int index) throws Ch.Elca.Iiop.GenericUserException;
  int EpdefCount () throws Ch.Elca.Iiop.GenericUserException;
  SpaceTime.DataModel.SpaceTimeNodePropertyDef EpdefAt (int index) throws Ch.Elca.Iiop.GenericUserException;
  int AssociationsCount () throws Ch.Elca.Iiop.GenericUserException;
  SpaceTime.DataModel.SpaceTimeNodeAssociation AssociationAt (int index) throws Ch.Elca.Iiop.GenericUserException;

  /// Returns the object with parameters from params.txt file
  SpaceTime.DataModel.Parameters GetParameters () throws Ch.Elca.Iiop.GenericUserException;
  boolean VendorOrdersInitialized () throws Ch.Elca.Iiop.GenericUserException;

  /// Vendors manager
  SpaceTime.DataModel.VendorOrders.VendorsManager GetVendorsManager () throws Ch.Elca.Iiop.GenericUserException;

  /// Orders manager
  SpaceTime.DataModel.VendorOrders.OrdersManager GetOrdersManager () throws Ch.Elca.Iiop.GenericUserException;

  /// Creates new edge object at the server side, edge is not associated with any node
  SpaceTime.DataModel.SpaceTimeEdge CreateEdge (String target, String edgeType) throws Ch.Elca.Iiop.GenericUserException;

  /// Creates new propery object on the server side
  SpaceTime.DataModel.SpaceTimeProperty CreateProperty (String propertyType) throws Ch.Elca.Iiop.GenericUserException;

  /// Binds a new ChangeListener to the adapter
  void AddGlobalChangeListener (SpaceTime.DataModel.ChangeListener listener) throws Ch.Elca.Iiop.GenericUserException;

  /// Unbinds ChangeListener from the adapter
  void RemoveGlobalChangeListener (SpaceTime.DataModel.ChangeListener listener) throws Ch.Elca.Iiop.GenericUserException;

  /// Binds a new EventListener to the adapter
  void AddEventListener (SpaceTime.DataModel.EventListener listener) throws Ch.Elca.Iiop.GenericUserException;

  /// Unbinds EventListener from the adapter
  void RemoveEventListener (SpaceTime.DataModel.EventListener listener) throws Ch.Elca.Iiop.GenericUserException;

  /// Fully flush all node events and bindings
  void Unbind () throws Ch.Elca.Iiop.GenericUserException;

  /// Generates "notification done" event and notifies event listeners
  void NotifyElicitationDone (String url) throws Ch.Elca.Iiop.GenericUserException;

  /// Generates "vendor optimizer done" event and notifies event listeners
  void NotifyVendorOptimizerDone () throws Ch.Elca.Iiop.GenericUserException;

  /// Generates "vendor elicitor done" event and notifies event listeners
  void NotifyVendorElicitorDone (String filename) throws Ch.Elca.Iiop.GenericUserException;

  /// Generates "shedule published" event and notifies event listeners
  void NotifySchedulePublished (String url) throws Ch.Elca.Iiop.GenericUserException;

  /// Generates "optimization done" event and notifies event listeners
  void NotifyOptimizationDone () throws Ch.Elca.Iiop.GenericUserException;

  /// Generates "end of wargames" event and notifies event listeners
  void NotifyEndOfWargames () throws Ch.Elca.Iiop.GenericUserException;

  /// Generates "end of batch learning" event and notifies event listeners
  void NotifyEndOfBatchLearning (String url) throws Ch.Elca.Iiop.GenericUserException;

  /// Scenario start in unix time format
  long GetScenarioStart () throws Ch.Elca.Iiop.GenericUserException;

  /// Scenario duration
  long GetScenarioDuration () throws Ch.Elca.Iiop.GenericUserException;

  /// Scenario stop in unix time format
  long GetScenarioStop () throws Ch.Elca.Iiop.GenericUserException;

  /// @ADD Shift time
  void ShiftTime (int seconds) throws Ch.Elca.Iiop.GenericUserException;

  /// Global score
  float GetGlobalScore () throws Ch.Elca.Iiop.GenericUserException;

  /// Envokes the optimizer to get event scores
  void UpdateScore () throws Ch.Elca.Iiop.GenericUserException;

  /// Gets all rooms
  SpaceTime.DataModel.DMArrayList GetRooms () throws Ch.Elca.Iiop.GenericUserException;

  /// Gets all people
  SpaceTime.DataModel.DMArrayList GetPeople () throws Ch.Elca.Iiop.GenericUserException;

  /// Gets all requests
  SpaceTime.DataModel.DMArrayList GetRequests () throws Ch.Elca.Iiop.GenericUserException;

  /**
  		Return only the most derrived nodes from the id specified.
  		The return value is a list of SpaceTimeDataObjectNodes
  		*/
  SpaceTime.DataModel.DMArrayList GetLeafNodesById (String id) throws Ch.Elca.Iiop.GenericUserException;

  /// Get the node that matches id
  SpaceTime.DataModel.SpaceTimeNode GetNodeById (String id) throws Ch.Elca.Iiop.GenericUserException;

  /// Gets the deepest property with the name propertyType defined in the tree.
  SpaceTime.DataModel.SpaceTimeProperty GetProperty (SpaceTime.DataModel.SpaceTimeNode node, String propertyType) throws Ch.Elca.Iiop.GenericUserException;

  /// Returns the association type of the provided property
  String GetPropertyAssociationType (String requestPref) throws Ch.Elca.Iiop.GenericUserException;

  /// Returns associated weight name
  String GetAssociatedWeightName (String propertyName) throws Ch.Elca.Iiop.GenericUserException;

  /// Returns associated propery name
  String GetAssociatedPropertyName (String propertyName) throws Ch.Elca.Iiop.GenericUserException;

  /// Checks if property is associated
  boolean IsPropertyAssociated (String propertyName) throws Ch.Elca.Iiop.GenericUserException;

  /// Clears the scores for all nodes
  void FlushScores () throws Ch.Elca.Iiop.GenericUserException;

  /**
  		Loads the set of default rules for rooms from the
  		specified file or URL. New set replaces the old one
  		*/
  void LoadRoomDefaultRules (String filename) throws Ch.Elca.Iiop.GenericUserException;

  /**
  		Loads the set of default rules for events from the
  		specified file or URL. New set replaces the old one
  		*/
  void LoadEventDefaultRules (String filename) throws Ch.Elca.Iiop.GenericUserException;

  /// Applies the default rules to all nodes (both events and rooms) for which the rules are allowed.
  void ApplyDefaultRulesToAllNodes () throws Ch.Elca.Iiop.GenericUserException;

  /// Applies the default rules to all rooms for which the rules are allowed.
  void ApplyDefaultRulesToAllRooms () throws Ch.Elca.Iiop.GenericUserException;

  /// Applies the default rules to all events for which the rules are allowed.
  void ApplyDefaultRulesToAllEvents () throws Ch.Elca.Iiop.GenericUserException;

  /// Applies the default rules the node if the rules are allowed for this node.
  void ApplyDefaultRulesToNode (SpaceTime.DataModel.SpaceTimeNode node) throws Ch.Elca.Iiop.GenericUserException;

  /// Current optimization hint string
  String GetOptimizationHint () throws Ch.Elca.Iiop.GenericUserException;

  /** 
  		Merge optimizer output with the current worldstate.
  		"end of optimization" event is generated
  		*/
  void MergeOptimizationResults (SpaceTime.DataModel.DMArrayList assignments, double score) throws Ch.Elca.Iiop.GenericUserException;

  /// Merge a list of assignments with the current worldstate.
  void MergeAssignments (SpaceTime.DataModel.DMArrayList assignments) throws Ch.Elca.Iiop.GenericUserException;

  /**
  		Creates a node from an xml string and adds it to the data adapter.
  		The node is added to the tree hierarchy according to its EDGE properites.
  		If no inheritance is defined the node is added to the root tree node.
  		*/
  SpaceTime.DataModel.SpaceTimeNode CreateNode (String xml) throws Ch.Elca.Iiop.GenericUserException;

  /// Save object model to xml
  void Save (String filename, boolean restoreOriginal) throws Ch.Elca.Iiop.GenericUserException;

  /// Save object model to xml, optionally fixing allocations
  void SaveToFile (String filename, boolean fixAssigned, boolean fixUnassigned, boolean restoreOriginal) throws Ch.Elca.Iiop.GenericUserException;

  //void SaveToFile(in ::CORBA::WStringValue filename, in boolean fixAssigned, in boolean fixUnassigned) raises (::Ch::Elca::Iiop::GenericUserException);
  void SaveInheritedStpToFile (String filename, boolean fixAssigned, boolean fixUnassigned, boolean restoreOriginal) throws Ch.Elca.Iiop.GenericUserException;

  /// Produces XML string for current worldstate
  String SaveAsString (boolean fixAssigned, boolean fixUnassigned, boolean restoreOriginal) throws Ch.Elca.Iiop.GenericUserException;

  /// Produces an xml fragment that represents the node reference provided.
  String GetNodeXml (String nodeId, boolean restoreOriginal) throws Ch.Elca.Iiop.GenericUserException;

  /// Optimization is recommended flag
  boolean IsOptRecommended ();

  /// Optimization is recommended flag
  void IsOptRecommended (boolean newIsOptRecommended);

  /// @ADD
  String WorkingPath ();

  /// @ADD
  void WorkingPath (String newWorkingPath);
} // interface SpaceTimeDataAdapterOperations
