package SpaceTime.DataModel;

import edu.cmu.cs.radar.integ.ICMRadarProvides.EventInformation;
import edu.cmu.cs.radar.integ.ICMRadarProvides.EventInformation.Preference;

public class RoomRequestImpl extends RoomRequest {
	private final static String START_PREF = "start";
	private final static String CAPACITY_PREF = "Capacity";
	
	public RoomRequestImpl(){
	}
	
	public EventInformation toCMRadarFormat(){
		Preference startPref = new Preference(START_PREF);
		for(int i=0; i<_startPref.Size()-1;i++){
			double x1 = _startPref.GetX(i);
			double y1 = _startPref.GetY(i);
			double x2 = _startPref.GetX(i+1);
			double y2 = _startPref.GetY(i+1);
			if(y1==1 && y2==1){
				startPref.AddInterval(x1, x2);
			}
		}
		
		String capacityProperty = _configuration+CAPACITY_PREF;
		Preference capacityPref = new Preference(capacityProperty);
		capacityPref.AddInterval(_capacity_low, _capacity_high);
		
		EventInformation ev_info = new EventInformation("Randal", _eventId , startPref,
				  _duration, (float)_gain);
		ev_info.addAdditionalPref(capacityPref);
		
		return ev_info;
	}

}
