package SpaceTime.DataModel;

import Ch.Elca.Iiop.GenericUserException;

public class CertainPlfImpl extends CertainPlf {
	
	public void AddPoint (double x, double y){
		int new_length = (_data!=null)?_data.length+2:2;
		double[] newArray = new double[new_length];
		if(_data!=null){
			for(int i=0;i<_data.length;i++){
				newArray[i]=_data[i];
			}
		}
		newArray[new_length-2]=x;
		newArray[new_length-1]=y;
		_data = newArray;
	}
	
	public CertainPlfImpl(){
		_data = null;
	}
	
	public CertainPlfImpl(double[] data) {
		if(data!=null){
			_data = new double[data.length];
			for(int i=0;i<data.length;i++){
				_data[i] = data[i];
			}
		}
	}

	public Tuple GetMax(){
		int maxYindex=0;			 
		for (int i = 1; i < Size(); i++) {
			if(GetY(maxYindex)<GetY(i)) maxYindex=i;
		}
		return new TupleImpl(GetX(maxYindex),GetY(maxYindex));
	}

	public double GetMaxY(){
        double max = 0.0;
        for (int i = 0; i < Size(); i++) {
            max = Math.max(GetY(i), max);
        }
        return max;
	}

	public LinearFunctionIntervals GetThresholdedIntervals(double threshold){
        LinearFunctionIntervals intervals = new LinearFunctionIntervals();

        if (Size() == 0) {
            return intervals;
        }

        double prevX = GetX(0);
        double prevY = GetY(0);
        double start = prevX;
        for (int i = 1; i < Size(); i++) {
            double x = GetX(i);
            double y = GetY(i);

            double slope = (y - prevY) / (x - prevX);
            if ((y < threshold) && (prevY >= threshold)) {
                double stop = x;
                if (x > prevX) {
                    stop = prevX + ((threshold - prevY) * (x - prevX)) / (y - prevY);
                }
                intervals.Add(start, stop);
            }
            else if ((y >= threshold) && (prevY < threshold)) {
                start = x;
                if (x > prevX) {
                    start = prevX + ((threshold - prevY) * (x - prevX)) / (y - prevY);
                }
            }
            prevX = x;
            prevY = y;
        }

        return intervals;
	}

	public double GetX(int index){
		return (double)_data[index*2];
	}

	public double GetY(int index){
		return (double)_data[(index*2)+1];
	}

	public double GetYatX(double x){
		int n = Size()-1;
		if(x<=GetX(0)){
			return GetY(0);
		}
		else if(x>=GetX(n)){
			return GetY(n);
		}else{
			return GetYatX(x,0,n);
		}
	}
	
	//returns point value for partial PLF defined by points for indeces
	//from n1 to n2. We assume that x is within range x(n1) to x(n2)
	private double GetYatX(double x, int n1, int n2){
		if(n2==n1+1){
			double x1 = GetX(n1);
			double x2 = GetX(n2);
			double y1 = GetY(n1);
			double y2 = GetY(n2);
			return y1+(x-x1)*(y2-y1)/(x2-x1);
		}
		//recursive part
		else{
			int n_mid = (n2+n1)/2;
			double x_mid = GetX(n_mid);
			if(x<x_mid){
				return GetYatX(x,n1,n_mid);
			}
			else{
				return GetYatX(x,n_mid,n2);
			}
		}
	}

	public int Size(){
		return (_data.length/2);
	}
}
