// $Id: ICMRadarRequires.java,v 3.3 2007/03/05 16:39:44 jordan Exp $

package edu.cmu.cs.radar.integ;

import java.util.*;
import java.text.SimpleDateFormat;

/**
 * This interface encapsulates what the CMRadar GUI will call.
 * In other words, it's how the rest of Radar looks to CMRadar.
 */
public interface ICMRadarRequires {
    public void foundRoom(Reservation result);		

    public class Reservation  {

	/* reservation ID */
	String id;

	/* name of room */
	String roomId;

	/* name of building */ 
	String buildingId;

	/* room properties: property name -> value */
	HashMap properties;

	/* start time of reservation */
	double startTime;

	/* finish time of reservation */
	double finishTime;

	/* duration of reservation in seconds */
	long duration; 

	/* type of room acquisition */
	int type;

	public static final int FREE = 0;
	public static final int BUMP = 1;
	public static final int FAIL = 2;    
	public static final int EXT = 3;    
	private static final String [] _statNames = { "free", "bump", "fail", "external" };

	public static SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd [HH:mm Z]"); 
	static { _sdf.setTimeZone(TimeZone.getTimeZone("GMT")); }

	/* constructor 
	 * type indicates the way how the room was achieved 
	 * FREE: the room was not in use
	 * BUMP: the existing owner was asked to bump
	 * FAIL: fail to find a room for this request
	 */
	public Reservation (String resvId, String room, String building, 
			    double start, double finish, 
			    HashMap prop, int t) {
	    this.id = resvId;
	    this.roomId = room;
	    this.buildingId = building;
	    this.startTime = start;
	    this.finishTime = finish;
	    this.properties = prop;
	    this.type = t;
	}

	public void setId(String id) { this.id = id; }
	public void setRoomId(String id) { this.roomId = id; }
	public void setStartTime(double time) { this.startTime = time; }
	public void setFinishTime(double time) { this.finishTime = time; }
	//public void setDuration(long d) { this.duration = d; }

	/* returns event id */
	public String getRequestId() { return id; }

	/* returns room id */
	public String getRoomId() { return roomId; }

	/* returns building id */
	public String getBuildingId() { return buildingId; }

	/* returns the start time in Date object */
	public double getStartTime() { return startTime;   }

	public static String getStringStatus(int i) {
	    return _statNames[i];
	}

	/* returns the start time in String format:"yyyy-MM-dd [HH:mm Z]" */
	public String getStartTimeString() { return _sdf.format(new Date((long)startTime*1000)); }
	public String getFinishTimeString() { return _sdf.format(new Date((long)finishTime*1000)); }

	/* returns the finish time */
	public double getFinishTime() { return finishTime; }
	
	/* numeric room properties name<String> - value<Double>*/
	public HashMap getRoomProperties() { return properties; }

	/* returns duration in a type in {java.util.Calendar.SECOND, MINUTE, HOUR} */
	/*
	public long getDuration(int type) {
	    long d = this.duration;
	    switch(type) {
	    case Calendar.SECOND:	    
		break;
	    case Calendar.MINUTE:
		d /= 60;
		break;
	    case Calendar.HOUR:
		d /= 3600;
	    default:
		break;
	    }
	    return d;
	}
	*/

	public String toString() {
	    if (roomId == null) return "Reservation:" + id + " status: FAIL";
	    return "Reservation:" + id + "@" + roomId + "@" + buildingId 
		+ " from " + getStartTimeString() 
		+ " to " + getFinishTimeString();
	}
    }
}
