/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sched;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.Meeting;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sched.Scheduler;
import java.util.Iterator;
import java.util.Vector;

public class SimpleScheduler
implements Scheduler {
    private Calendar cal = null;
    private static int DEFAULT_RETURN_SLOTS = 1;
    private int bumpingStrategy = 0;
    private boolean bumps = false;
    private boolean pendings = true;

    public void startScheduler(String string, String string2) {
        this.cal = new Calendar(string, string2);
    }

    private Vector processPossibleRequest(Template template, int n, TimeSlot timeSlot) {
        Meeting meeting;
        Vector<Template> vector = new Vector<Template>();
        if (timeSlot.ft() - timeSlot.st() != 1) {
            template.removeTimeSlot(timeSlot);
            timeSlot = new TimeSlot(timeSlot.startTime);
            if (Template.indexOf(template.timeSlots, timeSlot) < 0) {
                template.addTimeSlot(timeSlot, "possible");
            }
        }
        if ((meeting = this.cal.getOverlapMeetingFromTimeSlot(timeSlot)) == null) {
            meeting = this.cal.getMeeting(template.getMeetingId());
            if (meeting == null) {
                meeting = new Meeting(this.cal.getUserId(), template);
                this.cal.addMeeting(meeting);
                String string = "possible";
                if (this.pendings) {
                    string = "pending";
                }
                meeting.setTimeSlotStatus(timeSlot, string);
                template.setStatus(timeSlot, string);
            } else {
                String string = "possible";
                if (this.pendings) {
                    string = "pending";
                }
                meeting.setTimeSlotStatus(timeSlot, string);
                template = meeting.toTemplate();
            }
            vector.add(template);
        } else {
            if (meeting.getMeetingId().equals(template.getMeetingId())) {
                template = meeting.toTemplate();
                vector.add(template);
                return vector;
            }
            if (this.shouldBump(meeting, template)) {
                Meeting meeting2 = this.cal.getMeeting(template.getMeetingId());
                if (meeting2 == null) {
                    meeting2 = new Meeting(this.cal.getUserId(), template);
                    this.cal.addMeeting(meeting2);
                }
                TimeSlot timeSlot2 = meeting.getConfirmedTimeSlot();
                meeting.setTimeSlotStatus(timeSlot2, "impossible");
                String string = "possible";
                if (this.pendings) {
                    string = "pending";
                }
                meeting2.setTimeSlotStatus(timeSlot, string);
                template.setStatus(timeSlot, string);
                vector.add(meeting2.toTemplate());
                vector.add(meeting.toTemplate());
            } else {
                Meeting meeting3 = this.cal.getMeeting(template.getMeetingId());
                if (meeting3 == null) {
                    meeting3 = new Meeting(this.cal.getUserId(), template);
                    this.cal.addMeeting(meeting3);
                }
                TimeSlot timeSlot3 = timeSlot;
                TimeSlot timeSlot4 = timeSlot;
                boolean bl = false;
                boolean bl2 = false;
                int n2 = 0;
                template.setStatus(timeSlot, "impossible");
                Vector vector2 = template.getImpossibleTimeSlots();
                System.out.println("SimpleScheduler:curEarliest.decrement(),increment() commented out!");
                while (!(n2 >= n || bl && bl2)) {
                    String string;
                    timeSlot3 = new TimeSlot(timeSlot3);
                    timeSlot4 = new TimeSlot(timeSlot4);
                    if (TimeSlot.before(timeSlot3.startTime, timeSlot.earliestStartTime)) {
                        bl = true;
                    }
                    if (TimeSlot.after(timeSlot4.finishTime, timeSlot.latestFinishTime)) {
                        bl2 = true;
                    }
                    if (!bl && this.cal.getOverlapMeetingFromTimeSlot(timeSlot3) == null && Template.indexOf(vector2, timeSlot3) < 0) {
                        string = "possible";
                        if (this.pendings) {
                            string = "pending";
                        }
                        meeting3.setTimeSlotStatus(timeSlot3, string);
                        template.addTimeSlot(timeSlot3, string);
                        ++n2;
                    }
                    if (n2 >= n || bl2 || this.cal.getOverlapMeetingFromTimeSlot(timeSlot4) != null || Template.indexOf(vector2, timeSlot4) >= 0) continue;
                    string = "possible";
                    if (this.pendings) {
                        string = "pending";
                    }
                    meeting3.setTimeSlotStatus(timeSlot4, string);
                    template.addTimeSlot(timeSlot4, string);
                    ++n2;
                }
                vector.add(template);
            }
        }
        return vector;
    }

    private Vector processPendingRequest(Template template, int n, TimeSlot timeSlot) {
        Meeting meeting = this.cal.getOverlapMeetingFromTimeSlot(timeSlot);
        Vector<Template> vector = new Vector<Template>();
        if (meeting == null) {
            meeting = this.cal.getMeeting(template.getMeetingId());
            if (meeting == null) {
                meeting = new Meeting(this.cal.getUserId(), template);
                this.cal.addMeeting(meeting);
            }
            String string = "possible";
            if (this.pendings) {
                string = "pending";
            }
            meeting.setTimeSlotStatus(timeSlot, string);
        } else {
            if (meeting.getMeetingId().equals(template.getMeetingId())) {
                template = meeting.toTemplate();
                vector.add(template);
                return vector;
            }
            template.setStatus(timeSlot, "impossible");
        }
        vector.add(template);
        return vector;
    }

    private Vector processImpossibleRequest(Template template, int n, TimeSlot timeSlot) {
        Meeting meeting = this.cal.getMeeting(template.getMeetingId());
        Vector<Template> vector = new Vector<Template>();
        if (meeting != null) {
            Iterator iterator = meeting.getTimeSlots().iterator();
            while (iterator.hasNext()) {
                TimeSlot timeSlot2 = (TimeSlot)iterator.next();
                if (!timeSlot2.overlaps(timeSlot)) continue;
                meeting.setTimeSlotStatus(timeSlot2, "impossible");
            }
        }
        vector.add(template);
        return vector;
    }

    private Vector processConfirmedRequest(Template template, int n, TimeSlot timeSlot) {
        Vector<Template> vector = new Vector<Template>();
        Meeting meeting = this.cal.getOverlapMeetingFromTimeSlot(timeSlot);
        if (meeting == null) {
            meeting = this.cal.getMeeting(template.getMeetingId());
            if (meeting == null) {
                meeting = new Meeting(this.cal.getUserId(), template);
                this.cal.addMeeting(meeting);
            }
            meeting.setTimeSlotStatus(timeSlot, "confirmed");
            if (!this.pendings) {
                Vector vector2 = this.cal.getMeetingIds();
                for (int i = 0; i < vector2.size(); ++i) {
                    String string = (String)vector2.get(i);
                    Meeting meeting2 = this.cal.getMeeting(string);
                    if (!meeting2.getTimeSlotStatus(this.cal.getUserId(), timeSlot).equals("possible")) continue;
                    meeting2.setTimeSlotStatus(timeSlot, "impossible");
                }
            }
        } else if (meeting.getMeetingId().equals(template.getMeetingId())) {
            Iterator iterator = meeting.getTimeSlots().iterator();
            while (iterator.hasNext()) {
                TimeSlot timeSlot2 = (TimeSlot)iterator.next();
                meeting.setTimeSlotStatus(timeSlot2, "impossible");
            }
            meeting.setTimeSlotStatus(timeSlot, "confirmed");
        } else {
            template.setStatus(timeSlot, "impossible");
        }
        vector.add(template);
        return vector;
    }

    public Vector processRequest(Template template, int n) {
        template = new Template(template);
        Iterator iterator = template.getTimeSlots().iterator();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            TimeSlot timeSlot = (TimeSlot)iterator.next();
            String string = template.getStatus(timeSlot);
            if (string.equals("possible")) {
                return this.processPossibleRequest(template, n, timeSlot);
            }
            if (string.equals("pending")) {
                return this.processPendingRequest(template, n, timeSlot);
            }
            if (string.equals("impossible")) {
                if (template.getTimeSlots().size() != 1) continue;
                return this.processImpossibleRequest(template, n, timeSlot);
            }
            if (!string.equals("confirmed")) continue;
            return this.processConfirmedRequest(template, n, timeSlot);
        }
        return null;
    }

    public Vector processRequest(Template template) {
        return this.processRequest(template, DEFAULT_RETURN_SLOTS);
    }

    public Vector processRequestList(Vector vector) {
        Iterator iterator = vector.iterator();
        Vector<Vector> vector2 = new Vector<Vector>();
        while (iterator.hasNext()) {
            Template template = (Template)iterator.next();
            vector2.add(this.processRequest(template, DEFAULT_RETURN_SLOTS));
        }
        return vector2;
    }

    private boolean shouldBump(Meeting meeting, Template template) {
        if (!this.bumps || this.bumpingStrategy == 0 || meeting.getConfirmedTimeSlot() == null) {
            return false;
        }
        if (this.bumpingStrategy == 2) {
            return true;
        }
        if (this.bumpingStrategy == 1) {
            return template.getAttendantIds().size() > meeting.getAttendantIds().size();
        }
        if (this.bumpingStrategy == 3) {
            return Meeting.typeStringToInt(template.getPredefinedKind()) > Meeting.typeStringToInt(meeting.getTypeString());
        }
        return false;
    }

    public void setBumping(boolean bl) {
        this.bumps = bl;
    }

    public void saveModel() {
    }

    public void setPending(boolean bl) {
        this.pendings = bl;
    }

    public void setBumpingStrategy(int n) {
        if (n == 2 || n == 0 || n == 1 || n == 3) {
            this.bumpingStrategy = n;
        } else {
            System.out.println("Unknown strategy in setBumpingStrategy(): " + n);
        }
    }

    public double evaluateSchedule() {
        return 0.0;
    }

    public void resetRoomSchedulerFiles(String string, String string2, String string3) {
    }

    public String processRoomRequest(String string, int n) {
        return "null";
    }

    public Vector processRoomRequest(RoomTemplate roomTemplate, int n) {
        return null;
    }

    public String processRoomRequestList(String string) {
        return "null";
    }

    public Vector processRoomRequestList(Vector vector) {
        return null;
    }

    public static void main(String[] stringArray) {
        Template template;
        int n;
        System.out.println("I am SimpleScheduler");
        SimpleScheduler simpleScheduler = new SimpleScheduler();
        simpleScheduler.startScheduler("A", "SimpleMorning");
        simpleScheduler.setBumping(false);
        simpleScheduler.setBumpingStrategy(1);
        Template template2 = new Template();
        template2.meetingId = "10001";
        template2.initiator = "A";
        template2.addAttendant("A", 1.0);
        template2.addAttendant("B", 1.0);
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [8:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [18:00 -0500]";
        timeSlot.startTime = "2004-06-25 [9:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [10:00 -0500]";
        template2.addTimeSlot(timeSlot, "confirmed");
        template2.addPurpose("13", "nil", "nil");
        Vector<Template> vector = new Vector<Template>();
        vector.add(template2);
        simpleScheduler.processRequest(template2);
        template2 = new Template();
        template2.meetingId = "41";
        template2.initiator = "A";
        template2.addAttendant("A", 1.0);
        template2.addAttendant("B", 1.0);
        template2.addAttendant("C", 1.0);
        timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [8:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [18:00 -0500]";
        timeSlot.startTime = "2004-06-25 [9:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [10:00 -0500]";
        template2.addTimeSlot(timeSlot, "possible");
        template2.addPurpose("14", "nil", "nil");
        vector.add(template2);
        Vector vector2 = simpleScheduler.processRequest(template2, 5);
        for (n = 0; n < vector2.size(); ++n) {
            template = (Template)vector2.elementAt(n);
            System.out.println(n + " " + template.toString());
        }
        vector2 = simpleScheduler.processRequest(template2, 5);
        for (n = 0; n < vector2.size(); ++n) {
            template = (Template)vector2.elementAt(n);
            System.out.println(n + " " + template.toString());
        }
    }
}

