/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.neg.LogEntry;
import cmradar.manager.neg.LogInterface;
import java.util.StringTokenizer;

public class NegotiationLogEntry
extends LogEntry
implements LogInterface {
    private String meetingId;
    private int messageCount;
    private int roundCount;
    private String bumpId;
    protected long startTime;
    protected long endTime;
    private boolean result;
    protected static final String delimiter = " ";

    public NegotiationLogEntry(String string, int n, int n2, String string2, long l, boolean bl) {
        this.messageCount = n;
        this.roundCount = n2;
        this.bumpId = string2;
        this.meetingId = string;
        this.startTime = 0L;
        this.endTime = l;
        this.result = bl;
        this.id = string;
    }

    public NegotiationLogEntry() {
        this.meetingId = "-1";
        this.messageCount = 0;
        this.roundCount = 0;
        this.bumpId = "-1";
        this.startTime = 0L;
        this.endTime = 0L;
        this.result = false;
    }

    public void parseEntry(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        this.id = this.meetingId = stringTokenizer.nextToken();
        this.messageCount = Integer.parseInt(stringTokenizer.nextToken());
        this.roundCount = Integer.parseInt(stringTokenizer.nextToken());
        this.bumpId = stringTokenizer.nextToken();
        this.startTime = 0L;
        this.endTime = Long.parseLong(stringTokenizer.nextToken());
        this.endTime *= 1000L;
        this.result = Boolean.valueOf(stringTokenizer.nextToken());
    }

    public String formatString() {
        return "#mtgid msgs rounds bumpid time result\n";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.meetingId + delimiter);
        stringBuffer.append(this.messageCount + delimiter);
        stringBuffer.append(this.roundCount + delimiter);
        stringBuffer.append(this.bumpId + delimiter);
        stringBuffer.append((this.endTime - this.startTime) / 1000L + delimiter);
        stringBuffer.append(this.result);
        return stringBuffer.toString();
    }

    public void setMeetingId(String string) {
        this.meetingId = string;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public void setRoundCount(int n) {
        this.roundCount = n;
    }

    public int getRoundCount() {
        return this.roundCount;
    }

    public void incRoundCount() {
        ++this.roundCount;
    }

    public void setMessageCount(int n) {
        this.messageCount = n;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void incMessageCount() {
        ++this.messageCount;
    }

    public void setStartTime(long l) {
        this.startTime = l;
        this.endTime = l;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public long getTime() {
        return this.endTime - this.startTime;
    }

    public void setBumpId(String string) {
        this.bumpId = string;
    }

    public String getBumpId() {
        return this.bumpId;
    }

    public void setResult(boolean bl) {
        this.result = bl;
    }

    public boolean getResult() {
        return this.result;
    }

    public static void main(String[] stringArray) {
        NegotiationLogEntry negotiationLogEntry = new NegotiationLogEntry();
        negotiationLogEntry.parseEntry("532 2 3 3 23 true");
        System.out.println(negotiationLogEntry.toString());
    }
}

