/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.neg;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Room;
import cmradar.manager.data.SharedRoomCalendar;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.neg.AbstractNegotiator;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sched.SimpleRoomScheduler;
import cmradar.manager.sim.MessageCommunicator;
import cmradar.manager.sys.RManagerIO;
import cmradar.manager.sys.SchedulerInvoker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public abstract class AbstractRoomNegotiator
extends AbstractNegotiator {
    SharedRoomCalendar sharedRCal;

    public AbstractRoomNegotiator(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator) {
        super(rManagerIO, string, string2, scheduler, messageCommunicator);
        this.sharedRCal = null;
    }

    public AbstractRoomNegotiator(RManagerIO rManagerIO, String string, String string2, Scheduler scheduler, MessageCommunicator messageCommunicator, SharedRoomCalendar sharedRoomCalendar) {
        super(rManagerIO, string, string2, scheduler, messageCommunicator);
        this.sharedRCal = sharedRoomCalendar;
    }

    public void setSharedRCal(SharedRoomCalendar sharedRoomCalendar) {
        this.sharedRCal = sharedRoomCalendar;
        this.initializeScheduler();
    }

    public SharedRoomCalendar getSharedRCal() {
        return this.sharedRCal;
    }

    public void initializeScheduler() {
        try {
            if (this.ozone instanceof SimpleRoomScheduler) {
                ((SimpleRoomScheduler)this.ozone).set_calendar(this.sharedRCal);
            } else if (this.ozone != null) {
                if (!SchedulerInvoker.REUSE_SHARED_CAL) {
                    ArrayList arrayList = this.sharedRCal.toTemplates();
                    this.ozone.processRoomRequestList(new Vector(arrayList));
                    HashMap hashMap = this.sharedRCal.getEstimation();
                    if (hashMap != null) {
                        Iterator iterator = hashMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            ((SchedulerInvoker)this.ozone).updateAvailabilityList((HashMap)hashMap.get(string), string);
                        }
                    }
                } else {
                    System.out.println("Sharedroomcarlenda was initialized in the lisp application for Y2Redo test....");
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            System.exit(0);
        }
    }

    protected boolean ownMeetingForTime(TimeSlot timeSlot, Room room) {
        LinkedList linkedList = this.sharedRCal.getMeetings(room, timeSlot);
        for (int i = 0; i < linkedList.size(); ++i) {
            if (!((Meeting)linkedList.get((int)i)).initiator.equals(this.myUserId)) continue;
            return true;
        }
        return false;
    }

    protected ArrayList myMeetingsForTime(TimeSlot timeSlot, Room room) {
        ArrayList arrayList = new ArrayList();
        LinkedList linkedList = this.sharedRCal.getMeetings(room, timeSlot);
        for (int i = 0; i < linkedList.size(); ++i) {
            if (!((Meeting)linkedList.get((int)i)).initiator.equals(this.myUserId)) continue;
            arrayList.add(linkedList.get(i));
        }
        return arrayList;
    }
}

