/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.email;

import cmradar.manager.email.EmailCallback;
import cmradar.manager.email.EmailIO;
import cmradar.manager.email.EmailMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EMailIOSwing
implements EmailIO {
    private Map messages;
    private String me;
    private String fromAddress;
    private LinkedList incoming;
    private ArrayList wnds;
    private EmailCallback call;

    public EMailIOSwing(String string) {
        this.fromAddress = string;
        this.messages = new HashMap();
        this.incoming = new LinkedList();
        this.wnds = new ArrayList();
        new MsgManager();
    }

    public EMailIOSwing(String string, EmailCallback emailCallback) {
        this.call = emailCallback;
        this.fromAddress = string;
        this.messages = new HashMap();
        this.incoming = new LinkedList();
        this.wnds = new ArrayList();
        new MsgManager();
    }

    public void sendMessage(String string, String string2, String string3) {
        ArrayList<EmailMessage> arrayList = (ArrayList<EmailMessage>)this.messages.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<EmailMessage>();
            this.messages.put(string, arrayList);
            InboxList inboxList = new InboxList(arrayList, string);
            this.wnds.add(inboxList);
            JFrame jFrame = new JFrame();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add(inboxList.getList());
            jFrame.setContentPane(jPanel);
            jFrame.setTitle(string);
            jFrame.setSize(200, 100);
            jFrame.setVisible(true);
        }
        arrayList.add(new EmailMessage(this.fromAddress, string2, new Date().toString(), string3));
        this.update();
    }

    private void update() {
        Iterator iterator = this.wnds.iterator();
        while (iterator.hasNext()) {
            InboxList inboxList = (InboxList)iterator.next();
            inboxList.update();
        }
    }

    public EmailMessage getOneNewMessage() {
        if (this.incoming.isEmpty()) {
            return null;
        }
        return (EmailMessage)this.incoming.removeFirst();
    }

    public ArrayList getNewMessages() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.incoming);
        this.incoming = new LinkedList();
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        EMailIOSwing eMailIOSwing = new EMailIOSwing("cmradar1+dabraham@cs.cmu.edu");
        eMailIOSwing.sendMessage("jluxenbe@cs.cmu.edu", "test", "did it work?");
        eMailIOSwing.sendMessage("jluxenbe@cs.cmu.edu", "test2", "did it work?");
        EmailMessage emailMessage = eMailIOSwing.getOneNewMessage();
        if (emailMessage != null) {
            System.out.println(emailMessage);
        }
        eMailIOSwing.sendMessage("jluxenbe@cs.cmu.edu", "test3", "did it work?");
        eMailIOSwing.sendMessage("jluxenbe2@cs.cmu.edu", "test3", "did it work?");
        eMailIOSwing.sendMessage("jluxenbe3@cs.cmu.edu", "test3", "did it work?");
        eMailIOSwing.sendMessage("jluxenbe4@cs.cmu.edu", "test3", "did it work?");
    }

    private class InboxList {
        private List msgs;
        private ArrayList src;
        private int last;
        private String fromAddress;

        public InboxList(ArrayList arrayList, String string) {
            this.src = arrayList;
            this.fromAddress = string;
            this.msgs = new List(1, false);
            this.msgs.addItemListener(new SelectListener());
        }

        public List getList() {
            return this.msgs;
        }

        public void update() {
            ListIterator listIterator = this.src.listIterator(this.last);
            while (listIterator.hasNext()) {
                ++this.last;
                EmailMessage emailMessage = (EmailMessage)listIterator.next();
                this.msgs.add(emailMessage.getSubject());
            }
        }

        private class SelectListener
        implements ItemListener {
            private SelectListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                int[] nArray = InboxList.this.msgs.getSelectedIndexes();
                if (nArray.length == 0) {
                    return;
                }
                new MessageWindow((EmailMessage)InboxList.this.src.get(nArray[0]), InboxList.this.fromAddress);
            }
        }
    }

    private class MessageWindow
    extends JFrame {
        private JTextArea body = new JTextArea(6, 30);
        private JPanel content;
        private JPanel buttons;
        private JPanel headers;
        private String to;
        private EmailMessage msg;
        private InboxList il;

        public MessageWindow(EmailMessage emailMessage, String string) {
            this.body.setText(emailMessage.getBody());
            JScrollPane jScrollPane = new JScrollPane(this.body);
            this.buttons = new JPanel();
            this.buttons.setLayout(new FlowLayout());
            JButton jButton = new JButton("Send");
            JButton jButton2 = new JButton("Done");
            jButton.addActionListener(new ReplyListener());
            this.buttons.add(jButton);
            this.buttons.add(jButton2);
            this.headers = new JPanel();
            this.headers.setLayout(new BoxLayout(this.headers, 1));
            this.headers.add(new LabeledTextCtrl("From", string));
            this.headers.add(new LabeledTextCtrl("Subject", emailMessage.getSubject()));
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add(jScrollPane);
            container.add((Component)this.buttons, "South");
            container.add((Component)this.headers, "North");
            this.pack();
            this.setTitle(emailMessage.getSubject());
            super.setVisible(true);
            this.msg = emailMessage;
            this.to = string;
        }

        private class ReplyListener
        implements ActionListener {
            private ReplyListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (MessageWindow.this.to.equals("")) {
                    MessageWindow.this.to = EMailIOSwing.this.fromAddress;
                }
                EmailMessage emailMessage = new EmailMessage(MessageWindow.this.to, MessageWindow.this.msg.getSubject(), new Date().toString(), MessageWindow.this.body.getText());
                System.out.println("*****SENDING MSG:  " + emailMessage);
                EMailIOSwing.this.incoming.addLast(emailMessage);
                if (EMailIOSwing.this.call != null) {
                    EMailIOSwing.this.call.gotMessages(EMailIOSwing.this.getNewMessages());
                }
            }
        }
    }

    private static class LabeledTextCtrl
    extends JPanel {
        private JLabel label;
        private JTextField text;

        public LabeledTextCtrl(String string, String string2) {
            this.label = new JLabel(string);
            this.text = new JTextField(string2, 20);
            this.add(this.label);
            this.add(this.text);
            this.setLayout(new FlowLayout());
        }

        public String getText() {
            return this.text.getText();
        }
    }

    private class MsgManager
    extends JFrame {
        public MsgManager() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            JButton jButton = new JButton("New Email");
            jButton.addActionListener(new NewMsgListener());
            jPanel.add(jButton);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add(jPanel);
            this.pack();
            this.setTitle("Message Console");
            this.setVisible(true);
        }

        private class NewMsgListener
        implements ActionListener {
            private NewMsgListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                new MessageWindow(new EmailMessage(EMailIOSwing.this.fromAddress, "", new Date().toString(), ""), "");
            }
        }
    }
}

