/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.demo;

import cmradar.manager.data.Meeting;
import cmradar.manager.demo.CalendarCell;
import cmradar.manager.demo.ImageRenderer;
import cmradar.manager.demo.Renderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class MeetingRenderer
implements Renderer {
    boolean isInMeetingListPanel = false;
    ImageRenderer imageRend = new ImageRenderer();
    private static Color[] colors = new Color[]{new Color(0.58f, 0.69f, 0.81f), new Color(1.0f, 1.0f, 0.6f), new Color(0.65f, 1.0f, 0.65f), new Color(1.0f, 0.65f, 0.65f)};

    private Color brighter_orig(Color color) {
        int n = (int)((double)color.getRed() * 1.3);
        int n2 = (int)((double)color.getGreen() * 1.3);
        int n3 = (int)((double)color.getBlue() * 1.3);
        return new Color(n <= 255 ? n : 255, n2 <= 255 ? n2 : 255, n3 <= 255 ? n3 : 255);
    }

    private Color brighter(Color color) {
        int n = (int)((double)color.getRed() * 0.7);
        int n2 = (int)((double)color.getGreen() * 0.7);
        int n3 = (int)((double)color.getBlue() * 0.7);
        return new Color(n <= 255 ? n : 255, n2 <= 255 ? n2 : 255, n3 <= 255 ? n3 : 255);
    }

    private Color highlight(Color color) {
        int n = (int)((double)color.getRed() * 0.7);
        int n2 = (int)((double)color.getGreen() * 0.7);
        int n3 = (int)((double)color.getBlue() * 0.7);
        return new Color(n <= 255 ? n : 255, n2 <= 255 ? n2 : 255, n3 <= 255 ? n3 : 255);
    }

    protected void drawCenteredText(Graphics2D graphics2D, String string, Rectangle rectangle) {
        Font font = graphics2D.getFont();
        Rectangle2D rectangle2D = font.getStringBounds(string, graphics2D.getFontRenderContext());
        graphics2D.drawString(string, (int)((rectangle.getWidth() - rectangle2D.getWidth()) / 2.0 + rectangle.getX()), (int)((rectangle.getHeight() - rectangle2D.getHeight()) / 2.0 + rectangle2D.getHeight() + rectangle.getY()));
    }

    public void drawLeftText(Graphics2D graphics2D, String string, Rectangle rectangle) {
        Font font = graphics2D.getFont();
        Rectangle2D rectangle2D = font.getStringBounds(string, graphics2D.getFontRenderContext());
        graphics2D.drawString(string, (int)(3.0 + rectangle.getX()), (int)((rectangle.getHeight() - rectangle2D.getHeight()) / 2.0 + rectangle2D.getHeight() + rectangle.getY()));
    }

    protected Color getBgColor(CalendarCell calendarCell, Meeting meeting) {
        Color color = null;
        if (meeting == null) {
            return Color.WHITE;
        }
        if (this.isInMeetingListPanel) {
            color = colors[0];
        } else {
            String string = meeting.getStatus();
            if (string == null) {
                color = Color.WHITE;
            } else if (string.equals("possible")) {
                color = colors[0];
            } else if (string.equals("pending")) {
                color = colors[1];
            } else if (string.equals("confirmed")) {
                color = colors[2];
            } else if (string.equals("bumped")) {
                color = colors[3];
            }
        }
        if (color == null) {
            color = Color.RED;
        }
        if (calendarCell.isHighlighted()) {
            color = this.highlight(color);
        }
        return color;
    }

    private int textWidth(Graphics2D graphics2D, Object object) {
        Font font = graphics2D.getFont().deriveFont(13.0f).deriveFont(1);
        Rectangle2D rectangle2D = font.getStringBounds(((CalendarCell)object).getCurMeeting().getMeetingId(), graphics2D.getFontRenderContext());
        return (int)rectangle2D.getWidth();
    }

    public int preferredWidth(Graphics2D graphics2D, Object object, int n, String string) {
        return this.textWidth(graphics2D, object) + 7;
    }

    public void render(Graphics2D graphics2D, Object object, Rectangle rectangle, String string) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        CalendarCell calendarCell = (CalendarCell)object;
        Meeting meeting = calendarCell.getCurMeeting();
        Meeting meeting2 = calendarCell.getBumpedMeeting();
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getY();
        graphics2D2.setFont(graphics2D2.getFont().deriveFont(13.0f).deriveFont(1));
        graphics2D2.setColor(this.brighter(this.getBgColor(calendarCell, meeting)));
        graphics2D2.fillRect(n + 1, n2 + 1, (int)rectangle.getWidth() - 1, (int)rectangle.getHeight() - 1);
        graphics2D2.setColor(this.getBgColor(calendarCell, meeting).darker());
        graphics2D2.fillRect(n + 2, n2 + 2, (int)rectangle.getWidth() - 3, (int)rectangle.getHeight() - 3);
        graphics2D2.setColor(this.getBgColor(calendarCell, meeting));
        graphics2D2.fillRect(n + 2, n2 + 2, (int)rectangle.getWidth() - 4, (int)rectangle.getHeight() - 4);
        graphics2D2.setColor(Color.BLACK);
        if (meeting != null && meeting2 != null) {
            int n3 = (int)rectangle.getWidth() / 2;
            graphics2D2.setColor(this.brighter(this.getBgColor(calendarCell, meeting2)));
            graphics2D2.fillRect(n3 + n, n2 + 1, (int)rectangle.getWidth() - n3, (int)rectangle.getHeight() - 1);
            graphics2D2.setColor(this.getBgColor(calendarCell, meeting2).darker());
            graphics2D2.fillRect(n3 + n, n2 + 2, (int)rectangle.getWidth() - 1 - n3, (int)rectangle.getHeight() - 3);
            graphics2D2.setColor(this.getBgColor(calendarCell, meeting2));
            graphics2D2.fillRect(n3 + n, n2 + 2, (int)rectangle.getWidth() - 2 - n3, (int)rectangle.getHeight() - 4);
            graphics2D2.setColor(Color.BLACK);
            this.drawLeftText(graphics2D2, meeting.getMeetingId(), new Rectangle(n, n2, n3, (int)rectangle.getHeight() - 1));
            this.drawLeftText(graphics2D2, meeting2.getMeetingId(), new Rectangle(n3 + n, n2, (int)rectangle.getWidth() - 1 - n3, (int)rectangle.getHeight() - 1));
        } else if (meeting != null) {
            this.drawLeftText(graphics2D2, meeting.getMeetingId(), new Rectangle(n, n2, (int)rectangle.getWidth() - 1, (int)rectangle.getHeight() - 1));
        }
        graphics2D2.setColor(Color.DARK_GRAY);
        graphics2D2.drawRect(n, n2, (int)rectangle.getWidth() - 1, (int)rectangle.getHeight() - 1);
        graphics2D2.dispose();
    }
}

