/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeTimeIntervals;
import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JComponent;

public class TimeAvailabilityEditor
extends JComponent {
    private static final long serialVersionUID = 0L;
    private SpaceTimeTimeIntervals _intervals;
    private GregorianCalendar _calendar = new GregorianCalendar();
    private Date _start;
    private Date _end;
    private int _startHour;
    private int _stopHour;
    private List<List<Interval>> _dayIntervals;
    private static final int HPADDING = 0;
    private static final int TOPPADDING = 20;
    private static final int BOTTOMPADDING = 10;
    private static final int BARWIDTH = 20;
    private static final int LABELWIDTH = 60;
    private static final int TITLEHEIGHT = 40;
    private static final int HOURINCREMENT = 4;

    public TimeAvailabilityEditor(Date start, Date end) {
        this._start = start;
        this._end = end;
        this._dayIntervals = new ArrayList<List<Interval>>();
        this._calendar.setTime(this._start);
        this._startHour = this._calendar.get(11);
        this._calendar.setTime(this._end);
        this._stopHour = this._calendar.get(11);
        this._calendar.setTime(this._start);
        Date dateCursor = this._calendar.getTime();
        while (this._end.after(dateCursor)) {
            this._dayIntervals.add(new ArrayList());
            this._calendar.add(6, 1);
            dateCursor = this._calendar.getTime();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = SwingHelper.prepareGraphics(g);
        int height = this.getHeight();
        int hourIncrementHeight = (height - 20 - 10 - 40) / (4 * (this._stopHour - this._startHour));
        int dayHeight = hourIncrementHeight * (this._stopHour - this._startHour) * 4;
        Font timeFontLarge = this.getFont().deriveFont(0, 16.0f);
        Font timeFontSmall = this.getFont().deriveFont(0, 10.0f);
        Font labelFont = this.getFont().deriveFont(0, 10.0f);
        FontMetrics fontMetrics = g2.getFontMetrics(timeFontLarge);
        FontMetrics fontMetricsLabel = g2.getFontMetrics(labelFont);
        Color shadedColor = new Color(220, 220, 220);
        this._calendar.setTime(this._start);
        int cursor = 0;
        for (List<Interval> intervalCollection : this._dayIntervals) {
            SpaceTimeDate spaceTimeDate = new SpaceTimeDate(this._calendar.getTime());
            String dayLabel = spaceTimeDate.toString("E");
            String dateLabel = spaceTimeDate.toString("MMM, dd, yyyy");
            g2.setFont(labelFont);
            g2.drawString(dayLabel, cursor + 60 - fontMetricsLabel.stringWidth(dayLabel) / 2, 30);
            g2.drawString(dateLabel, cursor + 60 - fontMetricsLabel.stringWidth(dateLabel) / 2, 42);
            g2.setColor(shadedColor);
            g2.fillRect(cursor + 60, 60, 20, dayHeight);
            for (Interval interval : intervalCollection) {
                int startPos = this.getPosFromTime(interval.startHour, interval.startIncrement);
                int stopPos = this.getPosFromTime(interval.stopHour, interval.stopIncrement);
                g2.setColor(Color.white);
                g2.fillRect(cursor + 60, startPos, 20, stopPos - startPos);
            }
            int j = 0;
            while (j <= this._stopHour - this._startHour) {
                g2.setFont(timeFontLarge);
                g2.setColor(Color.black);
                String hourString = Integer.toString((j + this._startHour - 1) % 12 + 1);
                String ampmString = this._startHour + j < 12 || this._startHour + j == 24 ? "am" : "pm";
                int hourStringWidth = fontMetrics.stringWidth(hourString);
                int vPos = 60 + j * hourIncrementHeight * 4;
                g2.drawString(hourString, cursor + 60 - hourStringWidth - 18, vPos + 7);
                g2.setFont(timeFontSmall);
                g2.drawString("00", cursor + 60 - 16, vPos + 1);
                g2.setColor(Color.darkGray);
                g2.drawString(ampmString, cursor + 60 - 17, vPos + 8);
                ++j;
            }
            j = 0;
            while (j < this._stopHour - this._startHour) {
                int vPos = 60 + j * hourIncrementHeight * 4;
                g2.setColor(Color.gray);
                g2.drawLine(cursor + 60, vPos, cursor + 60 + 20, vPos);
                int k = 1;
                while (k < 4) {
                    g2.setColor(Color.lightGray);
                    g2.drawLine(cursor + 60, vPos + k * hourIncrementHeight, cursor + 60 + 20, vPos + k * hourIncrementHeight);
                    ++k;
                }
                ++j;
            }
            g2.setColor(Color.darkGray);
            g2.drawRect(cursor += 60, 60, 20, dayHeight);
            cursor += 20;
            this._calendar.add(6, 1);
        }
    }

    private int getPosFromTime(int hour, int increment) {
        int hourIncrementHeight = (this.getHeight() - 20 - 10 - 40) / (4 * (this._stopHour - this._startHour));
        return 60 + (hour - this._startHour) * 4 * hourIncrementHeight + increment * hourIncrementHeight;
    }

    public void setAvailability(SpaceTimeTimeIntervals intervals) {
        this._intervals = new SpaceTimeTimeIntervals(intervals);
        GregorianCalendar localCalendar = new GregorianCalendar();
        GregorianCalendar localCalendar2 = new GregorianCalendar();
        for (SpaceTimeTimeIntervals.Interval interval : this._intervals) {
            localCalendar.setTime(interval._start);
            int intervalDay = localCalendar.get(6);
            this._calendar.setTime(this._start);
            for (List<Interval> intervalCollection : this._dayIntervals) {
                int localDay = this._calendar.get(6);
                if (localDay == intervalDay) {
                    localCalendar2.setTime(interval._start);
                    int startHour = localCalendar2.get(11);
                    int startIncrement = localCalendar2.get(12) * 4 / 60;
                    localCalendar2.setTime(interval._stop);
                    int stopHour = localCalendar2.get(11);
                    int stopIncrement = localCalendar2.get(12) * 4 / 60;
                    intervalCollection.add(new Interval(startHour, startIncrement, stopHour, stopIncrement));
                }
                this._calendar.add(6, 1);
            }
        }
    }

    public SpaceTimeTimeIntervals getAvailability() {
        return this._intervals;
    }

    public static class Interval {
        public int startHour;
        public int startIncrement;
        public int stopHour;
        public int stopIncrement;

        public Interval(int startHour, int startIncrement, int stopHour, int stopIncrement) {
            this.startHour = startHour;
            this.startIncrement = startIncrement;
            this.stopHour = stopHour;
            this.stopIncrement = stopIncrement;
        }
    }
}

