/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.RequestListModel;
import edu.cmu.cs.radar.rhai.spacetime.SelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SelectionState
implements SelectionListener {
    private SelectionManager _selectionManager;
    private RequestListModel _requestList;
    private State _state;

    public SelectionState(SelectionManager selectionManager, RequestListModel requestList) {
        this._selectionManager = selectionManager;
        this._requestList = requestList;
        this._state = new State();
        this._selectionManager.addListener(this);
        this._requestList.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                SelectionState.this.broadcastSelectionState();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                SelectionState.this.broadcastSelectionState();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                SelectionState.this.broadcastSelectionState();
            }
        });
    }

    public void clear() {
        this._state = new State();
    }

    @Override
    public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
        this._state._lastTypeSelected = type;
        switch (type) {
            case 1: {
                this._state._lastSelectedEventId = selected ? selection.toString() : null;
                break;
            }
            case 2: {
                this._state._lastSelectedRoomId = selected ? selection.toString() : null;
            }
        }
    }

    @Override
    public void setViewState(Object sender, Object selection, boolean show) {
    }

    public void broadcastSelectionState() {
        State oldState = this._state;
        this._state = new State();
        switch (oldState._lastTypeSelected) {
            case 0: {
                this._selectionManager.notifySelection(this, null, 2, false, true, false);
                this._selectionManager.notifySelection(this, null, 1, false, true, false);
                break;
            }
            case 1: {
                this.broadcastLastSelectedRoom(oldState);
                this.broadcastLastSelectedEvent(oldState);
                break;
            }
            case 2: {
                this.broadcastLastSelectedEvent(oldState);
                this.broadcastLastSelectedRoom(oldState);
            }
        }
    }

    private void broadcastLastSelectedRoom(State state) {
        if (state._lastSelectedRoomId != null) {
            for (SpaceTimeNode room : this._requestList.getDataAdapter().getRooms()) {
                if (!state._lastSelectedRoomId.equals(room.getName())) continue;
                this._selectionManager.notifySelection(this, room.getName(), 2, true, true, false);
                return;
            }
        }
        this._selectionManager.notifySelection(this, null, 2, false, true, false);
    }

    private void broadcastLastSelectedEvent(State state) {
        if (state._lastSelectedEventId != null) {
            for (SpaceTimeNode request : this._requestList.getDataAdapter().getRequests()) {
                if (!state._lastSelectedEventId.equals(request.getName())) continue;
                this._selectionManager.notifySelection(this, request.getName(), 1, true, true, false);
                return;
            }
        }
        this._selectionManager.notifySelection(this, null, 1, false, true, false);
    }

    private class State {
        private int _lastTypeSelected = 0;
        private String _lastSelectedRoomId = null;
        private String _lastSelectedEventId = null;
    }
}

