/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.Allocation;
import edu.cmu.cs.radar.rhai.spacetime.GenericRequestDragComponent;
import edu.cmu.cs.radar.rhai.spacetime.ItemDetailsList;
import edu.cmu.cs.radar.rhai.spacetime.LinearFunctionChart;
import edu.cmu.cs.radar.rhai.spacetime.ScoreChart;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDuration;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeItemList;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.LinearFunctionData;
import edu.cmu.cs.radar.stp.cachingdatamodel.NodeChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeEdge;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import edu.cmu.cs.radar.stp.cachingdatamodel.UncertaintyDistributionData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class RequestDetailsListItem
extends ItemDetailsList.Item
implements GenericRequestDragComponent.DrawListener {
    private static ImageIcon LOCK_ICON;
    private static ImageIcon ALERT_ICON;
    private static ImageIcon PENDING_ICON;
    private String _category;
    private SpaceTimeItemList _owner;
    private SpaceTimeNode _node;
    private SpaceTimeRequestNode _requestNode;
    private List<DetailsRegion> _regions;
    private ListNodeListener _listener;
    private int _detailsHeight;
    private boolean _showScores;
    private boolean _showGraphs;
    private boolean _debug;
    private DetailsRegion _scoreRegion;
    private boolean _suppressSelfSelection;
    private static final String CATEGORY_UNSCHEDULED = "Unscheduled";
    private static final String CATEGORY_SCHEDULED = "Scheduled";
    private static final int LABEL_HEIGHT = 18;
    private static final int REGION_SPACER = 4;
    private static final int REGION_INDENT = 10;
    private static final int ICON_OFFSET = 15;
    private static final int SCORE_OFFSET = 10;

    static {
        ClassLoader classLoader = RequestDetailsListItem.class.getClassLoader();
        LOCK_ICON = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/lock.png"));
        ALERT_ICON = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/alert.png"));
        PENDING_ICON = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/pending.png"));
    }

    public RequestDetailsListItem(SpaceTimeItemList owner, SpaceTimeNode node) {
        super(RequestDetailsListItem.GetDisplayName(node));
        this._owner = owner;
        this._regions = new ArrayList<DetailsRegion>();
        this._node = node;
        this._requestNode = new SpaceTimeRequestNode(node);
        this._category = CATEGORY_UNSCHEDULED;
        this._suppressSelfSelection = false;
        this._showScores = false;
        this._showGraphs = false;
        this._debug = false;
        this._listener = new ListNodeListener(this);
        this._node.addChangeListener(this._listener);
        if (this._requestNode.isAssigned() && !this._requestNode.isRejected()) {
            this._category = CATEGORY_SCHEDULED;
        } else if (this._requestNode.isRejected()) {
            this._category = CATEGORY_UNSCHEDULED;
        }
    }

    @Override
    protected synchronized void setSelected(boolean selected, boolean autoScroll) {
        super.setSelected(selected, autoScroll);
        this._regions.clear();
        this.createRegions();
    }

    private static String GetDisplayName(SpaceTimeNode node) {
        try {
            return node.getDisplayName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void dispose() {
        this._node.removeChangeListener(this._listener);
    }

    @Override
    public Object getObject() {
        return this._node;
    }

    @Override
    public String getObjectId() {
        return this._node.getName();
    }

    public SpaceTimeNode getNode() {
        return this._node;
    }

    public SpaceTimeRequestNode getRequestNode() {
        return this._requestNode;
    }

    public synchronized void setDebug(boolean debug) {
        this._debug = debug;
        this._regions.clear();
    }

    public synchronized void showScores(boolean show) {
        if (this._showScores == show) {
            return;
        }
        if (this._showScores) {
            this._regions.remove(this._scoreRegion);
            this._scoreRegion = null;
        } else {
            this._scoreRegion = new ScoreListRegion(this._node);
            this._regions.add(0, this._scoreRegion);
        }
        this._showScores = show;
    }

    public synchronized void showGraphs(boolean show) {
        if (this._showGraphs == show) {
            return;
        }
        this._showGraphs = show;
        this._regions.clear();
    }

    @Override
    public String getCategory() {
        return this._category;
    }

    @Override
    public int getHeight() {
        return 18;
    }

    @Override
    public int getDetailsHeight() {
        return this._detailsHeight;
    }

    @Override
    protected Component getDragComponent(int width) {
        GenericRequestDragComponent dragComponent = new GenericRequestDragComponent(this._requestNode, this.getOwner());
        dragComponent.setDrawListener(this);
        return dragComponent;
    }

    @Override
    public void draw(Graphics g, Dimension size) {
        this.drawSelected(g, size.width, false);
    }

    private void drawIcon(Graphics g) {
        double currentScore = this._node.getScore();
        if (currentScore <= -6.0) {
            ImageIcon icon = currentScore == -6.0 ? ALERT_ICON : PENDING_ICON;
            g.drawImage(icon.getImage(), 9, 5, null);
        }
    }

    @Override
    protected void draw(Graphics g, int width) {
        Graphics2D g2 = (Graphics2D)g;
        int offset = 15;
        if (this._showScores) {
            this.drawIcon(g);
            offset += 10;
        }
        g.setColor(Color.black);
        g.drawString(this.getName(), offset, 15);
        int nameWidth = g2.getFontMetrics().stringWidth(this.getName());
        offset += nameWidth + 4;
        if (this._requestNode.isLockedToRoom()) {
            g2.drawImage(LOCK_ICON.getImage(), offset, 5, null);
        }
    }

    @Override
    protected void drawSelected(Graphics g, int width, boolean background) {
        Graphics2D g2 = (Graphics2D)g;
        int offset = 15;
        if (this._showScores) {
            this.drawIcon(g);
            offset += 10;
        }
        int nameWidth = g2.getFontMetrics().stringWidth(this.getName());
        if (this._requestNode.isLockedToRoom()) {
            nameWidth += 14;
        }
        if (!background) {
            g2.setColor(new Color(55, 104, 197));
            g2.fillRect(offset - 2, 4, nameWidth + 4, 14);
            g2.setColor(Color.white);
            g2.drawString(this.getName(), offset, 15);
            if (this._requestNode.isLockedToRoom()) {
                g2.drawImage(LOCK_ICON.getImage(), offset + nameWidth - 10, 5, null);
            }
        } else {
            g2.setColor(Color.black);
            g2.drawString(this.getName(), offset, 15);
            if (this._requestNode.isLockedToRoom()) {
                g2.drawImage(LOCK_ICON.getImage(), offset + nameWidth - 10, 5, null);
            }
            g2.setColor(Color.darkGray);
            Rectangle2D.Double rect = new Rectangle2D.Double(offset - 2, 4.0, nameWidth + 4, 13.0);
            BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{2.0f}, 0.0f);
            g2.setStroke(stroke);
            g2.draw(rect);
        }
    }

    private static String getImportanceString(SpaceTimeRequestNode requestNode) {
        int importance = requestNode.getImportance();
        if (importance >= 150) {
            return "Very high";
        }
        if (importance >= 75) {
            return "High";
        }
        if (importance >= 10) {
            return "Medium";
        }
        if (importance >= 5) {
            return "Low";
        }
        return "Very low";
    }

    @Override
    protected synchronized void drawDetails(Graphics g, int width) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(g2.getFont().deriveFont(0, 11.0f));
        int offset = 0;
        for (DetailsRegion region : this._regions) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(220, 220, 230), width, 0.0f, new Color(255, 255, 255)));
            g2.fillRect(4, offset + 18 - 10, width - 8, 12);
            g2.setColor(Color.black);
            g2.drawString(region.getTitle(), 6, offset + 18);
            Graphics subGraphics = g.create(10, offset += 22, width - 10, region.getHeight());
            region.draw(subGraphics, width - 20);
            subGraphics.dispose();
            offset += region.getHeight() + 4;
        }
    }

    @Override
    protected void addComponents() {
    }

    @Override
    public synchronized void update() {
        if (this._regions.size() == 0) {
            this.createRegions();
        }
        for (DetailsRegion region : this._regions) {
            region.update();
        }
    }

    public void nodeSelected(boolean selected) {
        if (selected && !this._suppressSelfSelection) {
            this.setSelected(selected, true);
        }
    }

    private synchronized void createRegions() {
        int currentHeight = 0;
        if (this._requestNode.isAssigned() && !this._requestNode.isRejected()) {
            this._category = CATEGORY_SCHEDULED;
        } else if (this._requestNode.isRejected()) {
            this._category = CATEGORY_UNSCHEDULED;
        }
        if (this._debug) {
            this._scoreRegion = new ScoreListRegion(this._node);
            if (this._showScores) {
                this._regions.add(this._scoreRegion);
            }
            currentHeight += this._scoreRegion.getHeight() + 18 + 8;
            ImportanceListRegion importanceRegion = new ImportanceListRegion(this._requestNode);
            this._regions.add(importanceRegion);
            currentHeight += importanceRegion.getHeight() + 18 + 8;
            String comments = this._requestNode.getDescription();
            if (comments.length() > 0) {
                CommentsListRegion commentsRegion = new CommentsListRegion(this._requestNode);
                this._regions.add(commentsRegion);
                currentHeight += commentsRegion.getHeight() + 18 + 8;
            }
            RequestorListRegion requestorRegion = new RequestorListRegion(this._requestNode);
            this._regions.add(requestorRegion);
            currentHeight += requestorRegion.getHeight() + 18 + 8;
        }
        try {
            for (String propertyName : this._node.getPropertyNames()) {
                SpaceTimeProperty property = this._node.getProperty(propertyName);
                if (property.isDisplayed()) continue;
                float weight = this._requestNode.getWeight(propertyName);
                if (this._requestNode.isAssociated(propertyName) && weight == 0.0f) continue;
                LinearFunctionData functionData = property.getFunctionData();
                if (functionData != null) {
                    if (!this._showGraphs) continue;
                    LinearFunctionChart chartControl = new LinearFunctionChart(functionData);
                    switch (property.getDataType()) {
                        case 4: {
                            chartControl.setUnit(1);
                            break;
                        }
                        case 5: {
                            chartControl.setUnit(2);
                        }
                    }
                    FunctionListRegion region = new FunctionListRegion(this._requestNode, property, chartControl);
                    this._regions.add(region);
                    currentHeight += region.getHeight() + 18 + 8;
                    continue;
                }
                NumericListRegion region = new NumericListRegion(property);
                this._regions.add(region);
                currentHeight += region.getHeight() + 18 + 8;
            }
            for (SpaceTimeEdge edge : this._node.getEdges()) {
                LinearFunctionData functionData;
                SpaceTimeProperty weightProperty = edge.getProperty("edgeWeight");
                SpaceTimeProperty prefProperty = edge.getProperty("edgePref");
                if (prefProperty == null || weightProperty == null) continue;
                String weight = "" + weightProperty.getIntValue();
                if (weightProperty.getUncertaintyData() != null) {
                    weight = weightProperty.getUncertaintyData().getMin() + "-" + weightProperty.getUncertaintyData().getMax();
                }
                if ((functionData = prefProperty.getFunctionData()) == null || !this._showGraphs) continue;
                LinearFunctionChart chartControl = new LinearFunctionChart(functionData);
                switch (prefProperty.getDataType()) {
                    case 4: {
                        chartControl.setUnit(1);
                        break;
                    }
                    case 5: {
                        chartControl.setUnit(2);
                    }
                }
                String title = "Preference to " + edge.getTarget() + " (type " + edge.getType() + ", weight " + weight + ")";
                FunctionListRegion region = new FunctionListRegion(this._requestNode, prefProperty, chartControl, title);
                this._regions.add(region);
                currentHeight += region.getHeight() + 18 + 8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._detailsHeight = currentHeight + 4;
    }

    private static class CommentsListRegion
    extends DetailsRegion {
        private SpaceTimeRequestNode _requestNode;

        public CommentsListRegion(SpaceTimeRequestNode requestNode) {
            this._requestNode = requestNode;
        }

        @Override
        public String getTitle() {
            return "Comments";
        }

        @Override
        public void draw(Graphics g, int width) {
            g.drawString(this._requestNode.getDescription(), 0, 12);
        }
    }

    private static abstract class DetailsRegion {
        public void update() {
        }

        public int getHeight() {
            return 15;
        }

        public String getTitle() {
            return "";
        }

        public abstract void draw(Graphics var1, int var2);
    }

    private static class FunctionListRegion
    extends DetailsRegion {
        private SpaceTimeRequestNode _requestNode;
        private LinearFunctionChart _chart;
        private SpaceTimeProperty _property;
        private String _title;

        public FunctionListRegion(SpaceTimeRequestNode requestNode, SpaceTimeProperty property, LinearFunctionChart chart) {
            this._property = property;
            this._requestNode = requestNode;
            this._chart = chart;
            String weight = this._requestNode.getWeightString(this._property.getPropertyType());
            String propertyLabel = this._property.getLabel();
            this._title = String.valueOf(propertyLabel != null ? propertyLabel : this._property.getPropertyType()) + " (weight " + weight + ")";
        }

        public FunctionListRegion(SpaceTimeRequestNode requestNode, SpaceTimeProperty property, LinearFunctionChart chart, String title) {
            this._property = property;
            this._requestNode = requestNode;
            this._chart = chart;
            this._title = title;
        }

        @Override
        public void update() {
            switch (this._property.getDataType()) {
                case 4: {
                    SpaceTimeDate startTime = this._requestNode.getStart();
                    if (startTime == null) {
                        this._chart.enableCurrentValue(false);
                        break;
                    }
                    this._chart.setCurrentValue(startTime.getOptDate());
                    break;
                }
                case 5: {
                    SpaceTimeDuration duration = this._requestNode.getDuration();
                    long optDuration = duration != null ? duration.getOptDuration() : 0L;
                    this._chart.setCurrentValue(optDuration);
                    break;
                }
                default: {
                    SpaceTimeProperty assocProperty;
                    SpaceTimeNode roomNode;
                    String roomName;
                    Allocation allocation;
                    String assocPropertyName = this._requestNode.getNode().getAdapter().getAssociatedPropertyName(this._property.getPropertyType());
                    if (assocPropertyName == null || (allocation = this._requestNode.getAllocation()) == null || (roomName = allocation.getRoom()) == null || (roomNode = this._requestNode.getNode().getAdapter().getNodeById(roomName)) == null || (assocProperty = roomNode.getProperty(assocPropertyName)) == null) break;
                    UncertaintyDistributionData uncertaintyData = assocProperty.getUncertaintyData();
                    if (uncertaintyData != null) {
                        this._chart.setCurrentValue(uncertaintyData.getAverage());
                        break;
                    }
                    this._chart.setCurrentValue(assocProperty.getIntValue());
                }
            }
        }

        @Override
        public int getHeight() {
            return this._chart.getHeight();
        }

        @Override
        public String getTitle() {
            return this._title;
        }

        @Override
        public void draw(Graphics g, int width) {
            this._chart.setSize(width, this._chart.getHeight());
            this._chart.paint(g);
        }
    }

    private static class ImportanceListRegion
    extends DetailsRegion {
        private SpaceTimeRequestNode _requestNode;

        public ImportanceListRegion(SpaceTimeRequestNode requestNode) {
            this._requestNode = requestNode;
        }

        @Override
        public String getTitle() {
            return "Importance";
        }

        @Override
        public void draw(Graphics g, int width) {
            g.drawString(String.valueOf(RequestDetailsListItem.getImportanceString(this._requestNode)) + " (" + this._requestNode.getImportanceString() + ")", 0, 12);
        }
    }

    private static class ListNodeListener
    implements NodeChangeListener {
        private RequestDetailsListItem _listItem;

        public ListNodeListener(RequestDetailsListItem listItem) {
            this._listItem = listItem;
        }

        @Override
        public void nodeChanged(String nodeId, NodeChangeSummary changes) {
            String changedCategory = null;
            if (this._listItem._requestNode.isAssigned() && !"grass".equals(this._listItem._requestNode.getRoom())) {
                changedCategory = this._listItem._category;
                this._listItem._category = RequestDetailsListItem.CATEGORY_SCHEDULED;
            } else {
                changedCategory = this._listItem._category;
                this._listItem._category = RequestDetailsListItem.CATEGORY_UNSCHEDULED;
            }
            if (changedCategory != null) {
                this._listItem.notifyCategoryChange(changedCategory);
            } else {
                this._listItem.notifyChange();
            }
            if (this._listItem._owner.getSelectedItem() == this._listItem) {
                this._listItem.update();
                this._listItem._owner.updateItem(this._listItem);
            }
        }
    }

    private static class NumericListRegion
    extends DetailsRegion {
        private SpaceTimeProperty _property;

        public NumericListRegion(SpaceTimeProperty property) {
            this._property = property;
        }

        @Override
        public String getTitle() {
            return this._property.getLabel() != null ? this._property.getLabel() : this._property.getPropertyType();
        }

        @Override
        public void draw(Graphics g, int width) {
            UncertaintyDistributionData uncertaintyData = this._property.getUncertaintyData();
            String valueString = "";
            valueString = uncertaintyData != null ? uncertaintyData.getRangeString() : this._property.getStringValue();
            g.drawString(valueString, 0, 12);
        }
    }

    private static class RequestorListRegion
    extends DetailsRegion {
        private SpaceTimeRequestNode _requestNode;

        public RequestorListRegion(SpaceTimeRequestNode requestNode) {
            this._requestNode = requestNode;
        }

        @Override
        public String getTitle() {
            return "Requestor";
        }

        @Override
        public void draw(Graphics g, int width) {
            SpaceTimeNode requestorNode = this._requestNode.getRequestor();
            if (requestorNode == null) {
                g.drawString("None", 20, 12);
            } else {
                String weightString = this._requestNode.getRequestorWeightString();
                g.drawString(String.valueOf(requestorNode.getDisplayName()) + " (weight " + weightString + ")", 0, 12);
            }
        }
    }

    private static class ScoreListRegion
    extends DetailsRegion {
        private SpaceTimeNode _node;
        private ScoreChart _scoreChart;

        public ScoreListRegion(SpaceTimeNode node) {
            this._node = node;
            this._scoreChart = new ScoreChart(this._node);
        }

        @Override
        public String getTitle() {
            return "Score";
        }

        @Override
        public int getHeight() {
            return this._scoreChart.getHeight();
        }

        @Override
        public void draw(Graphics g, int width) {
            this._scoreChart.setSize(width, this._scoreChart.getHeight());
            this._scoreChart.paint(g);
        }
    }
}

