/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.CalendarObject;
import edu.cmu.cs.radar.rhai.calendar.CalendarObjectCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AbstractCalendarObjectCollection
implements CalendarObjectCollection,
CalendarObjectCollection.Listener {
    protected Set<CalendarObject> mCalendarObjects = new HashSet<CalendarObject>();
    protected List<CalendarObjectCollection.Listener> mCalendarObjectCollectionListeners = new ArrayList<CalendarObjectCollection.Listener>();
    protected CalendarObjectCollection mSource = null;

    protected AbstractCalendarObjectCollection() {
    }

    public void connectToSource(CalendarObjectCollection source) {
        if (this.mSource != null) {
            throw new IllegalStateException("already connected to a source");
        }
        if (source == null) {
            throw new NullPointerException("argument 'source'");
        }
        this.mSource = source;
        this.mSource.addCalendarObjectCollectionListener(this);
    }

    protected void addCalendarObject(CalendarObject calObj) {
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (this.mCalendarObjects.contains(calObj)) {
            throw new IllegalArgumentException("CalendarObject (" + calObj.getID() + ") already contained");
        }
        this.mCalendarObjects.add(calObj);
        this.fireCalendarObjectAdded(calObj);
    }

    protected synchronized void checkCalendarObject(CalendarObject calObj) {
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        this.fireCalendarObjectChanged(calObj);
    }

    protected synchronized void removeCalendarObject(CalendarObject calObj) {
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (!this.mCalendarObjects.contains(calObj)) {
            throw new IllegalArgumentException("CalendarObject (" + calObj.getID() + ") not contained");
        }
        this.mCalendarObjects.remove(calObj);
        this.fireCalendarObjectRemoved(calObj);
    }

    @Override
    public void calendarObjectAdded(AbstractCalendarObjectCollection source, CalendarObject calObj) {
        if (source == null) {
            throw new NullPointerException("argument 'source'");
        }
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (this.mSource != source) {
            throw new IllegalArgumentException("not connected to 'source' (" + source + ")");
        }
        this.addCalendarObject(calObj);
    }

    @Override
    public void calendarObjectChanged(AbstractCalendarObjectCollection source, CalendarObject calObj) {
        if (source == null) {
            throw new NullPointerException("argument 'source'");
        }
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (this.mSource != source) {
            throw new IllegalArgumentException("not connected to 'source' (" + source + ")");
        }
        this.checkCalendarObject(calObj);
    }

    @Override
    public void calendarObjectRemoved(AbstractCalendarObjectCollection source, CalendarObject calObj) {
        if (source == null) {
            throw new NullPointerException("argument 'source'");
        }
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        if (this.mSource != source) {
            throw new IllegalArgumentException("not connected to 'source' (" + source + ")");
        }
        this.removeCalendarObject(calObj);
    }

    @Override
    public synchronized void addCalendarObjectCollectionListener(CalendarObjectCollection.Listener listener) {
        this.mCalendarObjectCollectionListeners.add(listener);
        for (CalendarObject calObj : this.mCalendarObjects) {
            listener.calendarObjectAdded(this, calObj);
        }
    }

    @Override
    public synchronized void removeCalendarObjectCollectionListener(CalendarObjectCollection.Listener listener) {
        for (CalendarObject calObj : this.mCalendarObjects) {
            listener.calendarObjectRemoved(this, calObj);
        }
        this.mCalendarObjectCollectionListeners.remove(listener);
    }

    protected synchronized void fireCalendarObjectAdded(CalendarObject calObj) {
        ArrayList<CalendarObjectCollection.Listener> listeners = new ArrayList<CalendarObjectCollection.Listener>(this.mCalendarObjectCollectionListeners);
        for (CalendarObjectCollection.Listener listener : listeners) {
            listener.calendarObjectAdded(this, calObj);
        }
    }

    protected synchronized void fireCalendarObjectChanged(CalendarObject calObj) {
        ArrayList<CalendarObjectCollection.Listener> listeners = new ArrayList<CalendarObjectCollection.Listener>(this.mCalendarObjectCollectionListeners);
        for (CalendarObjectCollection.Listener listener : listeners) {
            listener.calendarObjectChanged(this, calObj);
        }
    }

    protected synchronized void fireCalendarObjectRemoved(CalendarObject calObj) {
        ArrayList<CalendarObjectCollection.Listener> listeners = new ArrayList<CalendarObjectCollection.Listener>(this.mCalendarObjectCollectionListeners);
        for (CalendarObjectCollection.Listener listener : listeners) {
            listener.calendarObjectRemoved(this, calObj);
        }
    }
}

