#!/usr/bin/python
# jeanoh 2007
# shared calendar generator for test 
#
#  Usage: python testgen.py <fileprefix> 
#  OUT: x.sharedroomcalendar, x.meetings
#
# ** "cmradar.properties" must be in the classpath **
# ** You'll probably want to change the classpath! **

import sys
import os


# EDIT --------------- START
JAVA = "c:/j2sdk1.4.2_13/bin/java"
CMRADAR_HOME = "c:/cmradar"
classpath = "c:/\;c:/cmradar/lib\;" + CMRADAR_HOME + "/lib/log4j-1.2.13.jar\;"+CMRADAR_HOME + "/lib/rusers.jar\;"+CMRADAR_HOME + "/lib/cmradar031707.jar"
# EDIT --------------- END

if len(sys.argv) < 2:
	print "USAGE: TRAINCNT [0:both 1:dataonly 2:testonly 3:[configonly prefix] 4:testset(fixdensity)]"
	sys.exit(0)

outfile = 'cmradar-learned' # <<<<<<<<<<< output filename 
user_name = "Randal"        # <<<<<<<<<<< the owner of the log file


###########################################################################################
# ------------------------
# Test example generation
# ------------------------
# IN: cmradar.properties file: (filenames should *not* have extentions)
#   cmradar.agents: .agents file
#   cmradar.rooms: .rooms file 
#   cmradar.pref: external user preference file (hidden room users) **NEW**
#                 row format: [userID set-of-roomIDs-sorted-by-preference] 
#   cmradar.visibility: what proportion of rooms should be queied per training example **NEW**
#
# -c: generate local + external shared room calendar in one set of file (.meetings, .sharedroomcalendar)
# -f: external user preference file 
# tsz: number of examples to generate=0 << 0 indicates 1 set of calendar
# -o: output file x.sharedroomcalendar x.meetings
#
# OUT: << x.sharedroomcalendar, x.meetings >>
############################################################################################

train_count = int(sys.argv[1]) ## number of training iterations

# densityOp -d: randomize density for external rooms (wargaming)
# nothing if fixed density in .properties file is used (testset generation)
def generateDataSet(fp, train_count, densityOp):
	for x in range(train_count):		
		xs = fp + str(x)
		print "Generating data set: " + xs
		os.system(JAVA + " -classpath " + classpath + " cmradar.manager.sim.HotelCalendarGenerator -c -tsz 0 -config cmradar.properties -o " + xs + " " + densityOp)
		#print (JAVA + " -classpath " + classpath + " cmradar.manager.sim.HotelCalendarGenerator -c -tsz 0 -config cmradar.properties -o " + xs)
		#os.system(JAVA + " cmradar.manager.sim.HotelCalendarGenerator -c -tsz 0 " + densityOp + " -o " + xs);
		os.system('echo "cmradar.sharedcal=' + xs + '" > tmp | cat cmradar.properties.base tmp > ' + xs + '.properties')

def scheduleDataSet(classpath, fp, vp, test_count):
  for x in range(test_count):
    xs = vp + str(x)
    os.system(JAVA + " " + "-classpath " + classpath +
        " cmradar.manager.sim.RSimulator -rsched " +
        xs + ".properties " +
        xs + ".requests")

def genConfigFiles(vp, test_count):
	for x in range(test_count):
	    xs = vp + str(x)
	    os.system('echo "cmradar.sharedcal=' + xs + '" > tmp | cat cmradar.properties.base tmp > ' + xs + '.properties')

opt = int(sys.argv[2])

if opt == 3:
	genConfigFiles(sys.argv[3], train_count);
	sys.exit(0)

if opt == 4:
	generateDataSet('test-', train_count, ' -d 0.9');
	sys.exit(0)

# numNewRequests per calendar is defined in .agents file
if opt != 2:
	generateDataSet("train-", train_count, ' -d -1.0');

if opt != 1:
	scheduleDataSet(classpath, "cmradar", "train-", train_count);

if opt == 0 or opt == 2:
	outfile = "cmradar-learned"
	os.system('cp Randal-rank.traininglog ' + outfile + '.rank');
	os.system(JAVA + " -classpath " + classpath + " cmradar.manager.neg.SimpleBayesMTypeLearner Randal.traininglog " + outfile + ".owners ") 


# comment this out: this is only for ozone testing (local) 
#print('java -classpath ' + classpath + ' cmradar.manager.sim.RSimulator -ufrsched -agent "' + file_prefix + '.agents" -room "' + file_prefix + '.rooms" -true-owner "'+ file_prefix + '.owners" -learned-owners "" -mtgs "' + file_prefix + '.meetings" -cal "' + file_prefix + '.sharedroomcalendar" -sctemplates "' + file_prefix + '.templates"');

#os.system('java -classpath ' + classpath + ' cmradar.manager.sim.RSimulator -ufrsched -agent "' + file_prefix + '.agents" -room "' + file_prefix + '.rooms" -true-owner "'+ file_prefix + '.owners" -learned-owner "" -mtgs "' + file_prefix + '.meetings" -cal "' + file_prefix + '.sharedroomcalendar" -sctemplates "' + file_prefix + '.templates"');

