package SpaceTime.DataModel;

import java.util.ArrayList;

public class LinearFunctionIntervals{
    private ArrayList _intervals;

    public LinearFunctionIntervals() {
	    _intervals = new ArrayList();
    }
	
    public int Size() {
	    return _intervals.size();
    }
	
    public void Add(double start, double stop) {
	    _intervals.add(new Interval(start, stop));
    }
	
    public double GetStartValue(int index) {
	    Interval interval = (Interval)_intervals.get(index);
	    return interval.start;
    }

    public double GetStopValue(int index) {
	    Interval interval = (Interval)_intervals.get(index);
	    return interval.stop;
    }
	
    private class Interval {
	    public double start;
	    public double stop;
	    public Interval(double start, double stop) {
		    this.start = start;
		    this.stop = stop;
	    }
    }
}
