/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.sys;

import cmradar.manager.data.Calendar;
import cmradar.manager.data.RoomTemplate;
import cmradar.manager.data.Template;
import cmradar.manager.data.TimeSlot;
import cmradar.manager.sched.Scheduler;
import cmradar.manager.sim.RSimulator;
import cmradar.manager.sim.Simulator;
import cmradar.manager.sys.RManagerIO;
import cmradar.manager.sys.RManagerIOFrame;
import cmradar.manager.sys.SchedulerShutdown;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SchedulerInvoker
implements Scheduler {
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$sys$SchedulerInvoker == null ? (class$cmradar$manager$sys$SchedulerInvoker = SchedulerInvoker.class$("cmradar.manager.sys.SchedulerInvoker")) : class$cmradar$manager$sys$SchedulerInvoker).getName());
    String myUserId;
    String schedulerHost = "localhost";
    Socket schedulerSocket = null;
    int schedulerPort = 9998;
    PrintWriter out = null;
    BufferedReader in = null;
    RManagerIO ioManager = null;
    int numSlots = 1;
    String agentFile;
    String roomFile;
    String ownerFile;
    String bumpingPenaltyFile;
    boolean connected = false;
    private Vector currentResult;
    static Vector processes = new Vector();
    public static boolean LEARNING = false;
    public static final String RANDOM = "r";
    public static final String TRUE = "t";
    public static final String LEARNED = "l";
    public static String PREFMODE = "t";
    public static int TESTPORT = -1;
    public static final String RADAR_HOME = "f:/ozone/src/models/radar/";
    public static boolean LOG = false;
    public static boolean EXITLISP = true;
    public static boolean REUSE_SHARED_CAL = false;
    public static int RADAR_BUMPING_COUNT = 0;
    private static final int __NUM_MEETINGS = 1000;
    public static String SCHED_EXE = "c:/cmradar/scheduler/cmradar-room.exe";
    Process p;
    private static String hostName = null;
    static /* synthetic */ Class class$cmradar$manager$sys$SchedulerInvoker;

    public SchedulerInvoker(String string, RManagerIO rManagerIO, int n) {
        this.myUserId = string;
        this.ioManager = rManagerIO;
        this.schedulerPort = n;
    }

    public boolean connect() {
        if (!this.connected && this.schedulerPort > 0) {
            try {
                this.schedulerSocket = new Socket(this.schedulerHost, this.schedulerPort);
                this.out = new PrintWriter(this.schedulerSocket.getOutputStream(), true);
                this.in = new BufferedReader(new InputStreamReader(this.schedulerSocket.getInputStream()));
                this.connected = true;
            }
            catch (UnknownHostException unknownHostException) {
                this.ioManager.writeLine("Don't know about host: " + this.schedulerHost);
                this.connected = false;
            }
            catch (IOException iOException) {
                this.ioManager.writeLine("1Couldn't connect to Scheduler on: " + this.schedulerHost + " " + this.schedulerPort);
                this.connected = false;
            }
        }
        logger.log((Priority)Level.DEBUG, (Object)("connected to scheduler " + this.schedulerPort + ":" + this.connected));
        return this.connected;
    }

    public void disconnect() throws IOException {
        this.schedulerSocket.close();
        this.in.close();
        this.out.close();
        this.connected = false;
    }

    public String sendToScheduler(String string) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.connect()) {
            this.out.println(string);
            this.out.flush();
            try {
                String string3 = this.in.readLine();
                stringBuffer.append(string3);
                while (string3 != null) {
                    string3 = this.in.readLine();
                    if (string3 == null) continue;
                    stringBuffer.append(string3);
                }
                this.disconnect();
            }
            catch (IOException iOException) {
                this.ioManager.writeLine("sendToScheduler(): Read from socket failed");
                iOException.printStackTrace();
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public String sendToScheduler(Vector vector) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.connect()) {
            try {
                logger.log((Priority)Level.INFO, (Object)("Sending " + vector.size() + " requests to scheduler"));
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    this.out.println(string2);
                    this.out.flush();
                    String string3 = this.in.readLine();
                    while (string3 != null) {
                        string3 = this.in.readLine();
                    }
                }
                this.disconnect();
            }
            catch (Exception exception) {
                this.ioManager.writeLine("sendToScheduler(Vector): Read from socket failed");
                exception.printStackTrace();
            }
        }
        return string;
    }

    public String processRequest(String string, int n) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer("( process-meeting-request  ");
        stringBuffer.append(string + " " + n + " )");
        string2 = this.sendToScheduler(stringBuffer.toString());
        return string2;
    }

    public String processRoomRequest(String string, int n) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer("( process-room-request-bcount  ");
        stringBuffer.append(string + " " + n + " " + RADAR_BUMPING_COUNT + " " + (LOG ? TRUE : "nil") + " )");
        string2 = this.sendToScheduler(stringBuffer.toString());
        return string2;
    }

    public Vector processRoomRequest(RoomTemplate roomTemplate, int n) {
        String string = roomTemplate.toLispList();
        logger.log((Priority)Level.DEBUG, (Object)("Before sending a request to OZONE " + roomTemplate.getMeetingId() + "(" + roomTemplate.getInitiator() + ")"));
        String string2 = this.processRoomRequest(string, n);
        if (string2 != null) {
            logger.log((Priority)Level.DEBUG, (Object)("SCHEDULER RETURNED...\n" + string2));
            this.currentResult = RoomTemplate.getTemplatesFromString(string2);
        } else {
            logger.log((Priority)Level.INFO, (Object)"result was NULL");
        }
        return this.currentResult;
    }

    public Vector processRoomRequestList(Vector vector) {
        try {
            logger.log((Priority)Level.INFO, (Object)("sending " + vector.size() + " ....................."));
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer("(");
            for (int i = 0; i < vector.size(); ++i) {
                RoomTemplate roomTemplate = (RoomTemplate)vector.get(i);
                TimeSlot timeSlot = roomTemplate.getConfirmedTimeSlot();
                if (roomTemplate.getStatus().equals("unknown")) continue;
                stringBuffer.append(roomTemplate.toLispList() + "\n");
                if (i % 1000 != 0) continue;
                stringBuffer.append(")");
                String string = this.processRoomRequestList(stringBuffer.toString());
                logger.log((Priority)Level.DEBUG, (Object)("sending " + n++ + " ..."));
                System.gc();
                stringBuffer = new StringBuffer("(");
            }
            stringBuffer.append(")");
            String string = this.processRoomRequestList(stringBuffer.toString());
            logger.log((Priority)Level.DEBUG, (Object)"sending LAST ... ");
            System.gc();
        }
        catch (Exception exception) {
            logger.log((Priority)Level.ERROR, (Object)("Error in saving calendar: " + exception.toString()));
        }
        return null;
    }

    public String updateAvailabilityList(HashMap hashMap, String string) {
        StringBuffer stringBuffer = new StringBuffer("( update-availability-list (");
        int n = 0;
        Object object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            double d = (Double)hashMap.get(string2);
            String string3 = String.valueOf(d);
            if (d != 0.0) {
                ++n;
            }
            stringBuffer.append("(\"" + string2 + "\" " + string3 + ")");
        }
        stringBuffer.append(") \"" + string + "\")");
        logger.log((Priority)Level.DEBUG, (Object)stringBuffer.toString());
        object = this.sendToScheduler(stringBuffer.toString());
        logger.log((Priority)Level.DEBUG, (Object)("NONZERO availability hotels = " + n));
        return object;
    }

    public static void sharedCalToTemplates(Vector vector, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("(");
            logger.log((Priority)Level.INFO, (Object)("--- saving templates into " + string));
            for (int i = 0; i < vector.size(); ++i) {
                RoomTemplate roomTemplate = (RoomTemplate)vector.get(i);
                bufferedWriter.write(roomTemplate.toLispList() + "\n");
            }
            bufferedWriter.write(")");
            bufferedWriter.close();
            logger.log((Priority)Level.INFO, (Object)"QUIT!!");
            System.exit(0);
        }
        catch (Exception exception) {
            logger.log((Priority)Level.ERROR, (Object)("Error in saving calendar: " + exception.toString()));
        }
    }

    public String processRoomRequestList(String string) {
        logger.log((Priority)Level.DEBUG, (Object)"sending template list to OZNOE");
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer("( process-room-request-list ");
        stringBuffer.append(string + " :log nil)");
        string2 = this.sendToScheduler(stringBuffer.toString());
        return string2;
    }

    public double evaluateSchedule() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer("( evaluate-schedule )");
        string = this.sendToScheduler(stringBuffer.toString());
        return new Double(string);
    }

    public boolean testCommunication() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer("( test-communicate )");
        string = this.sendToScheduler(stringBuffer.toString());
        return string != null;
    }

    public void resetScheduler(String string) {
        StringBuffer stringBuffer = new StringBuffer("( radar-init " + string + " )");
        this.sendToScheduler(stringBuffer.toString());
    }

    public void resetRoomSchedulerFiles(String string, String string2, String string3) {
        this.agentFile = string;
        this.roomFile = string2;
        this.ownerFile = string3;
    }

    public void setBumpingPenaltyFile(String string) {
        this.bumpingPenaltyFile = string;
    }

    public void resetRoomScheduler(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("(radar-init-room ");
        stringBuffer.append("\"" + this.myUserId + "\" ");
        if (string != null) {
            stringBuffer.append(":agent-file \"" + string + "\" ");
        }
        if (string2 != null) {
            stringBuffer.append(":room-file \"" + string2 + "\" ");
        }
        if (string3 != null) {
            stringBuffer.append(":owner-file \"" + string3 + "\" ");
        }
        stringBuffer.append(" :hotels \"(list \\\"Flagstaff\\\")\" ");
        stringBuffer.append(":fast-load " + (REUSE_SHARED_CAL ? TRUE : "nil"));
        stringBuffer.append(":subdir \"" + RSimulator.REQUEST_DIR + "\"");
        if (LOG) {
            stringBuffer.append(":log t ");
        }
        stringBuffer.append(" )");
        this.sendToScheduler(stringBuffer.toString());
    }

    public void setBumping(boolean bl) {
        StringBuffer stringBuffer = bl ? new StringBuffer("( bumping  t )") : new StringBuffer("( bumping  nil )");
        this.sendToScheduler(stringBuffer.toString());
    }

    public void setSaveModel() {
        this.sendToScheduler("(save-model t)");
    }

    public void saveModel() {
        this.sendToScheduler("(save-model t)");
    }

    public void setBumpingStrategy(int n) {
        StringBuffer stringBuffer;
        if (n == 3) {
            stringBuffer = new StringBuffer("( bumping-strategy :predefined-kind )");
        } else if (n == 1) {
            stringBuffer = new StringBuffer("( bumping-strategy :num-attendees )");
        } else if (n == 4) {
            stringBuffer = new StringBuffer("( bumping-strategy :mtg-id )");
        } else {
            if (n == 2) {
                return;
            }
            if (n == 0) {
                return;
            }
            logger.log((Priority)Level.WARN, (Object)("Unknown strategy in setBumpingStrategy(): " + n));
            return;
        }
        this.sendToScheduler(stringBuffer.toString());
    }

    public Vector processRequest(Template template) {
        return this.processRequest(template, this.numSlots);
    }

    public Vector processRequestList(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < vector.size(); ++i) {
            Template template = (Template)vector.get(i);
            stringBuffer.append(template.toLispList());
        }
        stringBuffer.append(")");
        String string = this.processRequestList(stringBuffer.toString(), this.numSlots);
        return null;
    }

    public String processRequestList(String string, int n) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer("( process-meeting-request-list  ");
        stringBuffer.append(string + " " + n + " )");
        string2 = this.sendToScheduler(stringBuffer.toString());
        return string2;
    }

    public Vector processRequest(Template template, int n) {
        String string;
        String string2;
        if (template.timeSlots.size() > 1) {
            // empty if block
        }
        if ((string2 = this.processRequest(string = template.toLispList(), n)) != null) {
            Template template2;
            int n2;
            this.currentResult = Template.getTemplatesFromString(string2);
            Vector<Template> vector = new Vector<Template>();
            for (n2 = 0; n2 < this.currentResult.size(); ++n2) {
                template2 = (Template)this.currentResult.elementAt(n2);
                for (int i = n2 + 1; i < this.currentResult.size(); ++i) {
                    Template template3 = (Template)this.currentResult.elementAt(i);
                    if (!template2.getMeetingId().equals(template3.getMeetingId())) continue;
                    logger.log((Priority)Level.WARN, (Object)"Seems like an error: two templateswith same meeting id received...ignoring one of them. ");
                    vector.add(template3);
                }
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                template2 = (Template)vector.elementAt(n2);
                this.currentResult.remove(template2);
            }
            vector = new Vector();
            for (n2 = 0; n2 < this.currentResult.size(); ++n2) {
                Vector vector2;
                template2 = (Template)this.currentResult.elementAt(n2);
                if (template2.getMeetingId().equals(template.getMeetingId()) || (vector2 = template2.getImpossibleTimeSlots()).size() != 0) continue;
                logger.log((Priority)Level.WARN, (Object)"Seems like an error: bumping template received with no impossible slots...removing !!!! ");
                vector.add(template2);
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                template2 = (Template)vector.elementAt(n2);
                this.currentResult.remove(template2);
            }
            if (this.currentResult.size() == 0) {
                Vector vector3 = Template.getTemplatesFromString(string2);
                for (int i = 0; i < vector.size(); ++i) {
                    Template template4 = (Template)vector.elementAt(i);
                }
            }
            System.out.println("\n>>>>2mtgs:currentResultsz=" + this.currentResult.size());
            return this.currentResult;
        }
        return null;
    }

    public Vector getCurrentResult() {
        return this.currentResult;
    }

    public static String toSchedPref(String string) {
        String string2 = "";
        if (string.equals(Calendar.MORNING)) {
            string2 = "1";
        } else if (string.equals(Calendar.AFTERNOON)) {
            string2 = "2";
        } else if (string.equals(Calendar.NONE)) {
            string2 = "nil";
        } else {
            logger.log((Priority)Level.FATAL, (Object)("Error: Unknown preference type -- " + string));
            System.exit(0);
        }
        return string2;
    }

    public static void destroyLispProcesses() {
        if (EXITLISP) {
            Enumeration enumeration = processes.elements();
            while (enumeration.hasMoreElements()) {
                Process process = (Process)enumeration.nextElement();
                process.destroy();
                logger.log((Priority)Level.INFO, (Object)"Close lisp...");
            }
        }
    }

    public static void setHostName(String string) {
        hostName = string;
    }

    public void startScheduler(String string, String string2) {
        this.myUserId = string;
        String string3 = SchedulerInvoker.toSchedPref(string2);
        String string4 = "\"" + SCHED_EXE + "\" +cx " + "-e \"(setf *package* (find-package :opis))\" " + "-e '(opis::radar-init-room " + " \"" + this.myUserId + "\" " + " :agent-file \"" + this.agentFile + "\"" + " :room-file \"" + this.roomFile + "\"" + " :owner-file \"" + this.ownerFile + "\"" + " :fast-load " + (REUSE_SHARED_CAL ? TRUE : "nil") + " :subdir \"" + RSimulator.REQUEST_DIR + "\"" + " :log " + (LOG ? TRUE : "nil") + " :hotels \"(list \\\"Flagstaff\\\")\"" + " :penalty \"" + this.bumpingPenaltyFile + "\" " + ")' " + "-e \"(setf opis::*radar-log-level* " + Simulator.schedulerLogLevel + ")\" " + "-e \"(opis::demo " + this.schedulerPort + ")\"";
        logger.log((Priority)Level.DEBUG, (Object)("Starting scheduler with command: \n\t" + string4));
        boolean bl = false;
        bl = this.testCommunication();
        if (!bl) {
            try {
                this.p = Runtime.getRuntime().exec(string4);
                if (EXITLISP) {
                    SchedulerShutdown schedulerShutdown = new SchedulerShutdown(this.p);
                    Runtime.getRuntime().addShutdownHook(schedulerShutdown);
                    processes.add(this.p);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(0);
            }
            int n = 0;
            while (!bl) {
                ++n;
                logger.log((Priority)Level.DEBUG, (Object)"sleep for a sec...");
                try {
                    Thread.sleep(6000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = this.testCommunication();
                if (bl) break;
                if (n != 5) continue;
                logger.log((Priority)Level.FATAL, (Object)"Failure to connect to Scheduler.");
                System.exit(0);
            }
        }
        this.ioManager.writeLine("Scheduler started.");
    }

    public static void testRoom() {
        System.out.println("I am ROOM SchedulerInvoker");
        RManagerIOFrame rManagerIOFrame = new RManagerIOFrame("A", "A", 30, 30, 500, 500);
        rManagerIOFrame.showCalendar = false;
        SchedulerInvoker schedulerInvoker = new SchedulerInvoker("A", rManagerIOFrame, 9998);
        schedulerInvoker.startScheduler("A", "None");
        RoomTemplate roomTemplate = new RoomTemplate();
        roomTemplate.fillInTestData1();
        RoomTemplate roomTemplate2 = new RoomTemplate();
        roomTemplate2.fillInTestData1();
        String string = roomTemplate.toLispList();
        System.out.println("\n---------------\n");
        System.out.println(string + "\n---------------\n");
        System.out.flush();
        schedulerInvoker.resetRoomScheduler("cmradar.agents", "empty.rooms", "cmradar.owners");
        String string2 = schedulerInvoker.processRoomRequest(string, 1);
        System.out.println("ANS1=" + string2 + "\n.............\n");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            SchedulerInvoker.testRoom();
            return;
        }
        System.out.println("I am SchedulerInvoker");
        RManagerIOFrame rManagerIOFrame = new RManagerIOFrame("A", "A", 30, 30, 500, 500);
        rManagerIOFrame.showCalendar = false;
        SchedulerInvoker schedulerInvoker = new SchedulerInvoker("A", rManagerIOFrame, 8888);
        schedulerInvoker.startScheduler("USL1", "None");
        schedulerInvoker.setBumping(false);
        schedulerInvoker.setBumpingStrategy(1);
        schedulerInvoker.setBumpingStrategy(3);
        Template template = new Template();
        template.meetingId = "10001";
        template.initiator = "A";
        template.addAttendant("A", 1.0);
        TimeSlot timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [8:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [9:00 -0500]";
        timeSlot.startTime = "2004-06-25 [8:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [9:00 -0500]";
        template.addTimeSlot(timeSlot, "possible");
        template.addPurpose("13", "nil", "nil");
        schedulerInvoker.processRequest(template);
        template = new Template();
        template.meetingId = "41";
        template.initiator = "A";
        template.addAttendant("A", 1.0);
        template.addAttendant("B", 1.0);
        template.addAttendant("C", 1.0);
        timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [8:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [9:00 -0500]";
        timeSlot.startTime = "2004-06-25 [8:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [9:00 -0500]";
        template.addTimeSlot(timeSlot, "possible");
        template.addPurpose("14", "nil", "nil");
        Vector vector = schedulerInvoker.processRequest(template);
        for (int i = 0; i < vector.size(); ++i) {
            Template template2 = (Template)vector.elementAt(i);
            System.out.println(i + " " + template2.toString());
        }
        schedulerInvoker.setBumping(true);
        template = new Template();
        template.meetingId = "1";
        template.initiator = "A";
        template.addAttendant("A", 1.0);
        timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [9:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [10:00 -0500]";
        timeSlot.startTime = "2004-06-25 [9:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [10:00 -0500]";
        template.addTimeSlot(timeSlot, "possible");
        timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [8:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [9:00 -0500]";
        timeSlot.startTime = "2004-06-25 [8:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [9:00 -0500]";
        template.addTimeSlot(timeSlot, "pending");
        schedulerInvoker.processRequest(template);
        System.exit(0);
        template = new Template();
        template.meetingId = "3";
        template.initiator = "A";
        template.addAttendant("A", 1.0);
        timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [11:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [12:00 -0500]";
        timeSlot.startTime = "2004-06-25 [11:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [12:00 -0500]";
        template.addTimeSlot(timeSlot, "confirmed");
        schedulerInvoker.processRequest(template);
        System.out.println("eval: " + schedulerInvoker.evaluateSchedule());
        template = new Template();
        template.meetingId = "4";
        template.initiator = "A";
        template.addAttendant("A", 1.0);
        timeSlot = new TimeSlot();
        timeSlot.earliestStartTime = "2004-06-25 [9:00 -0500]";
        timeSlot.latestFinishTime = "2004-06-25 [12:00 -0500]";
        timeSlot.startTime = "2004-06-25 [9:00 -0500]";
        timeSlot.finishTime = "2004-06-25 [12:00 -0500]";
        template.addTimeSlot(timeSlot, "possible");
        String string = schedulerInvoker.processRequest(template.toLispList(), 1);
        rManagerIOFrame.writeLine(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

