/*
 * Decompiled with CFR 0.152.
 */
package cmradar.manager.data;

import cmradar.manager.data.Meeting;
import cmradar.manager.data.Room;
import cmradar.manager.data.TimeSlot;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RoomCalendar {
    static Logger logger = Logger.getLogger((String)(class$cmradar$manager$data$RoomCalendar == null ? (class$cmradar$manager$data$RoomCalendar = RoomCalendar.class$("cmradar.manager.data.RoomCalendar")) : class$cmradar$manager$data$RoomCalendar).getName());
    private Room room;
    private LinkedList meetings;
    static /* synthetic */ Class class$cmradar$manager$data$RoomCalendar;

    public RoomCalendar(Room room) {
        this.room = room;
        this.meetings = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMeeting(Meeting meeting, TimeSlot timeSlot, boolean bl) {
        LinkedList linkedList = this.meetings;
        synchronized (linkedList) {
            if (bl) {
                Iterator iterator = this.meetings.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    RoomSchedInfo roomSchedInfo = (RoomSchedInfo)iterator.next();
                    TimeSlot timeSlot2 = roomSchedInfo.getTimeSlot();
                    if (timeSlot2.overlaps(timeSlot)) {
                        logger.log((Priority)Level.ERROR, (Object)("Room=" + this.room.getRoomId() + " slot " + timeSlot.toString() + "@" + timeSlot.location + " overlaps with " + timeSlot2.toString() + "@" + timeSlot2.location + " mt=" + meeting.getMeetingId() + " info=" + roomSchedInfo.getMeeting().getMeetingId()));
                        System.exit(0);
                        return false;
                    }
                    if (timeSlot2.after(timeSlot)) break;
                    ++n;
                }
                this.meetings.add(n, new RoomSchedInfo(this.room, meeting, timeSlot));
            } else {
                this.meetings.add(new RoomSchedInfo(this.room, meeting, timeSlot));
            }
        }
        return true;
    }

    public void sync() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMeeting(Meeting meeting) {
        LinkedList linkedList = this.meetings;
        synchronized (linkedList) {
            ListIterator listIterator = this.meetings.listIterator();
            while (listIterator.hasNext()) {
                RoomSchedInfo roomSchedInfo = (RoomSchedInfo)listIterator.next();
                if (!meeting.getMeetingId().equals(roomSchedInfo.getMeeting().getMeetingId())) continue;
                listIterator.remove();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMeeting(String string) {
        LinkedList linkedList = this.meetings;
        synchronized (linkedList) {
            ListIterator listIterator = this.meetings.listIterator();
            while (listIterator.hasNext()) {
                RoomSchedInfo roomSchedInfo = (RoomSchedInfo)listIterator.next();
                if (!string.equals(roomSchedInfo.getMeeting().getMeetingId())) continue;
                listIterator.remove();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getMeetings() {
        LinkedList linkedList = null;
        LinkedList linkedList2 = this.meetings;
        synchronized (linkedList2) {
            linkedList = (LinkedList)this.meetings.clone();
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getMeetings(String string) {
        LinkedList<RoomSchedInfo> linkedList = new LinkedList<RoomSchedInfo>();
        LinkedList linkedList2 = this.meetings;
        synchronized (linkedList2) {
            Iterator iterator = this.meetings.iterator();
            while (iterator.hasNext()) {
                RoomSchedInfo roomSchedInfo = (RoomSchedInfo)iterator.next();
                if (!roomSchedInfo.getMeeting().getMeetingId().equals(string)) continue;
                linkedList.addLast(roomSchedInfo);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getMeetings(TimeSlot timeSlot) {
        LinkedList<Meeting> linkedList = new LinkedList<Meeting>();
        boolean bl = false;
        LinkedList linkedList2 = this.meetings;
        synchronized (linkedList2) {
            Iterator iterator = this.meetings.iterator();
            while (iterator.hasNext()) {
                RoomSchedInfo roomSchedInfo = (RoomSchedInfo)iterator.next();
                TimeSlot timeSlot2 = roomSchedInfo.getTimeSlot();
                if (!timeSlot2.overlaps(timeSlot)) continue;
                linkedList.add(roomSchedInfo.getMeeting());
                bl = true;
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getMeetings(TimeSlot timeSlot, String string) {
        LinkedList<Meeting> linkedList = new LinkedList<Meeting>();
        LinkedList linkedList2 = this.meetings;
        synchronized (linkedList2) {
            Iterator iterator = this.meetings.iterator();
            while (iterator.hasNext()) {
                RoomSchedInfo roomSchedInfo = (RoomSchedInfo)iterator.next();
                TimeSlot timeSlot2 = roomSchedInfo.getTimeSlot();
                if (!timeSlot2.overlaps(timeSlot)) continue;
                Meeting meeting = roomSchedInfo.getMeeting();
                if (!meeting.initiator.equals(string)) continue;
                linkedList.add(meeting);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFree(TimeSlot timeSlot) {
        LinkedList linkedList = this.meetings;
        synchronized (linkedList) {
            Iterator iterator = this.meetings.iterator();
            while (iterator.hasNext()) {
                TimeSlot timeSlot2 = ((RoomSchedInfo)iterator.next()).getTimeSlot();
                if (!timeSlot2.overlaps(timeSlot)) continue;
                return false;
            }
        }
        return true;
    }

    public Room getRoom() {
        return this.room;
    }

    public String toParseString() {
        return this.toParseString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toParseString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList linkedList = this.meetings;
        synchronized (linkedList) {
            Iterator iterator = this.meetings.iterator();
            while (iterator.hasNext()) {
                RoomSchedInfo roomSchedInfo = (RoomSchedInfo)iterator.next();
                Meeting meeting = roomSchedInfo.getMeeting();
                TimeSlot timeSlot = roomSchedInfo.getTimeSlot();
                stringBuffer.append("<room-meeting>");
                stringBuffer.append("\n\troom-id: ");
                stringBuffer.append(this.room.getRoomId());
                stringBuffer.append("\n\tmeeting-id: ");
                if (bl) {
                    stringBuffer.append("unknown");
                } else {
                    stringBuffer.append(meeting.getMeetingId());
                }
                stringBuffer.append("\n\ttime: ");
                stringBuffer.append(timeSlot.toParseString());
                stringBuffer.append("\n</room-meeting>\n");
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RoomSchedInfo {
        private Meeting meeting;
        private TimeSlot time;
        private Room room;

        public RoomSchedInfo(Room room, Meeting meeting, TimeSlot timeSlot) {
            this.meeting = meeting;
            this.time = timeSlot;
            this.room = room;
        }

        Meeting getMeeting() {
            return this.meeting;
        }

        TimeSlot getTimeSlot() {
            return this.time;
        }

        Room getRoom() {
            return this.room;
        }
    }
}

