/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import edu.cmu.cs.radar.rhai.spacetime.WindowUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import javax.swing.JPanel;

public class TitlePane
extends JPanel
implements LayoutManager2 {
    private static final long serialVersionUID = 0L;
    private String _title;
    private int _borders;
    private Component _contents;
    public static final int NOBORDER = 0;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 4;
    public static final int WEST = 8;

    public TitlePane(String title, int borders, Component contents) {
        this._title = title;
        this._borders = borders;
        this._contents = contents;
        this.setBackground(Color.white);
        this.setLayout(this);
        this.add(this._contents);
        this._contents.setLocation(1, 16);
        this._contents.setSize(this.getWidth() - 2, this.getHeight() - 18);
    }

    public void setTitle(String title) {
        this._title = title;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = SwingHelper.prepareGraphics(g);
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(Color.lightGray);
        g2.fillRect(0, 0, this.getWidth(), 15);
        g2.setColor(Color.gray);
        if ((this._borders & 1) == 1) {
            g2.drawLine(0, 0, this.getWidth() - 1, 0);
        }
        if ((this._borders & 2) == 2) {
            g2.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        }
        if ((this._borders & 4) == 4) {
            g2.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        if ((this._borders & 8) == 8) {
            g2.drawLine(0, 0, 0, this.getHeight() - 1);
        }
        g2.setFont(this.getFont().deriveFont(1, 11.0f));
        g2.setColor(Color.black);
        String titleString = WindowUtilities.trimString(this._title, g2.getFontMetrics(), this.getWidth());
        g2.drawString(titleString, 4, 11);
    }

    @Override
    public void addLayoutComponent(Component arg0, Object arg1) {
    }

    @Override
    public float getLayoutAlignmentX(Container arg0) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container arg0) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container arg0) {
    }

    @Override
    public Dimension maximumLayoutSize(Container arg0) {
        return new Dimension(100, 100);
    }

    @Override
    public void addLayoutComponent(String arg0, Component arg1) {
    }

    @Override
    public void layoutContainer(Container arg0) {
        int width = this.getWidth() - 2;
        int height = this.getHeight() - 18;
        this._contents.setLocation(1, 16);
        this._contents.setSize(width, height);
    }

    @Override
    public Dimension minimumLayoutSize(Container arg0) {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension preferredLayoutSize(Container arg0) {
        return new Dimension(100, 100);
    }

    @Override
    public void removeLayoutComponent(Component arg0) {
    }
}

