/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class STMBackendController {
    public static final String ST_MODULE_PATH_KEY = "radar.stp.st-module.path";
    public static final String IIOP_HOSTNAME_KEY = "radar.stp.iiop.hostname";
    public static final String IIOP_PORT_KEY = "radar.stp.iiop.port";

    protected static SpaceTimeSession startSTMBackend(Properties radarProperties, Logger logger) {
        return STMBackendController.startSTMBackend(radarProperties, logger, false);
    }

    protected static SpaceTimeSession startSTMBackend(Properties radarProperties, Logger logger, boolean teeOutput) {
        String stModulePath;
        block7: {
            stModulePath = radarProperties.getProperty(ST_MODULE_PATH_KEY);
            if (stModulePath == null) {
                logger.error("property 'radar.stp.st-module.path' is undefined");
                return null;
            }
            String stModuleCommand = String.valueOf(stModulePath) + " IIOP_PORT=" + radarProperties.getProperty(IIOP_PORT_KEY);
            logger.info("stm backend starting: " + stModuleCommand);
            Process stModuleProcess = Runtime.getRuntime().exec(stModuleCommand);
            logger.info("stm backend started");
            InputStream stdOut = stModuleProcess.getInputStream();
            InputStream stdErr = stModuleProcess.getErrorStream();
            Logger stmLogger = Logger.getLogger("STM:ST-MODULE");
            STMBackendReadyLineListener readyListener = new STMBackendReadyLineListener(logger);
            OutputLogger stdOutOutputLogger = new OutputLogger(stdOut, stmLogger, Level.INFO);
            stdOutOutputLogger.addLineListener(readyListener);
            OutputLogger stdErrOutputLogger = new OutputLogger(stdErr, stmLogger, Level.ERROR);
            if (teeOutput) {
                stdOutOutputLogger.addLineListener(new PrintStreamLineListener(System.out));
                stdErrOutputLogger.addLineListener(new PrintStreamLineListener(System.err));
            }
            new Thread(stdOutOutputLogger).start();
            new Thread(stdErrOutputLogger).start();
            if (readyListener.waitForSTMBackendToStart()) break block7;
            return null;
        }
        try {
            int cumulativeSleepDuration = 0;
            Exception stmConnectException = null;
            int tri = 1;
            while (tri <= 10) {
                SpaceTimeSession stmSession = SpaceTimeSession.createInstance(radarProperties);
                if (stmSession.isConnected()) {
                    logger.info("connected to stm backend");
                    return stmSession;
                }
                stmConnectException = stmSession._connectException;
                int sleepDuration = tri * 1000;
                cumulativeSleepDuration += sleepDuration;
                STMBackendController.sleep(sleepDuration);
                ++tri;
            }
            logger.error("unable to connect to stm backend after " + cumulativeSleepDuration / 1000 + " second(s)", stmConnectException);
        }
        catch (IOException ex) {
            logger.error("unable to start stm backend: " + stModulePath, ex);
        }
        return null;
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static interface LineListener {
        public void lineRead(String var1);

        public void eof();
    }

    private static class OutputLogger
    implements Runnable {
        private BufferedReader _reader;
        private Logger _log;
        private Level _level;
        private List<LineListener> _lineListeners;

        public OutputLogger(InputStream in, Logger log, Level level) {
            this._reader = new BufferedReader(new InputStreamReader(in));
            this._log = log;
            this._level = level;
            this._lineListeners = new ArrayList<LineListener>();
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this._reader.readLine()) != null) {
                    this._log.log(this._level, line);
                    this.fireLineRead(line);
                }
            }
            catch (Exception ex) {
                this._log.error("caught exception reading stm backend stream (" + this._level.toString() + ")", ex);
            }
            this.fireEOF();
        }

        public void addLineListener(LineListener listener) {
            this._lineListeners.add(listener);
        }

        private void fireLineRead(String line) {
            for (LineListener lineListener : this._lineListeners) {
                lineListener.lineRead(line);
            }
        }

        private void fireEOF() {
            for (LineListener lineListener : this._lineListeners) {
                lineListener.eof();
            }
        }
    }

    private static class PrintStreamLineListener
    implements LineListener {
        private PrintStream _stream;

        public PrintStreamLineListener(PrintStream stream) {
            this._stream = stream;
        }

        @Override
        public void lineRead(String line) {
            this._stream.println(line);
        }

        @Override
        public void eof() {
        }
    }

    private static class STMBackendReadyLineListener
    implements LineListener {
        private Logger _logger;
        private boolean _stmBackendStarted = false;
        private boolean _eof = false;

        public STMBackendReadyLineListener(Logger logger) {
            this._logger = logger;
        }

        @Override
        public synchronized void lineRead(String line) {
            this._logger.trace("enter: lineRead(): " + line);
            if (line.equals("STM Backend started")) {
                this._stmBackendStarted = true;
                this._logger.trace("received notification that the stm backend has started, releasing all waiting threads");
                this.notifyAll();
            }
            this._logger.trace("leave: lineRead()");
        }

        @Override
        public synchronized void eof() {
            this._logger.trace("enter: eof()");
            this._eof = true;
            this.notifyAll();
            this._logger.trace("leave: eof()");
        }

        public synchronized boolean waitForSTMBackendToStart() {
            this._logger.trace("enter: waitForSTMBackendToStart()");
            while (!this._stmBackendStarted && !this._eof) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this._logger.error("waiting for STM Backend to start", ex);
                    ex.printStackTrace();
                }
            }
            this._logger.trace("leave: waitForSTMBackendToStart()");
            return this._stmBackendStarted;
        }
    }
}

