/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDuration;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;

public class Allocation {
    private SpaceTimeRequestNode _requestNode;

    public Allocation(SpaceTimeRequestNode requestNode) {
        this._requestNode = requestNode;
    }

    public String getName() {
        return this._requestNode.getRequestName();
    }

    public String getDescription() {
        return this._requestNode.getDescription();
    }

    public String getDisplayName() {
        return this._requestNode.getNode().getDisplayName();
    }

    public SpaceTimeDate getStart() {
        return this._requestNode.getStart();
    }

    public SpaceTimeDuration getDuration() {
        return this._requestNode.getDuration();
    }

    public void setStart(SpaceTimeDate time) {
        this._requestNode.setStart(time);
    }

    public void setDuration(SpaceTimeDuration duration) {
        this._requestNode.setDuration(duration);
    }

    public String getRoom() {
        return this._requestNode.getRoom();
    }

    public void setRoom(String room) {
        this._requestNode.setRoom(room);
    }

    public SpaceTimeRequestNode getRequestNode() {
        return this._requestNode;
    }

    public void waitUntilAssignmentValid() {
        while (this.getStart() == null || this.getDuration() == null || this.getRoom() == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static interface Listener {
        public void allocationTimeChanged();

        public void allocationRoomChanged();
    }
}

