/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.CalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.MultiOptionTimeGrid;
import edu.cmu.cs.radar.rhai.calendar.Time;
import edu.cmu.cs.radar.rhai.calendar.TimeGrid;
import edu.cmu.cs.radar.rhai.calendar.TimeLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class CalendarPanel
extends JPanel {
    protected CalendarObjectCollection mCalendarObjectCollection;
    protected Time.Range mRowRange;
    protected List<Object> mColumnLabels;
    protected List<Object> mRowLabels;
    protected ColumnHeader mColumnHeader;
    protected RowHeader mRowHeader;
    protected JScrollPane mScrollPane;
    protected Map<CellCoordinate, JComponent> mComponentMap;

    public CalendarPanel(CalendarObjectCollection calObjCol, Time.Range rowRange) {
        this(calObjCol, rowRange, new String[0], new String[]{""});
    }

    public CalendarPanel(CalendarObjectCollection calObjCol, Time.Range rowRange, Object[] columnLabels, Object[] rowLabels) {
        Object label;
        if (calObjCol == null) {
            throw new NullPointerException("argument 'calObjCol'");
        }
        if (rowRange == null) {
            throw new NullPointerException("argument 'rowRange'");
        }
        if (columnLabels == null) {
            throw new NullPointerException("argument 'columnLabels'");
        }
        if (rowLabels == null) {
            throw new NullPointerException("argument 'rowLabels'");
        }
        this.setLayout(new CalendarGridLayoutManager());
        this.setBackground(Color.WHITE);
        this.mCalendarObjectCollection = calObjCol;
        this.mRowRange = rowRange;
        this.mRowLabels = new ArrayList<Object>(rowLabels.length);
        int row = 0;
        while (row < rowLabels.length) {
            label = rowLabels[row];
            if (label == null) {
                throw new NullPointerException("argument rowLabels[" + row + "]");
            }
            this.mRowLabels.add(label);
            ++row;
        }
        this.mColumnLabels = new ArrayList<Object>(columnLabels.length);
        int col = 0;
        while (col < columnLabels.length) {
            label = columnLabels[col];
            if (label == null) {
                throw new NullPointerException("argument columnLabels[" + col + "]");
            }
            this.addColumn(columnLabels[col]);
            ++col;
        }
        this.mColumnHeader = new ColumnHeader();
        this.mRowHeader = new RowHeader();
    }

    protected abstract CalendarObjectCollection getCellCalendarObjectCollection(CellCoordinate var1);

    public int addColumn(Object colLabel) {
        int colIndex = this.mColumnLabels.size();
        this.mColumnLabels.add(new Column(colLabel));
        int rowIndex = 0;
        while (rowIndex < this.mRowLabels.size()) {
            CellCoordinate coord = new CellCoordinate(colIndex, colLabel, rowIndex, this.mRowLabels.get(rowIndex));
            CalendarObjectCollection calObjCol = this.getCellCalendarObjectCollection(coord);
            MultiOptionTimeGrid timeGrid = new MultiOptionTimeGrid(this.mRowRange);
            timeGrid.addOption(calObjCol, null);
            this.add((Component)timeGrid, coord);
            ++rowIndex;
        }
        if (this.mColumnHeader != null) {
            this.mColumnHeader.createLabels();
        }
        this.revalidate();
        return colIndex;
    }

    public ColumnHeader getColumnHeader() {
        return this.mColumnHeader;
    }

    public RowHeader getRowHeader() {
        return this.mRowHeader;
    }

    public TimeGrid getCell(int col, int row) {
        return (TimeGrid)this.mComponentMap.get(new CellCoordinate(col, row));
    }

    public JScrollPane installInScrollPane() {
        return this.installInScrollPane(new JScrollPane());
    }

    public JScrollPane installInScrollPane(JScrollPane scrollPane) {
        if (scrollPane == null) {
            throw new NullPointerException("argument 'scrollPane'");
        }
        this.mScrollPane = scrollPane;
        this.mScrollPane.setViewportView(this);
        this.mScrollPane.setColumnHeaderView(this.getColumnHeader());
        this.mScrollPane.setRowHeaderView(this.getRowHeader());
        this.mScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.mScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.mScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        this.mScrollPane.getHorizontalScrollBar().setBlockIncrement(100);
        this.mScrollPane.setBackground(Color.WHITE);
        JPanel corner = new JPanel();
        corner.setBackground(Color.WHITE);
        this.mScrollPane.setCorner("UPPER_LEFT_CORNER", corner);
        corner = new JPanel();
        corner.setBackground(Color.WHITE);
        this.mScrollPane.setCorner("UPPER_RIGHT_CORNER", corner);
        corner = new JPanel();
        corner.setBackground(Color.WHITE);
        this.mScrollPane.setCorner("LOWER_LEFT_CORNER", corner);
        corner = new JPanel();
        corner.setBackground(Color.WHITE);
        this.mScrollPane.setCorner("LOWER_RIGHT_CORNER", corner);
        return this.mScrollPane;
    }

    protected class CalendarGridLayoutManager
    implements LayoutManager2 {
        protected final int COLUMN_PADDING = 3;
        protected final int ROW_PADDING = 10;

        public CalendarGridLayoutManager() {
            CalendarPanel.this.mComponentMap = new HashMap<CellCoordinate, JComponent>();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            throw new IllegalArgumentException("components must be added with a constraint");
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            CalendarPanel.this.mComponentMap.put((CellCoordinate)constraints, (JComponent)comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int width;
            int right;
            int left;
            int columnCount = CalendarPanel.this.mColumnLabels.size();
            int rowCount = CalendarPanel.this.mRowLabels.size();
            double columnWidth = ((double)CalendarPanel.this.getWidth() - (double)((columnCount - 1) * 3)) / (double)columnCount;
            double rowHeight = ((double)CalendarPanel.this.getHeight() - (double)((rowCount - 1) * 10)) / (double)rowCount;
            double columnStep = columnWidth + 3.0;
            double rowStep = rowHeight + 10.0;
            int col = 0;
            while (col < columnCount) {
                left = (int)Math.rint((double)col * columnStep);
                right = (int)Math.rint((double)col * columnStep + columnWidth);
                width = right - left;
                int row = 0;
                while (row < rowCount) {
                    int top = (int)Math.rint((double)row * rowStep);
                    int bottom = (int)Math.rint((double)row * rowStep + rowHeight);
                    int height = bottom - top;
                    JComponent comp = CalendarPanel.this.mComponentMap.get(new CellCoordinate(col, row));
                    comp.setBounds(left, top, width, height);
                    ++row;
                }
                ++col;
            }
            col = 0;
            while (col < columnCount) {
                left = (int)Math.rint((double)col * columnStep);
                right = (int)Math.rint((double)col * columnStep + columnWidth);
                width = right - left;
                JLabel label = CalendarPanel.this.mColumnHeader.mLabels[col];
                label.setBounds(left, 0, width, CalendarPanel.this.mColumnHeader.getPreferredSize().height);
                ++col;
            }
            int row = 0;
            while (row < rowCount) {
                int top = (int)Math.rint((double)row * rowStep);
                int bottom = (int)Math.rint((double)row * rowStep + rowHeight);
                int height = bottom - top;
                TimeLabel label = CalendarPanel.this.mRowHeader.mLabels[row];
                label.setBounds(0, top, label.getPreferredSize().width, height);
                ++row;
            }
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int columnCount = CalendarPanel.this.mColumnLabels.size();
            int rowCount = CalendarPanel.this.mRowLabels.size();
            int width = (columnCount - 1) * 3;
            int[] rowHeights = new int[rowCount];
            int col = 0;
            while (col < columnCount) {
                int colWidth = Integer.MIN_VALUE;
                int row = 0;
                while (row < rowCount) {
                    JComponent comp = CalendarPanel.this.mComponentMap.get(new CellCoordinate(col, row));
                    Dimension minimumSize = comp.getMinimumSize();
                    colWidth = Math.max(colWidth, minimumSize.width);
                    rowHeights[row] = Math.max(rowHeights[row], minimumSize.height);
                    ++row;
                }
                width += colWidth;
                ++col;
            }
            int height = (rowCount - 1) * 10;
            int row = 0;
            while (row < rowCount) {
                height += rowHeights[row];
                ++row;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int columnCount = CalendarPanel.this.mColumnLabels.size();
            int rowCount = CalendarPanel.this.mRowLabels.size();
            int width = (columnCount - 1) * 3;
            int[] rowHeights = new int[rowCount];
            int col = 0;
            while (col < columnCount) {
                int colWidth = Integer.MIN_VALUE;
                int row = 0;
                while (row < rowCount) {
                    JComponent comp = CalendarPanel.this.mComponentMap.get(new CellCoordinate(col, row));
                    Dimension preferredSize = comp.getPreferredSize();
                    colWidth = Math.max(colWidth, preferredSize.width);
                    rowHeights[row] = Math.max(rowHeights[row], preferredSize.height);
                    ++row;
                }
                width += colWidth;
                ++col;
            }
            int height = (rowCount - 1) * 10;
            int row = 0;
            while (row < rowCount) {
                height += rowHeights[row];
                ++row;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int columnCount = CalendarPanel.this.mColumnLabels.size();
            int rowCount = CalendarPanel.this.mRowLabels.size();
            int width = (columnCount - 1) * 3;
            int[] rowHeights = new int[rowCount];
            int col = 0;
            while (col < columnCount) {
                int colWidth = Integer.MIN_VALUE;
                int row = 0;
                while (row < rowCount) {
                    JComponent comp = CalendarPanel.this.mComponentMap.get(new CellCoordinate(col, row));
                    Dimension maximumSize = comp.getMaximumSize();
                    colWidth = Math.max(colWidth, maximumSize.width);
                    rowHeights[row] = Math.max(rowHeights[row], maximumSize.height);
                    ++row;
                }
                width += colWidth;
                ++col;
            }
            int height = (rowCount - 1) * 10;
            int row = 0;
            while (row < rowCount) {
                height += rowHeights[row];
                ++row;
            }
            return new Dimension(width, height);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }
    }

    public class CellCoordinate {
        protected int mColumnIndex;
        protected Object mColumnLabel;
        protected int mRowIndex;
        protected Object mRowLabel;

        public CellCoordinate(int columnIndex, int rowIndex) {
            this.mColumnIndex = columnIndex;
            this.mRowIndex = rowIndex;
        }

        public CellCoordinate(int columnIndex, Object columnLabel, int rowIndex, Object rowLabel) {
            this.mColumnIndex = columnIndex;
            this.mColumnLabel = columnLabel;
            this.mRowIndex = rowIndex;
            this.mRowLabel = rowLabel;
        }

        public int getColumnIndex() {
            return this.mColumnIndex;
        }

        public Object getColumnLabel() {
            return this.mColumnLabel;
        }

        public int getRowIndex() {
            return this.mRowIndex;
        }

        public Object getRowLabel() {
            return this.mRowLabel;
        }

        public int hashCode() {
            return this.mColumnIndex ^ this.mRowIndex;
        }

        public boolean equals(CellCoordinate o) {
            return this.mColumnIndex == o.mColumnIndex && this.mRowIndex == o.mRowIndex;
        }

        public boolean equals(Object o) {
            return this.equals((CellCoordinate)o);
        }
    }

    protected class Column {
        protected String mLabel;
        protected int mWidth;

        public Column(Object label) {
            if (label == null) {
                throw new NullPointerException("argument 'label'");
            }
            this.mLabel = label.toString();
        }

        public String getLabel() {
            return this.mLabel;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public void setWidth(int width) {
            this.mWidth = width;
        }
    }

    protected class ColumnHeader
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected JLabel[] mLabels;

        public ColumnHeader() {
            this.setLayout(null);
            this.setBackground(Color.WHITE);
            this.createLabels();
        }

        protected void createLabels() {
            this.removeAll();
            this.mLabels = new JLabel[CalendarPanel.this.mColumnLabels.size()];
            int col = 0;
            while (col < CalendarPanel.this.mColumnLabels.size()) {
                Column column = (Column)CalendarPanel.this.mColumnLabels.get(col);
                JLabel label = new JLabel(column.getLabel());
                label.setBackground(Color.WHITE);
                label.setVerticalAlignment(0);
                label.setHorizontalAlignment(0);
                this.mLabels[col] = label;
                this.add(label);
                ++col;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int height = 0;
            if (this.mLabels.length > 0) {
                JLabel label = this.mLabels[0];
                height = label.getPreferredSize().height;
            }
            return new Dimension(CalendarPanel.this.getPreferredSize().width, height);
        }
    }

    protected class RowHeader
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected TimeLabel[] mLabels;

        public RowHeader() {
            this.setLayout(null);
            this.setBackground(Color.WHITE);
            this.createLabels();
        }

        protected void createLabels() {
            this.removeAll();
            this.mLabels = new TimeLabel[CalendarPanel.this.mRowLabels.size()];
            int row = 0;
            while (row < CalendarPanel.this.mRowLabels.size()) {
                TimeLabel label;
                this.mLabels[row] = label = new TimeLabel(CalendarPanel.this.mRowRange);
                this.add(label);
                ++row;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            TimeLabel label = this.mLabels[0];
            int width = label != null ? label.getPreferredSize().width : 0;
            return new Dimension(width, CalendarPanel.this.getPreferredSize().height);
        }
    }
}

