// $Id: IRadarServices.java,v 3.7 2007/07/06 03:49:46 jordan Exp $

package edu.cmu.cs.radar.integ;

import java.util.Properties;
import java.awt.Frame;

/**
 * This interface encapsulates what various parts of Radar will call.
 * In other words, it's how the rest of Radar looks to any individual
 * component.
 * 
 */
public interface IRadarServices extends IRadar,
  IAMRequires, IBARequires, ICMRadarRequires, IConsoleRequires,
  IFormsRequires, IVIORequires, ISTMRequires
{
    public Properties getProps(); 
    // get all the properties used to configure Radar.

    public String getUser(); 
    // get username

    public String getRoot(); 
    // get a string specifying the path to the root of the writeable
    // Radar directory structure.

    public void iconify(Frame x);
    public void deiconify(Frame x);
}
