// $Id: ICMRadarProvides.java,v 3.4 2007/04/30 16:50:55 jordan Exp $

package edu.cmu.cs.radar.integ;

import java.util.*;

public interface ICMRadarProvides extends IAnythingProvides {

    public class EventInformation {

	public static class Preference {
	    private String _name;
	    private ArrayList _intervals;
	    public Preference(String name) {
		_name = name;
		_intervals = new ArrayList();
	    }
	    public void AddInterval(double start, double stop) {
		_intervals.add(new Interval(start, stop));
	    }
	    public int getIntervalCount() {
		return _intervals.size();
	    }
	    public String getName() {
		return _name;
	    }
	    public double getIntervalStart(int index) {
		Interval interval = (Interval)_intervals.get(index);
		return interval.start;
	    }
	    public double getIntervalStop(int index) {
		Interval interval = (Interval)_intervals.get(index);
		return interval.stop;
	    }
	    public String toString() {
		StringBuffer s = new StringBuffer(_name + ":");
		for(Iterator i=_intervals.iterator(); i.hasNext(); ) {
		    s.append(i.next().toString());
		}
		return s.toString();
	    }
	}

	private static class Interval {
	    public double start;
	    public double stop;
	    public Interval(double start, double stop) {
		this.start = start;
		this.stop = stop;
	    }
	    public String toString() { return start + " ~ " + stop; }
	}

	private String _userId; //3.07
	private String _eventId; //3.07
	private String _roomId;
	private Preference _startPref;
	private long _durationPref; 
	private ArrayList _additionalPreferences;
	private float _expectedGain;

	// current API
	public EventInformation(String userId, String eventId, 
				Preference startPref, long durationPref, float expectedGain) { 
	    _userId = userId;
	    _eventId = eventId;
	    _startPref = startPref;
	    _durationPref = durationPref;
	    _expectedGain = expectedGain;
	    _additionalPreferences = new ArrayList();
	}

	// new %st-cm%, EventInformation that has a specific roomId
	public EventInformation(String userId, String eventId, String roomId, 
				Preference startPref, long durationPref, float expectedGain) { 
	    _userId = userId;
	    _eventId = eventId;
	    _roomId = roomId; 
	    _startPref = startPref;
	    _durationPref = durationPref;
	    _expectedGain = expectedGain;
	    _additionalPreferences = new ArrayList();
	}

	public String getUserId() { //3.07
	    return _userId;
	}
	public String getEventId() { //3.07
	    return _eventId;
	}

	public String getRoomId() { return _roomId; } // %st-cm%
	
	public Preference getStartPref() {
	    return _startPref;
	}
	public long getDurationPref() {
	    return _durationPref;
	}
	public float getExpectedGain() {
	    return _expectedGain;
	}
	public void addAdditionalPref(Preference pref) {
	    _additionalPreferences.add(pref);
	}
	public int getAdditionalPrefCount() {
	    return _additionalPreferences.size();
	}
	public Preference getAdditionalPref(int index) {
	    return (Preference)_additionalPreferences.get(index);
	}
	public ArrayList getAdditionalPrefs() { //3.07
	    return _additionalPreferences;
	}
	public String toString() {
	    StringBuffer s = new StringBuffer();
	    s.append(_eventId + ":" + _startPref + "," + _durationPref);
	    return s.toString();
	}
    }

    // please find a room for the associated spec.
    // return is asynchronous.
    public void requestRoom(EventInformation ei);

    // current bumping penalty %st-cm%
    public double getBumpingPenalty(); 

    // %st-cm%
    /* trigger cmradar to send probability updates to stm
     */
    public void sendProbabilities();
}
