package SpaceTime.DataModel.VendorOrders;


/**
* SpaceTime/DataModel/VendorOrders/VendorsManagerOperations.java .
* Generated by the IDL-to-Java compiler (portable), version "3.2"
* from SpaceTime/DataModel/VendorOrders/VendorsManager.idl
* Thursday, April 26, 2007 1:20:29 AM EDT
*/


/**
	The controller class for managing vendors indormation. Provides lookup and
	modification functionality.
	Passed by reference.
	*/
public interface VendorsManagerOperations 
{

  /// Get all vendors
  String[] GetAllVendorIds () throws Ch.Elca.Iiop.GenericUserException;
  String[] GetAllResourceItemIds () throws Ch.Elca.Iiop.GenericUserException;

  /// Returns cost function
  SpaceTime.DataModel.CertainPlf GetCostFunction () throws Ch.Elca.Iiop.GenericUserException;

  //@ADD
  void SetCostFunction (SpaceTime.DataModel.CertainPlf func) throws Ch.Elca.Iiop.GenericUserException;

  /// Cost function weight
  double GetCostFunctionWeight () throws Ch.Elca.Iiop.GenericUserException;

  /// @ADD Cost function priority
  int GetCostFunctionPriority () throws Ch.Elca.Iiop.GenericUserException;
  void SetCostFunctionPriority (int priority) throws Ch.Elca.Iiop.GenericUserException;

  /// Complete flag for vendors list
  boolean IsVendorListComplete () throws Ch.Elca.Iiop.GenericUserException;

  /// Add new vendor returns id
  String AddVendor (String id, String label, String[] resources, String[] costs) throws Ch.Elca.Iiop.GenericUserException;

  /// Find vendor by ID
  SpaceTime.DataModel.VendorOrders.Vendor GetVendor (String id) throws Ch.Elca.Iiop.GenericUserException;

  /// Find vendor by
  SpaceTime.DataModel.VendorOrders.Vendor GetVendorByStrippedName (String name) throws Ch.Elca.Iiop.GenericUserException;

  /// Removes vendor with specified ID
  void RemoveVendorById (String id) throws Ch.Elca.Iiop.GenericUserException;

  /// Removes vendor with specified label
  void RemoveVendorByStrippedName (String name) throws Ch.Elca.Iiop.GenericUserException;

  /// Find item specification by item ID
  SpaceTime.DataModel.VendorOrders.ResourceItem GetResourceItem (String id) throws Ch.Elca.Iiop.GenericUserException;

  /// Get lowest cost for item with specified ID
  String GetLowestCost (String itemId) throws Ch.Elca.Iiop.GenericUserException;

  /// Set lowest cost for item with specified ID
  boolean SetLowestCost (String itemId, String cost) throws Ch.Elca.Iiop.GenericUserException;

  /// The count of resource functions
  int ResourceFunctionCount () throws Ch.Elca.Iiop.GenericUserException;
  void AddResourceFunction (SpaceTime.DataModel.VendorOrders.ResourceFunction fn) throws Ch.Elca.Iiop.GenericUserException;

  /// @ADD
  void ClearResourceFunctions () throws Ch.Elca.Iiop.GenericUserException;

  /// Resource function at specified index
  SpaceTime.DataModel.VendorOrders.ResourceFunction ResourceFunctionAt (int index) throws Ch.Elca.Iiop.GenericUserException;

  /// Get all items given service name
  String[] GetItemsForService (String service) throws Ch.Elca.Iiop.GenericUserException;

  /**
  		return cost/Unknown price/Doesn't sell/Unknown if they sell or not
  		*/
  String GetCost (String vendorId, String itemId) throws Ch.Elca.Iiop.GenericUserException;
} // interface VendorsManagerOperations
