package SpaceTime.DataModel;

import Ch.Elca.Iiop.GenericUserException;

public class UncertaintyDistributionDataImpl extends
		UncertaintyDistributionData {

	public float GetAverage(){
		if (_items.length == 0) {
			return 0;
		}
		try {
			float sum = 0;
			for (int i=0; i<_items.length; i++){
				float high = 0;
				float low = 0;
				high = Float.parseFloat(_items[i].High());
				low = Float.parseFloat(_items[i].Low());
				sum += _items[i].Uncertainty()*(low+high)/2;
			}
			return sum;
		} catch (Exception e) {
			return 0;
		}	
	}

	public Item GetItem(int index){
		return _items[index];
	}

	public float GetMax(){
		if (_items.length == 0) {
			return 0;
		}
		float high = 0;
		try {
			high = Float.parseFloat(_items[0].High());
			for (int i=0; i<_items.length; i++){
				high = Math.max(high, Float.parseFloat(_items[i].High()));
			}
		} catch (Exception e) {
			return 0;
		}		

		return high;
	}

	public float GetMin(){
		if (_items.length == 0) {
			return 0;
		}
		float low = 0;
		try {
			low = Float.parseFloat(_items[0].Low());
			for (int i=0; i<_items.length; i++){
				low = Math.min(low, Float.parseFloat(_items[i].Low()));
			}
		} catch (Exception e) {
			return 0;
		}		

		return low;
	}

	public String GetRangeString(){
		if (_items.length == 0) {
			return "";
		}
		float high = 0;
		float low = 0;
	
		if ((_items[0].Low() == null) || (_items[0].High() == null)) {
			String nominalList = "";
			for (int i=0; i<_items.length; i++){
				if (_items[i].Nominal() != null) {
					nominalList += _items[i].Nominal() + ", ";
				}
			}
			if (nominalList.length() > 1) {
				return nominalList.substring(0, nominalList.length()-2);
			} else {
				return "uncertain";
			}
		}
			
		try {
			if (_items.length > 0) {
				
				high = Float.parseFloat(_items[0].High());
				low = Float.parseFloat(_items[0].Low());
			}

			for (int i=0; i<_items.length; i++){
				high = Math.max(Float.parseFloat(_items[i].High()), high);
				low = Math.min(Float.parseFloat(_items[i].Low()), low);
			}
			return "" + (int)low + " - " + (int)high;
		} catch (Exception e) {
			return "";
		}		
	}

	public boolean IsSingular(){
		if (Size()==1){
			Item singleItem = GetItem(0);
			if(singleItem.High().equals(singleItem.Low()) && singleItem.Uncertainty() ==1.0){
				return true;
			}
		}
		return false;
	}

	public int Size(){
		if(_items!=null){
			return _items.length;
		}
		else{
			return 0;
		}
	}

}
