/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.RequestListModel;
import edu.cmu.cs.radar.rhai.spacetime.SelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SelectionState
implements SelectionListener {
    private SelectionManager _selectionManager;
    private RequestListModel _requestList;
    private State _state;

    public SelectionState(SelectionManager selectionManager, RequestListModel requestList) {
        this._selectionManager = selectionManager;
        this._requestList = requestList;
        this._state = new State();
        this._selectionManager.addListener(this);
        this._requestList.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                SelectionState.this.broadcastSelectionState();
            }

            public void intervalAdded(ListDataEvent e) {
                SelectionState.this.broadcastSelectionState();
            }

            public void intervalRemoved(ListDataEvent e) {
                SelectionState.this.broadcastSelectionState();
            }
        });
    }

    public void clear() {
        this._state = new State();
    }

    public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
        this._state._lastTypeSelected = type;
        switch (type) {
            case 1: {
                this._state._lastSelectedEventId = selected ? selection.toString() : null;
                break;
            }
            case 2: {
                this._state._lastSelectedRoomId = selected ? selection.toString() : null;
            }
        }
    }

    public void setViewState(Object sender, Object selection, boolean show) {
    }

    public void broadcastSelectionState() {
        State oldState = this._state;
        this._state = new State();
        switch (oldState._lastTypeSelected) {
            case 0: {
                this._selectionManager.notifySelection(this, null, 2, false, true, false);
                this._selectionManager.notifySelection(this, null, 1, false, true, false);
                break;
            }
            case 1: {
                this.broadcastLastSelectedRoom(oldState);
                this.broadcastLastSelectedEvent(oldState);
                break;
            }
            case 2: {
                this.broadcastLastSelectedEvent(oldState);
                this.broadcastLastSelectedRoom(oldState);
            }
        }
    }

    private void broadcastLastSelectedRoom(State state) {
        if (state._lastSelectedRoomId != null) {
            List rooms = this._requestList.getDataAdapter().getRooms();
            int i = 0;
            while (i < rooms.size()) {
                SpaceTimeNode room = (SpaceTimeNode)rooms.get(i);
                if (state._lastSelectedRoomId.equals(room.getName())) {
                    this._selectionManager.notifySelection(this, room.getName(), 2, true, true, false);
                    return;
                }
                ++i;
            }
        }
        this._selectionManager.notifySelection(this, null, 2, false, true, false);
    }

    private void broadcastLastSelectedEvent(State state) {
        if (state._lastSelectedEventId != null) {
            List requests = this._requestList.getDataAdapter().getRequests();
            int i = 0;
            while (i < requests.size()) {
                SpaceTimeNode request = (SpaceTimeNode)requests.get(i);
                if (state._lastSelectedEventId.equals(request.getName())) {
                    this._selectionManager.notifySelection(this, request.getName(), 1, true, true, false);
                    return;
                }
                ++i;
            }
        }
        this._selectionManager.notifySelection(this, null, 1, false, true, false);
    }

    private class State {
        private int _lastTypeSelected = 0;
        private String _lastSelectedRoomId = null;
        private String _lastSelectedEventId = null;
    }
}

