/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.calendar.CalendarObject;
import edu.cmu.cs.radar.rhai.calendar.CalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.CalendarPanel;
import edu.cmu.cs.radar.rhai.calendar.FilteredCalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.MemoryCalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.Time;
import edu.cmu.cs.radar.rhai.spacetime.Allocation;
import edu.cmu.cs.radar.rhai.spacetime.RequestListModel;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import java.util.List;

public class RoomsPanel
extends CalendarPanel {
    private static final long serialVersionUID = 0L;

    public RoomsPanel(MemoryCalendarObjectCollection calObjCol, RequestListModel listModel, Time.Range range) {
        super(calObjCol, range);
        SpaceTimeDataAdapter dataAdapter = listModel.getDataAdapter();
        List roomList = dataAdapter.getRooms();
        int i = 0;
        while (i < roomList.size()) {
            SpaceTimeNode roomNode = (SpaceTimeNode)roomList.get(i);
            this.addColumn(roomNode.getName());
            ++i;
        }
    }

    public static RoomsPanel create(RequestListModel listModel, Time.Range range) {
        MemoryCalendarObjectCollection calObjCol = new MemoryCalendarObjectCollection();
        SpaceTimeDataAdapter dataAdapter = listModel.getDataAdapter();
        List requestList = dataAdapter.getRequests();
        int i = 0;
        while (i < requestList.size()) {
            SpaceTimeRequestNode requestNode = (SpaceTimeRequestNode)requestList.get(i);
            Allocation allocation = requestNode.getAllocation();
            ++i;
        }
        RoomsPanel roomsPanel = new RoomsPanel(calObjCol, listModel, range);
        return roomsPanel;
    }

    protected CalendarObjectCollection getCellCalendarObjectCollection(CalendarPanel.CellCoordinate coord) {
        RoomFilter filter = new RoomFilter(coord.getColumnLabel());
        FilteredCalendarObjectCollection filteredCalObjCol = new FilteredCalendarObjectCollection(filter);
        filteredCalObjCol.connectToSource(this.mCalendarObjectCollection);
        return filteredCalObjCol;
    }

    public static class RoomFilter
    implements FilteredCalendarObjectCollection.Filter {
        public Object mRoom;

        public RoomFilter(Object room) {
            if (room == null) {
                throw new NullPointerException("argument 'room'");
            }
            this.mRoom = room;
        }

        public boolean include(CalendarObject calObj) {
            if (calObj instanceof Allocation) {
                Allocation alloc = (Allocation)((Object)calObj);
                return alloc.getRoom().equals(this.mRoom.toString());
            }
            return false;
        }
    }
}

