/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.Change;
import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.AvailabilityPanel;
import edu.cmu.cs.radar.rhai.spacetime.DetailsPanel;
import edu.cmu.cs.radar.rhai.spacetime.EditRoomAction;
import edu.cmu.cs.radar.rhai.spacetime.RoomNode;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class RoomDetailsPanel
extends DetailsPanel {
    private static final long serialVersionUID = 1L;
    private static final String CATEGORY_AVAILABILITY = "Availability";
    private DefaultMutableTreeNode _availabilityTreeNode = new DefaultMutableTreeNode("Availability");

    public RoomDetailsPanel(SpaceTimeDataAdapter dataAdapter, SelectionManager selectionManager) {
        super(dataAdapter, selectionManager, new EditRoomAction());
    }

    protected DefaultTreeCellRenderer getTreeCellRenderer() {
        return new AvailabilityTreeCellRenderer();
    }

    protected void augmentDetailsTree(DefaultMutableTreeNode rootTreeNode) {
        this.updateAvailabilityTreeNode();
        rootTreeNode.add(this._availabilityTreeNode);
    }

    public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
        if (type == 2 && selected) {
            SpaceTimeNode roomNode = this._dataAdapter.getNodeById(selection.toString());
            this.setNode(roomNode);
        }
    }

    private void updateAvailabilityTreeNode() {
        this._availabilityTreeNode.removeAllChildren();
        if (!RoomNode.markedUsable(this._node)) {
            this._availabilityTreeNode.add(new DefaultMutableTreeNode("Not available for use"));
        } else if (!RoomNode.isAvailable(this._node)) {
            this._availabilityTreeNode.add(new DefaultMutableTreeNode("No available times"));
        } else {
            this._availabilityTreeNode.add(new DefaultMutableTreeNode(this._node, false));
        }
    }

    public void nodeChanged(String nodeName, NodeChangeSummary changes) {
        super.nodeChanged(nodeName, changes);
        if (this._node == null || !this._node.getName().equals(nodeName)) {
            return;
        }
        if (changes != null && changes._propertiesChanged != null) {
            int propertiesChangedIndex = 0;
            while (propertiesChangedIndex < changes._propertiesChanged.length) {
                Change change = changes._propertiesChanged[propertiesChangedIndex];
                String propertyName = change._sourceId;
                if (propertyName.equals("resourceLimit")) {
                    this.updateAvailabilityTreeNode();
                    this._treeModel.nodeStructureChanged(this._availabilityTreeNode);
                }
                ++propertiesChangedIndex;
            }
        }
    }

    private static class AvailabilityTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private AvailabilityPanel _availabilityPanel = new AvailabilityPanel();

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof SpaceTimeNode) {
                SpaceTimeNode roomNode = (SpaceTimeNode)userObject;
                this._availabilityPanel.setRoom(roomNode);
                return this._availabilityPanel;
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

