/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDuration;
import edu.cmu.cs.radar.stp.cachingdatamodel.LinearFunctionData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class LinearFunctionChart
extends Component {
    private static final long serialVersionUID = 0L;
    public static final int UNIT_INT = 0;
    public static final int UNIT_TIME = 1;
    public static final int UNIT_DURATION = 2;
    private LinearFunctionData _data;
    private int _unit;
    private double _minX;
    private double _minY;
    private double _maxX;
    private double _maxY;
    private double _dataMinX;
    private double _dataMaxX;
    private double _dataMinY;
    private double _dataMaxY;
    private double _currentValue;
    private boolean _enableCurrentValue;
    private static float Y_FLOOR = -5.0f;

    public LinearFunctionChart(LinearFunctionData data) {
        this._data = data;
        this._currentValue = 0.0;
        this._enableCurrentValue = false;
        this.setSize(200, 80);
        this._unit = 0;
        int dataPoints = this._data.size();
        if (this._data == null || this._data.size() == 0) {
            return;
        }
        this._dataMinX = this._dataMaxX = this._data.getX(0);
        int i = 0;
        while (i < dataPoints) {
            if (this._data.getY(i) >= (double)Y_FLOOR) {
                this._dataMinY = this._dataMaxY = this._data.getY(i);
                break;
            }
            if (i == dataPoints - 1) {
                this._dataMaxY = 0.0;
                this._dataMinY = 0.0;
            }
            ++i;
        }
        this._dataMaxY = 1.0;
        i = 0;
        while (i < this._data.size()) {
            double x = this._data.getX(i);
            double y = this._data.getY(i);
            this._dataMinX = Math.min(this._dataMinX, x);
            this._dataMaxX = Math.max(this._dataMaxX, x);
            if (y >= (double)Y_FLOOR) {
                this._dataMinY = Math.min(this._dataMinY, y);
            }
            ++i;
        }
        this.autoScale();
    }

    private void autoScale() {
        if (this._data == null || this._data.size() == 0) {
            return;
        }
        this._minX = this._dataMinX;
        this._minY = this._dataMinY;
        this._maxX = this._dataMaxX;
        this._maxY = this._dataMaxY;
        if (this._enableCurrentValue) {
            this._minX = Math.min(this._minX, this._currentValue);
            this._maxX = Math.max(this._maxX, this._currentValue);
        }
        if (this._minX == this._maxX) {
            this._minX = 0.0;
        }
        if (this._minY == this._maxY) {
            this._minY = -1.0;
            this._maxY = 1.0;
        }
        double xPadding = (this._maxX - this._minX) * (double)0.1f;
        double yPadding = (this._maxY - this._minY) * (double)0.1f;
        this._minX -= xPadding;
        this._maxX += xPadding;
        this._minY -= yPadding;
        this._maxY += yPadding;
    }

    public void setUnit(int unit) {
        this._unit = unit;
    }

    public void setCurrentValue(float value) {
        this._currentValue = value;
        this._enableCurrentValue = true;
        this.autoScale();
    }

    public void enableCurrentValue(boolean enable) {
        boolean oldValue = this._enableCurrentValue;
        this._enableCurrentValue = enable;
        if (oldValue != this._enableCurrentValue) {
            this.autoScale();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(new Font("Sans Serif", 0, 8));
        this.paintGrid(g2);
        this.paintChart(g2);
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private void paintGrid(Graphics2D g2) {
        String labelString;
        Point p1;
        Point p12;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int width = this.getWidth() - 1;
        int height = this.getHeight() - 1;
        Color backColor = new Color(230, 230, 240);
        g2.setColor(backColor);
        g2.fillRect(0, 0, width, height - 1);
        Point origin = this.pointToScreen(0.0f, 0.0f);
        double tickIntervalX = this._unit == 1 || this._unit == 2 ? this.findInterval(this._minX, this._maxX, 30) : this.findInterval(this._minX, this._maxX, 10);
        double tickIntervalY = this.findInterval(this._minY, this._maxY, 10);
        if (this._unit == 1) {
            tickIntervalX /= 2.0;
        }
        int tickMinX = (int)(this._minX / tickIntervalX);
        int tickMaxX = (int)(this._maxX / tickIntervalX);
        int tickMinY = (int)(this._minY / tickIntervalY);
        int tickMaxY = (int)(this._maxY / tickIntervalY);
        int i = tickMinX;
        while (i <= tickMaxX) {
            g2.setColor(Color.white);
            p12 = this.pointToScreen((float)((double)i * tickIntervalX), 0.0f);
            g2.drawLine(p12.x, 0, p12.x, height);
            ++i;
        }
        i = tickMinY;
        while (i <= tickMaxY) {
            g2.setColor(Color.white);
            p12 = this.pointToScreen(0.0f, (float)((double)i * tickIntervalY));
            g2.drawLine(0, p12.y, width, p12.y);
            ++i;
        }
        g2.setColor(Color.gray);
        g2.drawLine(0, origin.y, width, origin.y);
        g2.drawLine(origin.x, 0, origin.x, height);
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        int i2 = tickMinX;
        while (i2 <= tickMaxX) {
            if (i2 != 0) {
                p1 = this.pointToScreen((float)((double)i2 * tickIntervalX), 0.0f);
                g2.setColor(Color.darkGray);
                g2.drawLine(p1.x, origin.y - 3, p1.x, origin.y + 4);
                int x = 0;
                while ((double)x < tickIntervalX) {
                    Point p2 = this.pointToScreen((float)((double)i2 * tickIntervalX + (double)x), 0.0f);
                    if (p2.x <= width) {
                        g2.drawLine(p2.x, origin.y - 2, p2.x, origin.y + 2);
                    }
                    x += 3600;
                }
                labelString = "";
                if (this._unit == 1) {
                    SpaceTimeDate date = new SpaceTimeDate((int)((double)i2 * tickIntervalX));
                    labelString = date.toString("M/dd\nHH:mm");
                } else if (this._unit == 2) {
                    SpaceTimeDuration duration = new SpaceTimeDuration((int)((double)i2 * tickIntervalX));
                    labelString = duration.toString();
                } else {
                    labelString = decimalFormat.format(new Float((double)i2 * tickIntervalX));
                }
                String[] labelStringLines = labelString.split("\n");
                int lineIndex = 0;
                while (lineIndex < labelStringLines.length) {
                    String line = labelStringLines[lineIndex];
                    Rectangle2D stringBounds = g2.getFont().getStringBounds(line, g2.getFontRenderContext());
                    int labelYPos = Math.min(height - 2, origin.y - 4);
                    if ((double)origin.y < stringBounds.getHeight() + 2.0) {
                        labelYPos = (int)Math.max(stringBounds.getHeight() + 2.0, (double)origin.y + stringBounds.getHeight() + 2.0);
                    }
                    g2.drawString(line, (int)((double)p1.x - stringBounds.getWidth() / 2.0), (int)((double)labelYPos + (double)lineIndex * (stringBounds.getHeight() + 6.0)));
                    ++lineIndex;
                }
            }
            ++i2;
        }
        i2 = tickMinY;
        while (i2 <= tickMaxY) {
            if (i2 != 0) {
                p1 = this.pointToScreen(0.0f, (float)((double)i2 * tickIntervalY));
                g2.setColor(Color.darkGray);
                g2.drawLine(origin.x - 2, p1.y, origin.x + 2, p1.y);
                labelString = decimalFormat.format(new Float((double)i2 * tickIntervalY));
                Rectangle2D stringBounds = g2.getFont().getStringBounds(labelString, g2.getFontRenderContext());
                int labelXPos = (int)Math.min((double)width - stringBounds.getWidth(), (double)(origin.x + 4));
                if (origin.x < 0) {
                    labelXPos = Math.max(0, origin.x + 4);
                }
                g2.drawString(labelString, labelXPos, (int)((double)p1.y + stringBounds.getHeight() / 2.0) - 1);
            }
            ++i2;
        }
    }

    private void paintChart(Graphics2D g2) {
        boolean isPointValid;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.blue);
        int dataSize = this._data.size();
        if (dataSize < 2) {
            return;
        }
        Point initialPoint = this.pointToScreen((float)this._data.getX(0), (float)this._data.getY(0));
        Point finalPoint = this.pointToScreen((float)this._data.getX(dataSize - 1), (float)this._data.getY(dataSize - 1));
        boolean bl = isPointValid = this._data.getY(0) >= (double)Y_FLOOR;
        if (isPointValid) {
            g2.drawLine(0, initialPoint.y, initialPoint.x, initialPoint.y);
        } else {
            this.paintInvalidHatch(g2, new Rectangle(0, 0, initialPoint.x, this.getHeight() - 1));
        }
        int i = 1;
        while (i < dataSize) {
            Point p1 = this.pointToScreen((float)this._data.getX(i - 1), (float)this._data.getY(i - 1));
            Point p2 = this.pointToScreen((float)this._data.getX(i), (float)this._data.getY(i));
            boolean isPrevPointValid = isPointValid;
            boolean bl2 = isPointValid = this._data.getY(i) >= (double)Y_FLOOR;
            if (isPointValid && isPrevPointValid) {
                g2.drawLine(p1.x, p1.y, p2.x, p2.y);
            } else {
                this.paintInvalidHatch(g2, new Rectangle(p1.x, 0, p2.x - p1.x, this.getHeight() - 1));
                if (i == 1 && dataSize == 3) {
                    g2.fillRect(p2.x - 1, p2.y - 1, 3, 3);
                }
            }
            ++i;
        }
        if (isPointValid) {
            g2.drawLine(finalPoint.x, finalPoint.y, this.getWidth() - 1, finalPoint.y);
        } else {
            this.paintInvalidHatch(g2, new Rectangle(finalPoint.x, 0, this.getWidth() - finalPoint.x - 1, this.getHeight() - 1));
        }
        if (this._enableCurrentValue) {
            Point currentValuePoint = this.pointToScreen((float)this._currentValue, 0.0f);
            g2.setColor(new Color(0, 0, 255, 70));
            g2.fillRect(currentValuePoint.x - 2, 0, 5, this.getHeight() - 1);
            g2.setColor(new Color(0, 0, 255));
            g2.drawLine(currentValuePoint.x, 0, currentValuePoint.x, this.getHeight() - 1);
        }
    }

    private void paintInvalidHatch(Graphics2D g2, Rectangle rect) {
        Color oldColor = g2.getColor();
        g2.setColor(new Color(255, 0, 0, 30));
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2.setColor(oldColor);
    }

    private Point pointToScreen(float x, float y) {
        if (this._minX == this._maxX || this._minY == this._maxY) {
            return new Point(0, 0);
        }
        return new Point((int)(((double)x - this._minX) / (this._maxX - this._minX) * (double)this.getWidth()), this.getHeight() - (int)(((double)y - this._minY) / (this._maxY - this._minY) * (double)this.getHeight()));
    }

    private double findInterval(double min, double max, int base) {
        double range = max - min;
        double magnitudeD = Math.log(range) / Math.log(base);
        int magnitude = (int)magnitudeD;
        if (base == 30) {
            if (magnitudeD > 4.0) {
                return range / 3.0;
            }
            if (magnitudeD > 3.7) {
                return 57600.0;
            }
            if (magnitudeD > 3.4) {
                return 28800.0;
            }
            if (magnitudeD > 3.2) {
                return 14400.0;
            }
            if (magnitudeD > 3.0) {
                return 7200.0;
            }
            if (magnitudeD > 2.8) {
                return 3600.0;
            }
            if (magnitudeD > 2.65) {
                return 1800.0;
            }
            return 900.0;
        }
        double adjustedRange = range * Math.pow(base, -magnitude);
        int interval = base / 2;
        if (adjustedRange > 5.0) {
            interval = base;
        }
        return (double)interval * Math.pow(base, magnitude - 1);
    }
}

