/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.Change;
import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.JTree142;
import edu.cmu.cs.radar.rhai.spacetime.NoHorizontalScrollViewport;
import edu.cmu.cs.radar.rhai.spacetime.SelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.rhai.spacetime.TitlePane;
import edu.cmu.cs.radar.stp.cachingdatamodel.NodeChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class DetailsPanel
extends JPanel
implements SelectionListener,
NodeChangeListener {
    protected static Icon __minusIcon;
    protected static Icon __plusIcon;
    protected static final String CATEGORY_OTHER = "Other";
    protected SpaceTimeDataAdapter _dataAdapter;
    protected SpaceTimeNode _node;
    protected TitlePane _titlePane;
    protected JTree _detailsTree;
    protected DefaultTreeModel _treeModel;
    protected EditNodeAction _editAction;
    protected JButton _editButton;
    protected HashMap _propertyToTreeNodeMap;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.cmu.cs.radar.rhai.spacetime.RoomDetailsPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        __minusIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/minus.png"));
        __plusIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/plus.png"));
    }

    public DetailsPanel(SpaceTimeDataAdapter dataAdapter, SelectionManager selectionManager, EditNodeAction editAction) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this._dataAdapter = dataAdapter;
        this._editAction = editAction;
        this._detailsTree = new JTree142(new DefaultTreeModel(null));
        this._detailsTree.setRootVisible(false);
        this._detailsTree.setEditable(false);
        this._detailsTree.setToggleClickCount(1);
        this._detailsTree.setRowHeight(-1);
        this._detailsTree.setSelectionModel(null);
        DefaultTreeCellRenderer renderer = this.getTreeCellRenderer();
        renderer.setClosedIcon(__plusIcon);
        renderer.setOpenIcon(__minusIcon);
        renderer.setLeafIcon(null);
        renderer.setBackground(this.getBackground());
        renderer.setBorderSelectionColor(null);
        renderer.setBackgroundSelectionColor(new Color(55, 104, 197));
        renderer.setTextSelectionColor(Color.white);
        this._detailsTree.setCellRenderer(renderer);
        this._treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this._detailsTree.setModel(this._treeModel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewport(new NoHorizontalScrollViewport());
        scrollPane.setViewportView(this._detailsTree);
        scrollPane.setBorder(null);
        scrollPane.setBackground(this.getBackground());
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollPane, "Center");
        this._editButton = new JButton(editAction);
        this._editButton.setHorizontalAlignment(2);
        this.add((Component)this._editButton, "South");
        this._propertyToTreeNodeMap = new HashMap();
        selectionManager.addListener(this);
    }

    protected DefaultTreeCellRenderer getTreeCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected abstract void augmentDetailsTree(DefaultMutableTreeNode var1);

    public void setTitlePane(TitlePane titlePane) {
        this._titlePane = titlePane;
        this.update();
    }

    public void setNode(SpaceTimeNode node) {
        if (this._node != null) {
            this._node.removeChangeListener(this);
        }
        this._node = node;
        if (this._node != null) {
            this._node.addChangeListener(this);
        }
        this.update();
    }

    public void setViewState(Object sender, Object selection, boolean show) {
    }

    private void update() {
        if (this._titlePane == null) {
            return;
        }
        if (this._node == null) {
            this._titlePane.setTitle("Details");
            this._detailsTree.setModel(new DefaultTreeModel(null));
            this._editAction.setNode(null);
            this._editButton.setVisible(false);
        } else {
            this._titlePane.setTitle("Details for " + this._node.getDisplayName());
            this.buildTree();
            this._editAction.setNode(this._node);
            this._editButton.setVisible(true);
        }
    }

    public static HashMap collectCategories(SpaceTimeNode node) {
        HashMap categories = new HashMap();
        List propertyNames = node.getPropertyNames();
        int i = 0;
        while (i < propertyNames.size()) {
            String propertyName = (String)propertyNames.get(i);
            SpaceTimeProperty property = node.getProperty(propertyName);
            if (property.isDisplayed()) {
                String category = property.getCategory();
                if (category == null) {
                    category = CATEGORY_OTHER;
                }
                if (!categories.containsKey(category)) {
                    categories.put(category, new ArrayList());
                }
                ArrayList properties = (ArrayList)categories.get(category);
                properties.add(property);
            }
            ++i;
        }
        return categories;
    }

    private void buildTree() {
        this._propertyToTreeNodeMap.clear();
        HashMap categories = DetailsPanel.collectCategories(this._node);
        DefaultMutableTreeNode rootTreeNode = new DefaultMutableTreeNode(this._node.getDisplayName());
        ArrayList categoryLabels = new ArrayList(categories.keySet());
        Collections.sort(categoryLabels);
        int i = 0;
        while (i < categoryLabels.size()) {
            String categoryLabel = (String)categoryLabels.get(i);
            ArrayList propertyGroup = (ArrayList)categories.get(categoryLabel);
            if (propertyGroup.size() > 0) {
                Collections.sort(propertyGroup, SpaceTimeProperty.sLabelAndDisplayStringComparator);
                DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(categoryLabel);
                Iterator propertyIterator = propertyGroup.iterator();
                while (propertyIterator.hasNext()) {
                    SpaceTimeProperty property = (SpaceTimeProperty)propertyIterator.next();
                    DefaultMutableTreeNode propertyTreeNode = new DefaultMutableTreeNode(property.getDisplayLabelAndValueString(), false);
                    categoryNode.add(propertyTreeNode);
                    this._propertyToTreeNodeMap.put(property.getPropertyType(), propertyTreeNode);
                }
                rootTreeNode.add(categoryNode);
            }
            ++i;
        }
        this.augmentDetailsTree(rootTreeNode);
        this._treeModel.setRoot(rootTreeNode);
        this._detailsTree.setModel(this._treeModel);
        i = 0;
        while (i < rootTreeNode.getChildCount()) {
            TreePath path = new TreePath(((DefaultMutableTreeNode)rootTreeNode.getChildAt(i)).getPath());
            this._detailsTree.expandPath(path);
            ++i;
        }
    }

    public void nodeChanged(String nodeName, NodeChangeSummary changes) {
        if (this._node == null || !this._node.getName().equals(nodeName)) {
            return;
        }
        if (changes != null && changes._propertiesChanged != null) {
            int propertiesChangedIndex = 0;
            while (propertiesChangedIndex < changes._propertiesChanged.length) {
                Change change = changes._propertiesChanged[propertiesChangedIndex];
                String propertyName = change._sourceId;
                SpaceTimeProperty property = this._node.getProperty(propertyName);
                if (property != null) {
                    boolean propertyInTree;
                    DefaultMutableTreeNode propertyTreeNode = (DefaultMutableTreeNode)this._propertyToTreeNodeMap.get(propertyName);
                    boolean bl = propertyInTree = propertyTreeNode != null;
                    if (property.isDisplayed() != propertyInTree) {
                        this.buildTree();
                        return;
                    }
                    if (propertyTreeNode != null) {
                        propertyTreeNode.setUserObject(property.getDisplayLabelAndValueString());
                        this._treeModel.nodeChanged(propertyTreeNode);
                    }
                }
                ++propertiesChangedIndex;
            }
        }
    }

    public static abstract class EditNodeAction
    extends AbstractAction {
        protected SpaceTimeNode _node;

        public EditNodeAction(String name) {
            super(name);
        }

        public void setNode(SpaceTimeNode node) {
            this._node = node;
            this.setEnabled(node != null);
        }
    }
}

