/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.RoomRequest;
import SpaceTime.DataModel.RoomRequestImpl;
import SpaceTime.DataModel.TimeSlot;
import SpaceTime.DataModel.TimeSlotImpl;
import edu.cmu.cs.radar.integ.ICMRadarRequires;
import edu.cmu.cs.radar.integ.IRadarServices;
import edu.cmu.cs.radar.integ.ISTMProvides;
import edu.cmu.cs.radar.rhai.spacetime.STMBackendController;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeWindowFrame;
import edu.cmu.cs.radar.stp.cachingdatamodel.EventAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeSession;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ArchitectureEntry
implements ISTMProvides {
    private SpaceTimeWindowFrame _frame;
    private IRadarServices _radarServices;
    private SpaceTimeSession _stmSession;
    private Logger _logger = Logger.getLogger("STM:SHIM");

    public ArchitectureEntry() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean initialize(IRadarServices radarServices) {
        this._radarServices = radarServices;
        Services.radar = radarServices;
        boolean configureLog4j = false;
        if (Services.radar.getClass().getName().endsWith("RadarServicesLight")) {
            configureLog4j = true;
        }
        Services.initLogger(configureLog4j);
        this._stmSession = STMBackendController.startSTMBackend(this._radarServices.getProps());
        if (this._stmSession == null) {
            this._logger.warn("initialize() returning false; was unable to connect to st backend");
            return false;
        }
        SpaceTimeDataAdapter dataAdapter = this._stmSession.getDataAdapter();
        if (dataAdapter == null) {
            this._logger.warn("initialize() returning false; was unable to connect to st backend");
            return false;
        }
        String mode = this._radarServices.getProps().getProperty("radar.mode", "test");
        boolean isTrainingMode = mode.equalsIgnoreCase("training");
        dataAdapter.getParameters().trainingMode(isTrainingMode);
        EventAdapter roomRequestListener = new EventAdapter(){

            public void roomsRequested(RoomRequest[] roomRequests) {
                Runnable runFindRoom = new Runnable(this, roomRequests){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ RoomRequest[] val$roomRequests;
                    {
                        this.this$1 = var1_1;
                        this.val$roomRequests = roomRequestArray;
                    }

                    public void run() {
                        int roomRequestIndex = 0;
                        while (roomRequestIndex < this.val$roomRequests.length) {
                            RoomRequestImpl roomRequestImpl = (RoomRequestImpl)this.val$roomRequests[roomRequestIndex];
                            ArchitectureEntry.access$0(1.access$0(this.this$1)).info("calling findRoom()");
                            ArchitectureEntry.access$1(1.access$0(this.this$1)).findRoom(roomRequestImpl.toCMRadarFormat());
                            ++roomRequestIndex;
                        }
                    }
                };
                new Thread(runFindRoom).start();
            }

            static /* synthetic */ ArchitectureEntry access$0(1 var0) {
                return var0.ArchitectureEntry.this;
            }
        };
        dataAdapter.addEventListener(roomRequestListener);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ArchitectureEntry.this._frame = new SpaceTimeWindowFrame(ArchitectureEntry.this._stmSession, ArchitectureEntry.this._radarServices);
                }
            });
        }
        catch (InterruptedException ex) {
            this._logger.error("opening SpaceTime GUI", ex);
            return false;
        }
        catch (InvocationTargetException ex) {
            this._logger.error("opening SpaceTime GUI", ex);
            return false;
        }
        return true;
    }

    public boolean shutdown() {
        if (this._stmSession != null) {
            this._stmSession.shutdown();
        }
        if (this._frame != null) {
            this._frame.dispose();
        }
        return true;
    }

    public void show() {
        if (this._frame == null) {
            return;
        }
        this._frame.show();
        this._radarServices.deiconify((Frame)this._frame);
    }

    public void hide() {
        if (this._frame == null) {
            return;
        }
        this._frame.hide();
        this._radarServices.iconify((Frame)this._frame);
    }

    public void foundARoom(ICMRadarRequires.Reservation reservation) {
        if (this._stmSession != null) {
            this._stmSession.getDataAdapter().submitRoomReservation(reservation);
        }
    }

    public void vendorEmailArrived(String extraction) {
        if (this._stmSession != null) {
            this._stmSession.processVOP(extraction);
        }
    }

    public void updateRoomStatistics(ICMRadarRequires.RoomStat[] stats) {
        TimeSlot[] slots = new TimeSlot[stats.length];
        int i = 0;
        while (i < slots.length) {
            slots[i] = new TimeSlotImpl(stats[i]);
            ++i;
        }
        this._stmSession.getDataAdapter().updateTimeSlots(slots);
    }

    static /* synthetic */ Logger access$0(ArchitectureEntry architectureEntry) {
        return architectureEntry._logger;
    }
}

