/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.Time;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Date;
import javax.swing.JLayeredPane;

public abstract class TimeView
extends JLayeredPane {
    public static final Color HOUR_GRAY = new Color(160, 160, 160);
    public static final Color QUARTER_HOUR_GRAY = new Color(224, 224, 224);
    protected Time.Range mRange;

    public TimeView(Time.Range range) {
        this.setRange(range);
        this.setBackground(null);
    }

    public Time.Range getRange() {
        return this.mRange;
    }

    public Time getStart() {
        return this.mRange.getStart();
    }

    public Time getEnd() {
        return this.mRange.getEnd();
    }

    public void setRange(Time.Range range) {
        if (range == null) {
            throw new NullPointerException("argument 'range'");
        }
        this.mRange = range;
        this.revalidate();
    }

    public double getValueForDate(Date date) {
        return this.getValueForTime(new Time(date));
    }

    public double getValueForTime(Time time) {
        double ratio = Time.interpolate(this.getStart(), this.getEnd(), time);
        return ratio * (double)(this.getHeight() - 1);
    }

    public int getValueForTimeAsInteger(Time time) {
        return (int)Math.rint(this.getValueForTime(time));
    }

    public double getValueForTimeRange(Time.Duration duration) {
        double ratio = this.getRange().ratio(duration);
        return ratio * (double)(this.getHeight() - 1);
    }

    public int getValueForTimeRangeAsInteger(Time.Duration duration) {
        return (int)Math.rint(this.getValueForTimeRange(duration));
    }

    public Time getTimeForValue(double value) {
        double height = this.getHeight() - 1;
        double ratio = value / height;
        return Time.interpolate(this.getStart(), this.getEnd(), ratio);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, (int)Math.ceil(this.mRange.getDuration().getMinutes() * 1.0));
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, (int)Math.ceil(this.mRange.getDuration().getMinutes() * 1.0));
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        super.paint(g2);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color bg = this.getBackground();
        if (bg != null) {
            g.setColor(bg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

