/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.CalendarObject;
import edu.cmu.cs.radar.rhai.calendar.DateTime;
import edu.cmu.cs.radar.rhai.calendar.SimpleCalendarObject;

public class Event
extends SimpleCalendarObject {
    protected String mSummary;
    protected String mLocation;
    protected boolean mIsTimeSlot = false;

    public Event(String id, DateTime start, DateTime end) {
        this(id, start, end, 2, "", "");
    }

    public Event(String id, DateTime.Range range, String summary, String location) {
        this(id, range.getStart(), range.getEnd(), summary, location);
    }

    public Event(String id, DateTime start, DateTime end, String summary, String location) {
        this(id, start, end, 2, summary, "");
    }

    public Event(String id, DateTime start, DateTime end, int layer, String summary, String location) {
        super(id, start, end, layer);
        this.mSummary = summary;
        this.mLocation = location;
    }

    public void setSummary(String summary) {
        this.mSummary = summary;
        this.mIsTimeSlot = false;
    }

    public String getSummary() {
        return this.mSummary;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public boolean isTimeSlot() {
        return this.mIsTimeSlot;
    }

    protected void fireSummaryChanged() {
        Object[] listeners = this.mListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            CalendarObject.Listener listener = (CalendarObject.Listener)listeners[i];
            if (listener instanceof Listener) {
                ((Listener)listener).summaryChanged(this);
            }
            listener.propertyChanged(this, "SUMMARY");
            ++i;
        }
    }

    protected void fireLocationChanged() {
        Object[] listeners = this.mListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            CalendarObject.Listener listener = (CalendarObject.Listener)listeners[i];
            if (listener instanceof Listener) {
                ((Listener)listener).locationChanged(this);
            }
            listener.propertyChanged(this, "LOCATION");
            ++i;
        }
    }

    public static interface Listener
    extends CalendarObject.Listener {
        public void summaryChanged(Event var1);

        public void locationChanged(Event var1);
    }
}

