/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.corelight;

import cmradar.CMRadarShim;
import edu.cmu.cs.radar.integ.ICMRadarProvides;
import edu.cmu.cs.radar.integ.ICMRadarRequires;
import edu.cmu.cs.radar.integ.IRadarServices;
import edu.cmu.cs.radar.integ.ISTMProvides;
import edu.cmu.cs.radar.rhai.spacetime.ArchitectureEntry;
import edu.cmu.lti.javelin.annotationsdb.corpus.Document;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.mail.internet.MimeMessage;

public class RadarServicesLight
implements IRadarServices {
    Properties _properties = new Properties();
    ISTMProvides _stm;
    ICMRadarProvides _cmradar;

    public static void main(String[] args) throws IOException {
        if (args.length >= 1) {
            try {
                RadarServicesLight radar = new RadarServicesLight(args[0]);
                System.out.println("RadarCoreLight ready.");
                System.out.print("Hit return to exit.");
                System.out.flush();
                System.in.read();
                System.out.println("Exiting");
                radar.shutdown();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        } else {
            System.out.println("missing argument: path to radar.properties");
        }
        System.exit(0);
    }

    public RadarServicesLight(String _configFile) throws IOException {
        FileInputStream in = new FileInputStream(_configFile);
        this._properties.load(in);
        in.close();
        System.out.println("starting stm");
        this._stm = new ArchitectureEntry();
        this._stm.initialize((IRadarServices)this);
        this._stm.show();
        System.out.println("stm started");
        System.out.println("starting cmradar");
        this._cmradar = new CMRadarShim();
        this._cmradar.initialize((IRadarServices)this);
        System.out.println("cmradar started");
    }

    public void shutdown() {
        try {
            System.out.print("shutdown stm: ");
            this._stm.hide();
            if (this._stm.shutdown()) {
                System.out.println("ok");
            } else {
                System.out.println("error");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        try {
            System.out.println("shutdown cmradar: ");
            if (this._cmradar.shutdown()) {
                System.out.println("ok");
            } else {
                System.out.println("error");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public void findRoom(ICMRadarProvides.EventInformation ei) {
        this._cmradar.requestRoom(ei);
    }

    public void foundRoom(ICMRadarRequires.Reservation rsrv) {
        this._stm.foundARoom(rsrv);
    }

    public void updateProbabilities(Vector data) {
        ICMRadarRequires.RoomStat[] stats = new ICMRadarRequires.RoomStat[data.size()];
        int i = 0;
        while (i < stats.length) {
            stats[i] = (ICMRadarRequires.RoomStat)data.get(i);
            ++i;
        }
        this._stm.updateRoomStatistics(stats);
    }

    public void deiconify(Frame x) {
    }

    public Properties getProps() {
        return this._properties;
    }

    public String getRoot() {
        return null;
    }

    public String getUser() {
        return null;
    }

    public void iconify(Frame x) {
    }

    public void explore(String url) {
    }

    public void invokeWbE(String filePath) {
    }

    public void userRequestsEventEdit(String eventId) {
    }

    public void userRequestsRoomEdit(String roomId) {
    }

    public void setTaskKVP(String taskId, String key, String val) {
    }

    public void setTaskContents(String taskId, String contents) {
    }

    public void setTaskState(String taskId, String state) {
    }

    public void sendEMail(MimeMessage msg) {
    }

    public MimeMessage getMessage(String messageID) {
        return null;
    }

    public Document getDocument(String messageId) {
        return null;
    }

    public void showBA(String taskId) {
    }

    public void invokeWbE(String progName, String dataURL) {
    }

    public void taskDone(String messageID, String xmlBlock) {
    }

    public boolean condIsMinusL() {
        return false;
    }

    public boolean condIsNotRadar() {
        return false;
    }

    public boolean condIsPlusL() {
        return true;
    }

    public void setFormComplete(String msgId) {
    }
}

